/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.cache;

import com.yonyou.iuap.cache.serializer.Serializer;
import com.yonyou.iuap.cache.serializer.impl.DefaultJDKSerializer;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.JedisUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public class CacheManager {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Serializer serializer = new DefaultJDKSerializer();
    private JedisTemplate jedisTemplate;

    public JedisTemplate getJedisTemplate() {
        return this.jedisTemplate;
    }

    public void setJedisTemplate(JedisTemplate jedisTemplate) {
        this.jedisTemplate = jedisTemplate;
    }

    public <T extends Serializable> void set(final String key, final T value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] valueBytes = CacheManager.this.serializer.marshalToByte(value);
                jedis.set(keyBytes, valueBytes);
            }
        });
    }

    public <T extends Serializable> void setex(final String key, final T value, final int timeout) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] valueBytes = CacheManager.this.serializer.marshalToByte(value);
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                jedis.setex(keyBytes, timeout, valueBytes);
            }
        });
    }

    public void expire(final String key, final int timeout) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.expire(key, timeout);
            }
        });
    }

    public <T extends Serializable> void setAndExpireInPipeline(final String key, final T value, final int timeout) {
        this.jedisTemplate.execute(new JedisTemplate.PipelineActionNoResult(){

            public void action(Pipeline pipeline) {
                byte[] valueBytes = CacheManager.this.serializer.marshalToByte(value);
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                pipeline.set(keyBytes, valueBytes);
                pipeline.expire(key, timeout);
            }
        });
    }

    public void piplineExecute(JedisTemplate.PipelineActionNoResult action) {
        this.execute(action);
    }

    public <T> List<T> piplineExecute(JedisTemplate.PipelineAction action) {
        return this.execute(action);
    }

    public Boolean exists(final String key) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.exists(key);
            }
        });
    }

    public <T extends Serializable> T get(final String key) {
        return (T)((Serializable)this.execute(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                if (keyBytes == null) {
                    return null;
                }
                byte[] valueBytes = jedis.get(keyBytes);
                if (valueBytes == null) {
                    return null;
                }
                return CacheManager.this.serializer.unMarshal(valueBytes);
            }
        }));
    }

    public <T extends Serializable> T hget(final String key, final String fieldName) {
        return (T)((Serializable)this.execute(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                byte[] fieldBytes;
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] attrBytes = jedis.hget(keyBytes, fieldBytes = fieldName.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET)));
                if (attrBytes == null) {
                    return null;
                }
                return CacheManager.this.serializer.unMarshal(attrBytes);
            }
        }));
    }

    public <T extends Serializable> List<T> hmget(final String key, final String ... fieldName) {
        return (List)this.execute(new JedisAction<List<T>>(){

            @Override
            public List<T> action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[][] fieldBytes = new byte[fieldName.length][];
                for (int i = 0; i < fieldName.length; ++i) {
                    fieldBytes[i] = fieldName[i].getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                }
                List resultList = jedis.hmget(keyBytes, (byte[][])fieldBytes);
                if (resultList == null || resultList.isEmpty()) {
                    return null;
                }
                return CacheManager.this.serializer.unMarshal(resultList);
            }
        });
    }

    public Boolean hexists(final String key, final String field) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.hexists(key, field);
            }
        });
    }

    public Map<byte[], byte[]> hgetAll(final String key) {
        return this.execute(new JedisAction<Map<byte[], byte[]>>(){

            @Override
            public Map<byte[], byte[]> action(Jedis jedis) {
                return jedis.hgetAll(key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET)));
            }
        });
    }

    public <T extends Serializable> void hset(final String key, final String fieldName, final T value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] fieldBytes = fieldName.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] valueBytes = CacheManager.this.serializer.marshalToByte(value);
                jedis.hset(keyBytes, fieldBytes, valueBytes);
            }
        });
    }

    public <T extends Serializable> void hmset(final String key, final Map<String, T> valueMap) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                HashMap<byte[], byte[]> byteDataMap = new HashMap<byte[], byte[]>();
                for (Map.Entry entry : valueMap.entrySet()) {
                    byteDataMap.put(((String)entry.getKey()).getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET)), CacheManager.this.serializer.marshalToByte((Serializable)entry.getValue()));
                }
                jedis.hmset(keyBytes, byteDataMap);
            }
        });
    }

    public void removeCache(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            this.jedisTemplate.del(new String[]{key});
        }
    }

    public void hdel(String key, String field) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)field)) {
            this.jedisTemplate.hdel(key, new String[]{field});
        }
    }

    public void hdel(String key, String ... field) {
        if (field != null && field.length > 0) {
            this.jedisTemplate.hdel(key, field);
        }
    }

    public void initNumForIncr(String key, long initValue) {
        this.jedisTemplate.set(key, String.valueOf(initValue));
    }

    public Long incr(String key) {
        return this.jedisTemplate.incr(key);
    }

    public Long decr(String key) {
        return this.jedisTemplate.decr(key);
    }

    public <T> T execute(JedisAction<T> jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisTemplate.getJedisPool().getResource();
            T t = jedisAction.action(jedis);
            return t;
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public void execute(JedisActionNoResult jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisTemplate.getJedisPool().getResource();
            jedisAction.action(jedis);
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public void execute(JedisTemplate.PipelineActionNoResult pipelineAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisTemplate.getJedisPool().getResource();
            Pipeline pipeline = jedis.pipelined();
            pipelineAction.action(pipeline);
            pipeline.sync();
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public List<Object> execute(JedisTemplate.PipelineAction pipelineAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisTemplate.getJedisPool().getResource();
            Pipeline pipeline = jedis.pipelined();
            pipelineAction.action(pipeline);
            List list = pipeline.syncAndReturnAll();
            return list;
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleJedisException(JedisException jedisException) {
        if (jedisException instanceof JedisConnectionException) {
            this.logger.error("Redis connection " + this.jedisTemplate.getJedisPool().getAddress() + " lost.", (Throwable)jedisException);
            return true;
        } else if (jedisException instanceof JedisDataException) {
            if (jedisException.getMessage() == null || jedisException.getMessage().indexOf("READONLY") == -1) return false;
            this.logger.error("Redis connection " + this.jedisTemplate.getJedisPool().getAddress() + " are read-only slave.", (Throwable)jedisException);
            return true;
        } else {
            this.logger.error("Jedis exception happen.", (Throwable)jedisException);
        }
        return true;
    }

    protected void closeResource(Jedis jedis, boolean conectionBroken) {
        try {
            if (conectionBroken) {
                this.jedisTemplate.getJedisPool().returnBrokenResource(jedis);
            } else {
                this.jedisTemplate.getJedisPool().returnResource(jedis);
            }
        }
        catch (Exception e) {
            this.logger.error("return back jedis failed, will fore close the jedis.", (Throwable)e);
            JedisUtils.destroyJedis((Jedis)jedis);
        }
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public static interface JedisActionNoResult {
        public void action(Jedis var1);
    }

    public static interface JedisAction<T> {
        public T action(Jedis var1);
    }
}

