/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.cache.aop;

import com.yonyou.iuap.cache.CacheManager;
import com.yonyou.iuap.cache.aop.CacheOperate;
import com.yonyou.iuap.cache.entity.CacheAbleEntity;
import java.io.Serializable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheAspect.class);
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void process(ProceedingJoinPoint joinPoint, CacheOperate operate) throws Throwable {
        try {
            LOGGER.info("aspect method [{}] of object [{}] by params [{}]!", new Object[]{joinPoint.getSignature().getName(), joinPoint.getTarget(), joinPoint.getArgs()});
            Object[] args = joinPoint.getArgs();
            if (args == null || args.length == 0) {
                LOGGER.info("args is empty,return !");
                return;
            }
            Object obj = args[0];
            if (obj instanceof CacheAbleEntity) {
                CacheAbleEntity cae = (CacheAbleEntity)obj;
                switch (operate.operationType()) {
                    case UPDATE: {
                        String key = cae.getCacheKey();
                        Serializable valueObj = cae.getUpdateValue();
                        this.cacheManager.set(key, valueObj);
                        break;
                    }
                    case REMOVE: {
                        String removeKey = cae.getCacheKey();
                        this.cacheManager.removeCache(removeKey);
                        break;
                    }
                    default: {
                        LOGGER.info("do nothing about {}", (Object)operate.operationType());
                        break;
                    }
                }
            } else {
                LOGGER.info("\u64cd\u4f5c\u53c2\u6570\u672a\u5b9e\u73b0CacheAbleEntity!");
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("invoke CacheAspect failed", (Throwable)e);
        }
        joinPoint.proceed();
    }
}

