/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.cache.aop;

import com.yonyou.iuap.cache.anotation.Clearable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springside.modules.nosql.redis.JedisTemplate;

public class ClearCacheService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisTemplate jedisTemplate;

    public void clearCache(JoinPoint jp) {
        this.logger.info("\u88ab\u4ee3\u7406\u65b9\u6cd5\u540d\u5b57\uff1a" + jp.getSignature().getName());
        this.logger.info("\u88ab\u4ee3\u7406\u65b9\u6cd5\u53c2\u6570\uff1a" + jp.getArgs());
        this.logger.info("\u88ab\u4ee3\u7406\u5bf9\u8c61\uff1a" + jp.getTarget());
        Object object = null;
        if (jp.getArgs().length > 0) {
            object = jp.getArgs()[0];
        }
        if (object == null) {
            return;
        }
        try {
            if (object.getClass().getAnnotation(Clearable.class) != null) {
                Clearable annotation = object.getClass().getAnnotation(Clearable.class);
                String cacheAttrKey = annotation.keyAttr();
                String keyAttrValue = this.getAttrValueByKey(object, cacheAttrKey);
                this.logger.info("\u6e05\u9664key\u4e3a" + keyAttrValue + "\u7684redis\u7f13\u5b58!");
                this.jedisTemplate.del(new String[]{keyAttrValue});
            }
        }
        catch (Exception e) {
            this.logger.error("\u6e05\u9664\u7f13\u5b58\u5931\u8d25!", (Throwable)e);
        }
    }

    private String getAttrValueByKey(Object good, String attrKey) {
        AccessibleObject[] fields = good.getClass().getDeclaredFields();
        String[] name = new String[fields.length];
        Object[] value = new Object[fields.length];
        String result = null;
        try {
            Field.setAccessible(fields, true);
            for (int i = 0; i < name.length; ++i) {
                name[i] = ((Field)fields[i]).getName();
                value[i] = ((Field)fields[i]).get(good);
                if (!attrKey.equals(name[i]) || value[i] == null) continue;
                result = String.valueOf(value[i]);
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5c5e\u6027\u503c\u5931\u8d25\uff0c\u5c5e\u6027\u540d\u79f0\u662f\uff1a" + attrKey + ".");
        }
        return result;
    }
}

