/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.lock;

import com.yonyou.iuap.lock.context.LockThreadContext;
import com.yonyou.iuap.lock.exception.LockException;
import com.yonyou.iuap.lock.zklock.ZkNodeLockManager;
import com.yonyou.iuap.lock.zkpool.ZkPool;
import java.util.ArrayList;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLock {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLock.class);

    public static boolean lock(String lock) throws LockException {
        if (LockThreadContext.getThreadLockCount(lock) > 0) {
            LockThreadContext.incre(lock);
            return true;
        }
        CuratorFramework client = ZkPool.getClient();
        boolean locked = false;
        try {
            locked = ZkNodeLockManager.getLock(client, lock);
            ZkPool.returnClient(client);
            if (locked) {
                LockThreadContext.incre(lock);
            }
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NodeExistsException) {
                ZkPool.returnClient(client);
            }
            ZkPool.returnBrokenClient(client);
        }
        return locked;
    }

    public static boolean lock(String[] locks) {
        boolean locked = true;
        ArrayList<String> lockedList = new ArrayList<String>();
        for (int i = 0; i < locks.length; ++i) {
            boolean l = false;
            try {
                l = DistributedLock.lock(locks[i]);
            }
            catch (LockException e) {
                logger.error("get lock for parh {} error in batch lock!", (Object)locks[i]);
            }
            if (!l) {
                DistributedLock.unlock(lockedList.toArray(new String[0]));
                locked = false;
                break;
            }
            lockedList.add(locks[i]);
        }
        return locked;
    }

    public static void unlock(String lock) {
        if (LockThreadContext.getThreadLockCount(lock) > 1) {
            LockThreadContext.decre(lock);
            return;
        }
        CuratorFramework client = ZkPool.getClient();
        try {
            boolean isRelease = ZkNodeLockManager.releaseLock(client, lock);
            ZkPool.returnClient(client);
            if (isRelease) {
                LockThreadContext.remove(lock);
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u9501\u5931\u8d25!!!!", (Throwable)e);
            ZkPool.returnBrokenClient(client);
        }
    }

    public static void unlock(String[] locks) {
        for (int i = 0; i < locks.length; ++i) {
            DistributedLock.unlock(locks[i]);
        }
    }
}

