/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.lock;

import com.yonyou.iuap.lock.context.LockThreadContext;
import com.yonyou.iuap.lock.exception.LockException;
import com.yonyou.iuap.lock.zklock.AbstractLockAction;
import com.yonyou.iuap.lock.zklock.InterProcessMutexManager;
import com.yonyou.iuap.lock.zklock.ZkNodeLockManager;
import com.yonyou.iuap.lock.zkpool.ZkPool;
import com.yonyou.iuap.utils.PropertyUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockTemplate {
    private static final Logger logger = LoggerFactory.getLogger(LockTemplate.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(AbstractLockAction action) throws LockException {
        String lockPath = action.getLockPath();
        if (StringUtils.isBlank((String)lockPath)) {
            throw new LockException("lock path is null!", 3);
        }
        if (lockPath.contains("/")) {
            throw new LockException("lock path can not contains / .", 3);
        }
        if (action.getClient() == null) {
            throw new LockException("client is null! please check the pool conf.", 5);
        }
        boolean clientBroken = false;
        try {
            if ("wait".equals(PropertyUtil.getPropertyByKey((String)"zklock.connection.type"))) {
                LockTemplate.processWithLock(action, lockPath);
            } else {
                LockTemplate.processWithZkNode(action, lockPath);
            }
        }
        catch (Exception e) {
            if (e instanceof LockException) {
                LockException le = (LockException)e;
                if (5 == le.getLockErrorType()) {
                    clientBroken = true;
                }
                throw e;
            }
            logger.error("lock error for parh " + lockPath, (Throwable)e);
        }
        finally {
            if (clientBroken) {
                ZkPool.returnBrokenClient(action.getClient());
            } else if (action.getClient() != null && action.getClient().getState() == CuratorFrameworkState.STARTED) {
                ZkPool.returnClient(action.getClient());
            } else {
                ZkPool.returnBrokenClient(action.getClient());
            }
        }
    }

    private static void processWithZkNode(AbstractLockAction action, String lockPath) throws LockException {
        boolean locked = false;
        if (LockThreadContext.getThreadLockCount(lockPath) > 0) {
            LockThreadContext.incre(lockPath);
            locked = true;
        } else {
            try {
                locked = ZkNodeLockManager.getLock(action.getClient(), lockPath);
                if (locked) {
                    LockThreadContext.incre(lockPath);
                }
            }
            catch (Exception e) {
                logger.error("lock error for parh " + lockPath, (Throwable)e);
                if (e instanceof KeeperException.NodeExistsException) {
                    throw new LockException("get lock fail.", 1);
                }
                throw new LockException("get lock fail.", 5);
            }
        }
        if (locked) {
            action.doInLock();
            if (action.getClient() != null) {
                if (LockThreadContext.getThreadLockCount(lockPath) > 1) {
                    LockThreadContext.decre(lockPath);
                } else {
                    try {
                        boolean isRelease = ZkNodeLockManager.releaseLock(action.getClient(), lockPath);
                        if (isRelease) {
                            LockThreadContext.remove(lockPath);
                        }
                    }
                    catch (Exception e) {
                        logger.error("release lock error for parh " + lockPath, (Throwable)e);
                        if (e instanceof KeeperException.ConnectionLossException) {
                            throw new LockException("release lock fail.", 5);
                        }
                        throw new LockException("release lock fail.", 2);
                    }
                }
            }
        }
    }

    private static void processWithLock(AbstractLockAction action, String lockPath) throws LockException {
        boolean locked = InterProcessMutexManager.getLock(action, lockPath);
        if (!locked) {
            throw new LockException("get lock fail.", 1);
        }
        action.doInLock();
        if (action.getClient() != null) {
            InterProcessMutexManager.releaseLock(action, lockPath);
        }
    }
}

