/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.lock.context;

import java.util.HashMap;
import java.util.Map;

public class LockThreadContext {
    private static final ThreadLocal<Map<String, Integer>> threadLocal = new ThreadLocal<Map<String, Integer>>(){

        @Override
        protected Map<String, Integer> initialValue() {
            return new HashMap<String, Integer>();
        }
    };

    public static int getThreadLockCount(String lockPath) throws IllegalArgumentException {
        if (lockPath == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        Map<String, Integer> lockMap = threadLocal.get();
        Integer lockCount = lockMap.get(lockPath);
        if (lockCount == null) {
            lockCount = 0;
        }
        return lockCount;
    }

    public static int incre(String lockPath) throws IllegalArgumentException {
        if (lockPath == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        Map<String, Integer> lockMap = threadLocal.get();
        Integer lockCount = lockMap.get(lockPath);
        lockCount = lockCount != null ? Integer.valueOf(lockCount + 1) : Integer.valueOf(1);
        lockMap.put(lockPath, lockCount);
        return lockCount;
    }

    public static int decre(String lockPath) throws IllegalArgumentException {
        if (lockPath == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        Map<String, Integer> lockMap = threadLocal.get();
        Integer lockCount = lockMap.get(lockPath);
        lockCount = lockCount != null ? Integer.valueOf(lockCount - 1) : Integer.valueOf(0);
        lockMap.put(lockPath, lockCount);
        return lockCount;
    }

    public static void remove(String lockPath) throws IllegalArgumentException {
        if (lockPath == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        Map<String, Integer> lockMap = threadLocal.get();
        if (lockMap != null) {
            lockMap.remove(lockPath);
        }
    }

    public static Map<String, Integer> getDisLocksInCurrentThread() {
        return threadLocal.get();
    }

    public static void reset() {
        threadLocal.remove();
    }
}

