/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.lock.filter;

import com.yonyou.iuap.lock.context.LockThreadContext;
import com.yonyou.iuap.lock.zkpool.ZkPool;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLockFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLockFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("init DistributedLockFilter!");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block7: {
            chain.doFilter(request, response);
            Map<String, Integer> lockMap = LockThreadContext.getDisLocksInCurrentThread();
            try {
                if (lockMap == null || lockMap.size() <= 0) break block7;
                CuratorFramework client = null;
                try {
                    client = ZkPool.getClient();
                    for (Map.Entry<String, Integer> entry : lockMap.entrySet()) {
                        client.delete().forPath("/IUAP_ZKLOCK_ROOT/" + entry.getKey());
                    }
                    if (client != null) {
                        ZkPool.returnClient(client);
                    }
                }
                catch (Exception e) {
                    if (client != null) {
                        ZkPool.returnBrokenClient(client);
                    }
                }
            }
            catch (Exception e) {
                logger.error("clear dislocks when exit thread error!", (Throwable)e);
            }
        }
        LockThreadContext.reset();
    }

    public void destroy() {
        logger.info("destroy DistributedLockFilter!");
    }
}

