/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.lock.zklock;

import com.yonyou.iuap.lock.exception.LockException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLockManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLockManager.class);

    protected static void initLockRootPath(CuratorFramework client) throws LockException {
        try {
            Stat state = (Stat)client.checkExists().forPath("/IUAP_ZKLOCK_ROOT");
            if (state == null) {
                ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.PERSISTENT)).forPath("/IUAP_ZKLOCK_ROOT");
            }
        }
        catch (Exception e) {
            logger.error("init zklock root node error\uff01", (Throwable)e);
            throw new LockException(e.getMessage(), e, 4);
        }
    }
}

