/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.lock.zklock;

import com.yonyou.iuap.lock.zklock.AbstractLockAction;
import com.yonyou.iuap.lock.zklock.AbstractLockManager;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterProcessMutexManager
extends AbstractLockManager {
    private static final Logger logger = LoggerFactory.getLogger(InterProcessMutexManager.class);
    private static boolean isRootInit = false;

    public static boolean getLock(AbstractLockAction action, String lockPath) {
        boolean result = true;
        try {
            if (!isRootInit) {
                InterProcessMutexManager.initLockRootPath(action.getClient());
                isRootInit = true;
            }
            InterProcessMutex lock = new InterProcessMutex(action.getClient(), "/IUAP_ZKLOCK_ROOT/" + lockPath);
            result = lock.acquire(30L, TimeUnit.SECONDS);
            action.setLock(lock);
        }
        catch (Exception e) {
            result = false;
            if (action.getClient() != null && action.getClient().getState() == CuratorFrameworkState.STARTED) {
                action.getClient().close();
            }
            logger.error("getLock error for parh " + lockPath, (Throwable)e);
        }
        return result;
    }

    public static boolean releaseLock(AbstractLockAction action, String lockPath) {
        boolean result = true;
        try {
            action.getLock().release();
        }
        catch (Exception e) {
            if (action.getClient() != null && action.getClient().getState() == CuratorFrameworkState.STARTED) {
                action.getClient().close();
            }
            logger.error("releaseLock error for parh " + lockPath, (Throwable)e);
            result = false;
        }
        return result;
    }
}

