/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.lock.zklock;

import com.yonyou.iuap.lock.zklock.AbstractLockManager;
import com.yonyou.iuap.utils.PropertyUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkNodeLockManager
extends AbstractLockManager {
    private static boolean isRootInit = false;
    private static Map<String, Integer> LockedMap = new ConcurrentHashMap<String, Integer>();
    private static final Logger logger = LoggerFactory.getLogger(ZkNodeLockManager.class);

    public static boolean containsLock(String lockPath) {
        return LockedMap.containsKey(lockPath);
    }

    private static void addLockCache(String lockPath) {
        LockedMap.put(lockPath, 1);
    }

    private static void removeLockCache(String lockPath) {
        LockedMap.remove(lockPath);
    }

    public static boolean getLock(CuratorFramework client, String lockPath) throws Exception {
        boolean result = false;
        try {
            if (!isRootInit) {
                ZkNodeLockManager.initLockRootPath(client);
                isRootInit = true;
            }
            if (ZkNodeLockManager.containsLock(lockPath)) {
                result = false;
                logger.info("lock existed for path {}.", (Object)lockPath);
            } else {
                ((ACLBackgroundPathAndBytesable)client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath("/IUAP_ZKLOCK_ROOT/" + lockPath, String.valueOf(System.currentTimeMillis()).getBytes());
                ZkNodeLockManager.addLockCache(lockPath);
                result = true;
            }
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NodeExistsException) {
                ZkNodeLockManager.validate(client, lockPath);
                logger.error("lock exist for path " + lockPath);
            } else if (client != null && e instanceof KeeperException.ConnectionLossException) {
                client.close();
                logger.error("getLock error for parh " + lockPath, (Throwable)e);
            }
            throw e;
        }
        return result;
    }

    private static void validate(CuratorFramework client, String lockPath) throws Exception, UnsupportedEncodingException {
        String configAliveTimeStr = PropertyUtil.getPropertyByKey((String)"zklock.maxlocktime");
        if (StringUtils.isBlank((CharSequence)configAliveTimeStr)) {
            return;
        }
        logger.info("lock maxalive time is {} seconds!", (Object)configAliveTimeStr);
        String tsStr = null;
        byte[] nodeData = (byte[])client.getData().forPath("/IUAP_ZKLOCK_ROOT/" + lockPath);
        if (nodeData != null) {
            tsStr = new String(nodeData, "UTF-8");
        }
        if (StringUtils.isNotBlank(tsStr)) {
            long lockTs = Long.parseLong(tsStr);
            long maxAliveSeconds = Long.parseLong(configAliveTimeStr);
            if (maxAliveSeconds * 1000L < System.currentTimeMillis() - lockTs) {
                logger.warn("lock timeout, force delete lock for path {}!", (Object)lockPath);
                try {
                    ((ACLBackgroundPathAndBytesable)client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath("/IUAP_ZKLOCK_ROOT/release/" + lockPath);
                    String recheckTsStr = null;
                    byte[] recheckData = (byte[])client.getData().forPath("/IUAP_ZKLOCK_ROOT/" + lockPath);
                    if (recheckData != null) {
                        recheckTsStr = new String(recheckData, "UTF-8");
                        long reChecklockTs = Long.parseLong(recheckTsStr);
                        if (maxAliveSeconds * 1000L < System.currentTimeMillis() - reChecklockTs) {
                            client.delete().forPath("/IUAP_ZKLOCK_ROOT/" + lockPath);
                        }
                    }
                    client.delete().forPath("/IUAP_ZKLOCK_ROOT/release/" + lockPath);
                }
                catch (Exception e) {
                    logger.warn("force delete lock for path {} error!", (Object)lockPath);
                    throw new KeeperException.ConnectionLossException();
                }
            }
        }
    }

    public static boolean releaseLock(CuratorFramework client, String lockPath) throws Exception {
        boolean result = false;
        try {
            ZkNodeLockManager.removeLockCache(lockPath);
            client.delete().forPath("/IUAP_ZKLOCK_ROOT/" + lockPath);
            result = true;
        }
        catch (Exception e) {
            if (client != null && e instanceof KeeperException.ConnectionLossException) {
                client.close();
            }
            logger.error("releaseLock error for parh " + lockPath, (Throwable)e);
            throw e;
        }
        return result;
    }
}

