/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.lock.zkpool;

import com.yonyou.iuap.utils.PropertyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClientFactory
implements PooledObjectFactory<CuratorFramework> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PooledObject<CuratorFramework> makeObject() throws Exception {
        String zkUrl = PropertyUtil.getPropertyByKey((String)"zklock.url");
        if (StringUtils.isBlank((CharSequence)zkUrl)) {
            zkUrl = PropertyUtil.getPropertyByKey((String)"zklock.url.single");
            if ("cluster".equals(PropertyUtil.getPropertyByKey((String)"zklock.connection.type"))) {
                zkUrl = PropertyUtil.getPropertyByKey((String)"zklock.url.cluster");
            }
        }
        if (StringUtils.isBlank((CharSequence)zkUrl)) {
            this.logger.error("please check config for zklock!");
        }
        CuratorFramework client = CuratorFrameworkFactory.builder().connectString(zkUrl).retryPolicy((RetryPolicy)new RetryNTimes(5, 1000)).connectionTimeoutMs(5000).build();
        client.start();
        this.logger.info("\u521b\u5efaCuratorFramework\u5bf9\u8c61\u6210\u529f!");
        return new DefaultPooledObject((Object)client);
    }

    public void destroyObject(PooledObject<CuratorFramework> p) throws Exception {
        CuratorFramework c = (CuratorFramework)p.getObject();
        if (c != null && c.getState() == CuratorFrameworkState.STARTED) {
            c.close();
        }
    }

    public boolean validateObject(PooledObject<CuratorFramework> p) {
        CuratorFramework c = (CuratorFramework)p.getObject();
        return c != null && CuratorFrameworkState.STARTED == c.getState();
    }

    public void activateObject(PooledObject<CuratorFramework> p) throws Exception {
        CuratorFramework c = (CuratorFramework)p.getObject();
        if (c != null && CuratorFrameworkState.STARTED != c.getState()) {
            c.start();
        }
    }

    public void passivateObject(PooledObject<CuratorFramework> p) throws Exception {
    }
}

