/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.lock.zkpool;

import com.yonyou.iuap.lock.zkpool.ZkClientFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkPool {
    private static final Logger logger = LoggerFactory.getLogger(ZkPool.class);
    private static GenericObjectPool pool;

    public static GenericObjectPool getPool() {
        return pool;
    }

    public static void setPool(GenericObjectPool pool) {
        ZkPool.pool = pool;
    }

    public static GenericObjectPool initPool(GenericObjectPoolConfig conf) {
        if (pool == null) {
            pool = new GenericObjectPool((PooledObjectFactory)new ZkClientFactory(), conf);
        }
        logger.info("init iuap zklock rootpath success!");
        logger.info("active num is " + pool.getNumActive());
        return pool;
    }

    public static CuratorFramework getClient() {
        CuratorFramework obj = null;
        try {
            obj = (CuratorFramework)pool.borrowObject();
            logger.info("\u4ece\u6c60\u4e2d\u83b7\u53d6CuratorFramework\u5bf9\u8c61\u6210\u529f!");
        }
        catch (Exception e) {
            logger.error("get client from zkpool error!", (Throwable)e);
        }
        return obj;
    }

    public static boolean returnClient(Object obj) {
        try {
            pool.returnObject(obj);
            logger.info("\u5411\u6c60\u4e2d\u5f52\u8fd8CuratorFramework\u5bf9\u8c61\u6210\u529f!");
        }
        catch (Exception e) {
            logger.error("\u5411\u6c60\u4e2d\u5f52\u8fd8CuratorFramework\u5bf9\u8c61\u5931\u8d25!", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void returnBrokenClient(Object obj) {
        if (obj != null) {
            try {
                pool.invalidateObject(obj);
                logger.info("\u5411\u6c60\u4e2d\u5f52\u8fd8\u5931\u6548\u7684CuratorFramework\u5bf9\u8c61\u6210\u529f!");
            }
            catch (Exception e) {
                logger.error("\u5411\u6c60\u4e2d\u5f52\u8fd8\u5931\u6548\u7684CuratorFramework\u5bf9\u8c61\u5931\u8d25!!", (Throwable)e);
            }
        }
    }
}

