/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dynamicds.ds;

import com.yonyou.iuap.dynamicds.ds.IDataSourceProvider;
import com.yonyou.iuap.dynamicds.parser.BeanConfigEntity;
import com.yonyou.iuap.dynamicds.parser.DynamicDsConfigParser;
import com.yonyou.iuap.dynamicds.parser.ParseResult;
import java.util.HashMap;
import java.util.List;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.DataSourceProxy;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSourceProvider
implements IDataSourceProvider {
    public static final Logger LOGGER = LoggerFactory.getLogger(DefaultDataSourceProvider.class);
    private HashMap<String, String> dsNameMap = new HashMap();
    private volatile HashMap<String, javax.sql.DataSource> dsMap = new HashMap();

    public HashMap<String, String> getDsNameMap() {
        return this.dsNameMap;
    }

    public void setDsNameMap(HashMap<String, String> dsNameMap) {
        this.dsNameMap = dsNameMap;
    }

    public HashMap<String, javax.sql.DataSource> getDsMap() {
        return this.dsMap;
    }

    public void setDsMap(HashMap<String, javax.sql.DataSource> dsMap) {
        this.dsMap = dsMap;
    }

    @Override
    public String findTenantDataSource(String tenant, String appId) {
        String key = tenant + "_" + appId;
        String dsName = this.dsNameMap.get(key);
        LOGGER.info("\u79df\u6237{}\u5e94\u7528{}\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u540d\u79f0\u4e3a{}!", new Object[]{tenant, appId, dsName});
        return dsName;
    }

    @Override
    public javax.sql.DataSource fetchDataSource(String dsName) throws Exception {
        if (this.dsMap.get(dsName) != null) {
            return this.dsMap.get(dsName);
        }
        LOGGER.error("can not find datasource for dsName,please check the global ds config!!!!");
        throw new RuntimeException();
    }

    private void addDataSource(String dsName, PoolProperties config) {
        DataSource ds = new DataSource((PoolConfiguration)config);
        this.dsMap.put(dsName, (javax.sql.DataSource)ds);
    }

    private void destoryDataSource(javax.sql.DataSource ds) {
        if (ds instanceof DataSourceProxy) {
            DataSource tds = (DataSource)ds;
            tds.close();
        }
    }

    @Override
    public void refreshByConfig(String conf) {
        LOGGER.info(conf);
        try {
            ParseResult result = DynamicDsConfigParser.findNeedRefreshDsConfig(conf, this.dsNameMap, this.dsMap);
            this.dsNameMap.putAll(result.getAddedDsMap());
            List<BeanConfigEntity> addList = result.getAddList();
            for (int i = 0; i < addList.size(); ++i) {
                BeanConfigEntity entity = addList.get(i);
                String beanName = entity.getBeanName();
                PoolProperties props = entity.getProp();
                this.addDataSource(beanName, props);
            }
            List<String> list1 = result.getDeleteDsNames();
            for (int i = 0; i < list1.size(); ++i) {
                this.dsNameMap.remove(list1.get(i));
            }
            List<String> list2 = result.getDeleteDses();
            for (int i = 0; i < list2.size(); ++i) {
                String deleteKey = list2.get(i);
                this.destoryDataSource(this.dsMap.get(deleteKey));
                this.dsMap.remove(deleteKey);
            }
        }
        catch (Exception e) {
            LOGGER.error("refresh dynamic datasources error!", (Throwable)e);
        }
    }

    @Override
    public String getInitConfig() {
        return DynamicDsConfigParser.getInitConfig(this.getDsNameMap());
    }
}

