/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dynamicds.ds;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yonyou.iuap.dynamicds.ds.IDataSourceProvider;
import com.yonyou.iuap.dynamicds.schemas.ISchemasProvider;
import com.yonyou.iuap.utils.PropertyUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.util.Assert;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    public static final String DEFAULT_DS_KEY = "jdbcDataSource";
    public static final String DEFAULT_CATALOG_KEY = "jdbc.catalog";
    public static final Logger LOGGER = LoggerFactory.getLogger(DynamicDataSource.class);
    private IDataSourceProvider dsProvider;
    private ISchemasProvider schemasProvider;
    private Map<Object, Object> targetDataSources;
    private Object defaultTargetDataSource;
    private boolean lenientFallback = true;
    private DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
    private Map<Object, DataSource> resolvedDataSources;
    private DataSource resolvedDefaultDataSource;

    public IDataSourceProvider getDsProvider() {
        return this.dsProvider;
    }

    public void setDsProvider(IDataSourceProvider dsProvider) {
        this.dsProvider = dsProvider;
    }

    public void setSchemasProvider(ISchemasProvider schemasProvider) {
        this.schemasProvider = schemasProvider;
    }

    public ISchemasProvider getSchemasProvider() {
        return this.schemasProvider;
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        this.targetDataSources = targetDataSources;
    }

    public void setDefaultTargetDataSource(Object defaultTargetDataSource) {
        this.defaultTargetDataSource = defaultTargetDataSource;
    }

    public void setLenientFallback(boolean lenientFallback) {
        this.lenientFallback = lenientFallback;
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        this.dataSourceLookup = dataSourceLookup != null ? dataSourceLookup : new JndiDataSourceLookup();
    }

    public void afterPropertiesSet() {
        if (this.targetDataSources == null) {
            throw new IllegalArgumentException("Property 'targetDataSources' is required");
        }
        this.resolvedDataSources = new HashMap<Object, DataSource>(this.targetDataSources.size());
        for (Map.Entry<Object, Object> entry : this.targetDataSources.entrySet()) {
            Object lookupKey = this.resolveSpecifiedLookupKey(entry.getKey());
            DataSource dataSource = this.resolveSpecifiedDataSource(entry.getValue());
            this.resolvedDataSources.put(lookupKey, dataSource);
        }
        if (this.defaultTargetDataSource != null) {
            this.resolvedDefaultDataSource = this.resolveSpecifiedDataSource(this.defaultTargetDataSource);
        }
    }

    protected Object resolveSpecifiedLookupKey(Object lookupKey) {
        return lookupKey;
    }

    protected DataSource resolveSpecifiedDataSource(Object dataSource) throws IllegalArgumentException {
        if (dataSource instanceof DataSource) {
            return (DataSource)dataSource;
        }
        if (dataSource instanceof String) {
            return this.dataSourceLookup.getDataSource((String)dataSource);
        }
        throw new IllegalArgumentException("Illegal data source value - only [javax.sql.DataSource] and String supported: " + dataSource);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        return this.determineTargetDataSource().unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance((Object)this) || this.determineTargetDataSource().isWrapperFor(iface);
    }

    protected DataSource determineTargetDataSource() {
        Assert.notNull(this.resolvedDataSources, (String)"DataSource router not initialized");
        Object lookupKey = this.determineCurrentLookupKey();
        DataSource dataSource = this.resolvedDataSources.get(lookupKey);
        if (dataSource == null && (this.lenientFallback || lookupKey == null)) {
            dataSource = this.resolvedDefaultDataSource;
        }
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    protected Object determineCurrentLookupKey() {
        String tds;
        String key = DEFAULT_DS_KEY;
        if (InvocationInfoProxy.getTenantid() != null && StringUtils.isNotBlank((CharSequence)(tds = this.getTenantDs()))) {
            DataSource resolvedDs = this.resolvedDataSources.get(tds);
            if (resolvedDs == null) {
                try {
                    resolvedDs = this.fetchDataSource(tds);
                    this.resolvedDataSources.put(tds, resolvedDs);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            key = tds;
        }
        LOGGER.debug("\u5f53\u524d\u6570\u636e\u6e90 :" + key);
        return key;
    }

    private synchronized DataSource fetchDataSource(String tds) throws Exception {
        DataSource ds = this.resolvedDataSources.get(tds);
        if (ds == null) {
            ds = this.dsProvider.fetchDataSource(tds);
        }
        return ds;
    }

    private String getTenantDs() {
        return this.dsProvider.findTenantDataSource(InvocationInfoProxy.getTenantid(), InvocationInfoProxy.getSysid());
    }

    public Connection getConnection() throws SQLException {
        Connection con = super.getConnection();
        return this.changeCatalog(con);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        Connection con = super.getConnection(username, password);
        return this.changeCatalog(con);
    }

    protected Connection changeCatalog(Connection con) throws SQLException {
        String catalog = this.getCatalog();
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            try {
                con.setCatalog(catalog);
            }
            catch (SQLException e) {
                LOGGER.error("setting catalog for connection error! tenant catalog is {}", (Object)catalog);
                con.close();
                throw e;
            }
            LOGGER.debug("change catelog for tenant {} success!", (Object)catalog);
        } else {
            String msg = "can not get catalog from context, please check tenantid!";
            LOGGER.warn(msg);
            String defaultCatalog = PropertyUtil.getPropertyByKey((String)DEFAULT_CATALOG_KEY);
            if (StringUtils.isNotBlank((CharSequence)defaultCatalog) && !defaultCatalog.equals(con.getCatalog())) {
                con.setCatalog(defaultCatalog);
                LOGGER.warn("reset catalog for connection success!");
            }
        }
        return con;
    }

    private String getCatalog() {
        String targetCatalog = null;
        String tenantId = InvocationInfoProxy.getTenantid();
        targetCatalog = this.schemasProvider != null && tenantId != null ? this.schemasProvider.findSchemasCode(tenantId, InvocationInfoProxy.getSysid()) : tenantId;
        return targetCatalog;
    }
}

