/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dynamicds.interceptor;

import com.yonyou.iuap.context.InvocationInfoProxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInterceptor {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public void beforeConnection(JoinPoint jp) {
        this.LOGGER.info("\u88ab\u4ee3\u7406\u65b9\u6cd5\u540d\u5b57\uff1a" + jp.getSignature().getName());
        this.LOGGER.info("\u88ab\u4ee3\u7406\u65b9\u6cd5\u53c2\u6570\uff1a" + jp.getArgs());
        this.LOGGER.info("\u88ab\u4ee3\u7406\u5bf9\u8c61\uff1a" + jp.getTarget());
    }

    public Object aroundGetConnection(ProceedingJoinPoint jp) throws Throwable {
        String catalog;
        this.LOGGER.info("\u88ab\u4ee3\u7406\u65b9\u6cd5\u540d\u5b57\uff1a" + jp.getSignature().getName());
        this.LOGGER.info("\u88ab\u4ee3\u7406\u65b9\u6cd5\u53c2\u6570\uff1a" + jp.getArgs());
        this.LOGGER.info("\u88ab\u4ee3\u7406\u5bf9\u8c61\uff1a" + jp.getTarget());
        Object retVal = jp.proceed();
        if (retVal instanceof Connection && StringUtils.isNotBlank((CharSequence)(catalog = InvocationInfoProxy.getTenantid()))) {
            try {
                ((Connection)retVal).setCatalog(catalog);
            }
            catch (SQLException e) {
                this.LOGGER.error("setting catalog for connection error! tenant catalog is {}", (Object)catalog);
                throw e;
            }
            this.LOGGER.debug("change catelog for tenant {} success!", (Object)catalog);
        }
        return retVal;
    }
}

