/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dynamicds.parser;

import com.yonyou.iuap.dynamicds.exception.DynamicDsException;
import com.yonyou.iuap.dynamicds.parser.BeanConfigEntity;
import com.yonyou.iuap.dynamicds.parser.ParseResult;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class DynamicDsConfigParser {
    public static ParseResult findNeedRefreshDsConfig(String conf, HashMap<String, String> existMap, HashMap<String, DataSource> existDsMap) throws DocumentException {
        ParseResult result = new ParseResult();
        HashMap<String, String> addedDsMap = new HashMap<String, String>();
        ArrayList<BeanConfigEntity> addedDs = new ArrayList<BeanConfigEntity>();
        ArrayList<String> deleteDsNameKeys = new ArrayList<String>();
        ArrayList<String> deleteDsKeys = new ArrayList<String>();
        Document doc = DocumentHelper.parseText((String)conf);
        HashMap<String, String> allMap = DynamicDsConfigParser.getDsNamesMap(doc);
        for (Map.Entry<String, String> entry : allMap.entrySet()) {
            if (existMap.containsKey(entry.getKey())) continue;
            addedDsMap.put(entry.getKey(), entry.getValue());
        }
        List<BeanConfigEntity> allList = DynamicDsConfigParser.getDsConfigs(doc);
        for (int i = 0; i < allList.size(); ++i) {
            BeanConfigEntity beanConfigEntity = allList.get(i);
            if (existDsMap.containsKey(beanConfigEntity.getBeanName())) continue;
            addedDs.add(beanConfigEntity);
        }
        for (Map.Entry<String, String> entry : existMap.entrySet()) {
            if (allMap.keySet().contains(entry.getKey())) continue;
            deleteDsNameKeys.add(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : existDsMap.entrySet()) {
            boolean shoudDelete = true;
            for (int i = 0; i < allList.size(); ++i) {
                BeanConfigEntity entity = allList.get(i);
                if (!entity.getBeanName().equals(entry.getKey())) continue;
                shoudDelete = false;
                break;
            }
            if (!shoudDelete) continue;
            deleteDsKeys.add(entry.getKey());
        }
        result.setAddedDsMap(addedDsMap);
        result.setAddList(addedDs);
        result.setDeleteDsNames(deleteDsNameKeys);
        result.setDeleteDses(deleteDsKeys);
        return result;
    }

    private static PoolProperties getPoolPropertiesByElement(Element ele) {
        PoolProperties pf = new PoolProperties();
        String driverClassName = ele.element("driverClassName") == null ? "" : ele.element("driverClassName").getText();
        String url = ele.element("url") == null ? "" : ele.element("url").getText();
        String password = ele.element("password") == null ? "" : ele.element("password").getText();
        String username = ele.element("username") == null ? "" : ele.element("username").getText();
        String defaultCatalog = ele.element("defaultCatalog") == null ? "" : ele.element("defaultCatalog").getText();
        pf.setDriverClassName(driverClassName);
        pf.setUrl(new String(Base64.decodeBase64((String)url)));
        pf.setUsername(username);
        pf.setPassword(password);
        pf.setDefaultCatalog(defaultCatalog);
        return pf;
    }

    private static HashMap<String, String> getDsNamesMap(Document doc) {
        HashMap<String, String> dsNameMap = new HashMap<String, String>();
        Element root = doc.getRootElement();
        List dsnodes = root.selectNodes("//datasource");
        for (Element elm : dsnodes) {
            String key = elm.attributeValue("id");
            String dsBeanName = elm.attributeValue("name");
            dsNameMap.put(key, dsBeanName);
        }
        return dsNameMap;
    }

    public static HashMap<String, String> getDsNamesMap(String docStr) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)docStr);
        return DynamicDsConfigParser.getDsNamesMap(doc);
    }

    private static List<BeanConfigEntity> getDsConfigs(Document doc) {
        ArrayList configList = new ArrayList();
        Element root = doc.getRootElement();
        return DynamicDsConfigParser.getConfigList(root);
    }

    private static List<BeanConfigEntity> getConfigList(Element root) {
        ArrayList<BeanConfigEntity> configList = new ArrayList<BeanConfigEntity>();
        List dsnodes = root.selectNodes("//config");
        for (Element elm : dsnodes) {
            String beanId = elm.attributeValue("id");
            PoolProperties prop = DynamicDsConfigParser.getPoolPropertiesByElement(elm);
            BeanConfigEntity entity = new BeanConfigEntity(beanId, prop);
            configList.add(entity);
        }
        return configList;
    }

    private static boolean isExistConfigEle(String beanName, Element root) {
        boolean result = false;
        List<BeanConfigEntity> configList = DynamicDsConfigParser.getConfigList(root);
        for (int i = 0; i < configList.size(); ++i) {
            if (!beanName.equals(configList.get(i).getBeanName())) continue;
            result = true;
            break;
        }
        return result;
    }

    private PoolProperties getConfigMapByDsBeanName(String beanName, List<HashMap<String, PoolProperties>> list) {
        for (HashMap<String, PoolProperties> hashMap : list) {
            if (hashMap.get(beanName) == null) continue;
            return hashMap.get(beanName);
        }
        return null;
    }

    public static String getInitConfig(HashMap<String, String> dsNameMap) {
        Document doc = DocumentHelper.createDocument();
        Element root = DocumentHelper.createElement((String)"dynamicdsconfig");
        Element datasourcesEle = root.addElement("datasources");
        for (Map.Entry<String, String> entry : dsNameMap.entrySet()) {
            datasourcesEle.addElement("datasource").addAttribute("id", entry.getKey()).addAttribute("name", entry.getValue()).addAttribute("dynamic", "false");
        }
        root.addElement("configs");
        doc.add(root);
        return doc.asXML();
    }

    public static String addDsRelationEle(String key, String value, Map<String, String> dsConfig, String confStr) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)confStr);
        HashMap<String, String> map = DynamicDsConfigParser.getDsNamesMap(confStr);
        if (map.containsKey(key)) {
            throw new DynamicDsException("datasource relation is exist!");
        }
        Element root = doc.getRootElement();
        boolean isBeanExist = DynamicDsConfigParser.isExistConfigEle(value, root);
        Element dataSourcesEle = (Element)root.selectSingleNode("//datasources");
        dataSourcesEle.addElement("datasource").addAttribute("id", key).addAttribute("name", value).addAttribute("dynamic", "true");
        if (!isBeanExist) {
            String defaultCatalog;
            String driverClassName = dsConfig.get("driverClassName") == null ? "" : dsConfig.get("driverClassName");
            String url = dsConfig.get("url") == null ? "" : dsConfig.get("url");
            String password = dsConfig.get("password") == null ? "" : dsConfig.get("password");
            String username = dsConfig.get("username") == null ? "" : dsConfig.get("username");
            String string = defaultCatalog = dsConfig.get("defaultCatalog") == null ? "" : dsConfig.get("defaultCatalog");
            if (StringUtils.isBlank((String)driverClassName) || StringUtils.isBlank((String)url) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)driverClassName) || StringUtils.isBlank((String)url)) {
                throw new DynamicDsException("datasource config have bad params, please check them!");
            }
            Element configsEle = (Element)root.selectSingleNode("//configs");
            Element cfgEle = configsEle.addElement("config").addAttribute("id", value);
            cfgEle.addElement("driverClassName").setText(driverClassName);
            cfgEle.addElement("url").setText(url);
            cfgEle.addElement("password").setText(password);
            cfgEle.addElement("username").setText(username);
            cfgEle.addElement("defaultCatalog").setText(defaultCatalog);
            DynamicDsConfigParser.processEleWithKey(cfgEle, dsConfig, "removeAbandoned");
            DynamicDsConfigParser.processEleWithKey(cfgEle, dsConfig, "removeAbandonedTimeout");
            DynamicDsConfigParser.processEleWithKey(cfgEle, dsConfig, "logAbandoned");
            DynamicDsConfigParser.processEleWithKey(cfgEle, dsConfig, "maxActive");
            DynamicDsConfigParser.processEleWithKey(cfgEle, dsConfig, "maxIdle");
            DynamicDsConfigParser.processEleWithKey(cfgEle, dsConfig, "minIdle");
            DynamicDsConfigParser.processEleWithKey(cfgEle, dsConfig, "maxWait");
            DynamicDsConfigParser.processEleWithKey(cfgEle, dsConfig, "defaultAutoCommit");
            DynamicDsConfigParser.processEleWithKey(cfgEle, dsConfig, "minEvictableIdleTimeMillis");
        }
        return doc.asXML();
    }

    private static void processEleWithKey(Element cfgEle, Map<String, String> dsConfig, String key) {
        String keyValue;
        String string = keyValue = dsConfig.get(key) == null ? "" : dsConfig.get(key);
        if (StringUtils.isNotBlank((String)keyValue)) {
            cfgEle.addElement(key).setText(keyValue);
        }
    }

    public static String deleteDsRelationEle(String key, String value, String confStr) throws DocumentException {
        String xpath;
        Document doc = DocumentHelper.parseText((String)confStr);
        Element root = doc.getRootElement();
        Element datasourcesEle = root.element("datasources");
        Node delNode = datasourcesEle.selectSingleNode(xpath = "datasource[@id='" + key + "' and @name='" + value + "' and @dynamic='true']");
        if (delNode != null) {
            datasourcesEle.remove(delNode);
        }
        return doc.asXML();
    }

    public static String deleteDsConfigEle(String beanName, String confStr) throws DocumentException {
        String xpath;
        Document doc = DocumentHelper.parseText((String)confStr);
        Element configsEle = (Element)doc.selectSingleNode("//configs");
        Node node = configsEle.selectSingleNode(xpath = "config[@id='" + beanName + "']");
        if (node != null) {
            Element ele = (Element)node;
            configsEle.remove(ele);
        }
        return doc.asXML();
    }

    public static void main(String[] args) throws IOException, DocumentException {
        String aaa = "jdbc:mysql://172.20.6.48:3306/uapcloud?useUnicode=true&characterEncoding=utf-8";
        String encodeStr = Base64.encodeBase64URLSafeString((byte[])aaa.getBytes("utf-8"));
        System.out.println(encodeStr);
        String str = FileUtils.readFileToString((File)new File("G:\\dynamicdsconfigs.xml"));
        HashMap<String, String> dsConfig = new HashMap<String, String>();
        dsConfig.put("driverClassName", "com.mysql.jdbc.Driver");
        dsConfig.put("url", "amRiYzpteXNxbDovLzE3Mi4yMC42LjQ4OjMzMDYvZWM_dXNlVW5pY29kZT10cnVlJmNoYXJhY3RlckVuY29kaW5nPXV0Zi04");
        dsConfig.put("username", "root");
        dsConfig.put("password", "root");
        dsConfig.put("defaultCatalog", "ec");
        dsConfig.put("maxActive", "200");
        dsConfig.put("maxIdle", "100");
        String targetStr = DynamicDsConfigParser.addDsRelationEle("tenant11_hr", "datasource11", dsConfig, str);
        System.out.println(targetStr);
        Document doc = DocumentHelper.parseText((String)targetStr);
        StringWriter stringWriter = new StringWriter();
        OutputFormat xmlFormat = new OutputFormat();
        xmlFormat.setEncoding("UTF-8");
        xmlFormat.setNewlines(true);
        xmlFormat.setIndent(true);
        xmlFormat.setIndent("    ");
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, xmlFormat);
        xmlWriter.write(doc);
        xmlWriter.close();
        System.out.println(stringWriter.toString());
    }
}

