/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dynamicds.schemas;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yonyou.iuap.dynamicds.parser.SchemasConfigParser;
import com.yonyou.iuap.dynamicds.schemas.ISchemasProvider;
import com.yonyou.iuap.dynamicds.schemas.SchemaNode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSchemasProvider
implements ISchemasProvider {
    private static final String DEFAULT_BUSIID = "defaultbusi";
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSchemasProvider.class);
    private HashMap<String, SchemaNode> schemasMap = new HashMap();
    private HashMap<String, String> cacheMap = new HashMap();

    public HashMap<String, String> getCacheMap() {
        return this.cacheMap;
    }

    public HashMap<String, SchemaNode> getSchemasMap() {
        return this.schemasMap;
    }

    @Override
    public String findSchemasCode(String tenant, String appId) {
        String key;
        String schemaCode;
        String businessId = InvocationInfoProxy.getParameter((String)"businessid");
        if (StringUtils.isBlank((CharSequence)businessId)) {
            businessId = DEFAULT_BUSIID;
        }
        if (StringUtils.isBlank((CharSequence)(schemaCode = this.cacheMap.get(key = StringUtils.join((Object[])new String[]{tenant, appId, businessId}, (String)"_"))))) {
            schemaCode = this.getSchemaCodeByConditions(tenant, appId, businessId);
            LOGGER.debug("find schemacode from locallist,condition is {}.", (Object)schemaCode);
            if (schemaCode != null) {
                this.cacheMap.put(key, schemaCode);
                LOGGER.debug("cache schemacode success, key is {}, code is {}.", (Object)key, (Object)schemaCode);
            }
        }
        return schemaCode;
    }

    @Override
    public void refreshByConfig(String conf) {
        LOGGER.debug(conf);
        try {
            HashMap<String, SchemaNode> refreshMap = SchemasConfigParser.getRefreshSchemaNodes(conf);
            this.schemasMap.clear();
            this.schemasMap.putAll(refreshMap);
            this.cacheMap.clear();
            LOGGER.debug("refresh schemas conf completed! size is {}.", (Object)this.schemasMap.size());
        }
        catch (Exception e) {
            LOGGER.error("refresh schemas conf error!", (Throwable)e);
        }
    }

    @Override
    public String getInitConfig() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<schema-mapping>");
        builder.append("</schema-mapping>");
        return builder.toString();
    }

    private String getSchemaCodeByConditions(String tid, String appId, String busiId) {
        String result = null;
        for (Map.Entry<String, SchemaNode> entity : this.schemasMap.entrySet()) {
            SchemaNode node = entity.getValue();
            if (!tid.equals(node.getTenant()) || !appId.equals(node.getApp()) || !busiId.equals(node.getBusiness())) continue;
            result = entity.getKey();
            break;
        }
        return result;
    }
}

