/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dynamicds.service;

import com.yonyou.iuap.dynamicds.exception.DynamicDsException;
import com.yonyou.iuap.dynamicds.parser.DynamicDsConfigParser;
import com.yonyou.iuap.dynamicds.service.IDynamicDataSourceService;
import com.yonyou.iuap.dynamicds.utils.ConfigClientUtil;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicDataSourceService
implements IDynamicDataSourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicDataSourceService.class);
    public static final String WATCH_NODE_NAME = "/IUAP_DYNAMICDS_CONF";

    @Override
    public void addDataSourceMapping(String tenant, String app, String dsName, Map<String, String> dsConfig) throws Exception {
        block7: {
            try (CuratorFramework client = ConfigClientUtil.getClient();){
                Stat state = (Stat)client.checkExists().forPath(WATCH_NODE_NAME);
                if (state != null) {
                    byte[] confBytes = (byte[])client.getData().forPath(WATCH_NODE_NAME);
                    if (confBytes != null) {
                        String confStr = new String(confBytes);
                        String key = tenant + "_" + app;
                        String targetStr = DynamicDsConfigParser.addDsRelationEle(key, dsName, dsConfig, confStr);
                        client.setData().forPath(WATCH_NODE_NAME, targetStr.getBytes());
                        break block7;
                    }
                    throw new DynamicDsException("config zknode has not data!");
                }
                throw new DynamicDsException("config zknode does not exist!");
            }
        }
    }

    @Override
    public void deleteDataSourceMapping(String tenant, String app, String dsName) throws Exception {
        block7: {
            try (CuratorFramework client = ConfigClientUtil.getClient();){
                Stat state = (Stat)client.checkExists().forPath(WATCH_NODE_NAME);
                if (state != null) {
                    byte[] confBytes = (byte[])client.getData().forPath(WATCH_NODE_NAME);
                    if (confBytes != null) {
                        String confStr = new String(confBytes);
                        String key = tenant + "_" + app;
                        String targetStr = DynamicDsConfigParser.deleteDsRelationEle(key, dsName, confStr);
                        client.setData().forPath(WATCH_NODE_NAME, targetStr.getBytes());
                        break block7;
                    }
                    throw new DynamicDsException("config zknode has not data!");
                }
                throw new DynamicDsException("config zknode does not exist!");
            }
        }
    }

    @Override
    public void deleteDataSource(String dsName) throws Exception {
        block7: {
            try (CuratorFramework client = ConfigClientUtil.getClient();){
                Stat state = (Stat)client.checkExists().forPath(WATCH_NODE_NAME);
                if (state != null) {
                    byte[] confBytes = (byte[])client.getData().forPath(WATCH_NODE_NAME);
                    if (confBytes != null) {
                        String confStr = new String(confBytes);
                        String targetStr = DynamicDsConfigParser.deleteDsConfigEle(dsName, confStr);
                        client.setData().forPath(WATCH_NODE_NAME, targetStr.getBytes());
                        break block7;
                    }
                    throw new DynamicDsException("config zknode has not data!");
                }
                throw new DynamicDsException("config zknode does not exist!");
            }
        }
    }
}

