/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dynamicds.watcher;

import com.yonyou.iuap.dynamicds.ds.IDataSourceProvider;
import com.yonyou.iuap.dynamicds.utils.ConfigClientUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicDsWatcher {
    public static final Logger LOGGER = LoggerFactory.getLogger(DynamicDsWatcher.class);
    public static final String WATCH_NODE_NAME = "/IUAP_DYNAMICDS_CONF";
    private static IDataSourceProvider dsProvider;

    public IDataSourceProvider getDsProvider() {
        return dsProvider;
    }

    public void setDsProvider(IDataSourceProvider dsProvider) {
        DynamicDsWatcher.dsProvider = dsProvider;
        this.initWatcher();
    }

    private void initWatcher() {
        CuratorFramework client = ConfigClientUtil.getClient();
        try {
            Stat state = (Stat)client.checkExists().forPath(WATCH_NODE_NAME);
            if (state == null) {
                String xmlStr = this.getInitContent();
                client.create().forPath(WATCH_NODE_NAME, xmlStr.getBytes());
            } else {
                byte[] configBytes = (byte[])client.getData().forPath(WATCH_NODE_NAME);
                String configStr = new String(configBytes);
                dsProvider.refreshByConfig(configStr);
            }
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NodeExistsException) {
                LOGGER.info("already init watcher node! ignore it.");
            }
            LOGGER.error("init root node for dynamic datasource error!", (Throwable)e);
        }
        try {
            this.startWatch(client);
        }
        catch (Exception e) {
            LOGGER.error("start listener for dynamic datasource error!", (Throwable)e);
        }
    }

    private String getInitContent() {
        return this.getDsProvider().getInitConfig();
    }

    public void startWatch(CuratorFramework client) throws Exception {
        ExecutorService pool = Executors.newFixedThreadPool(2);
        final NodeCache nodeCache = new NodeCache(client, WATCH_NODE_NAME, false);
        nodeCache.start(true);
        nodeCache.getListenable().addListener((Object)new NodeCacheListener(){

            public void nodeChanged() throws Exception {
                String confStr = new String(nodeCache.getCurrentData().getData());
                LOGGER.info("changed config is {}!", (Object)confStr);
                dsProvider.refreshByConfig(confStr);
            }
        }, (Executor)pool);
    }
}

