/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dynamicds.watcher;

import com.yonyou.iuap.dynamicds.schemas.ISchemasProvider;
import com.yonyou.iuap.dynamicds.utils.ConfigClientUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasMappingWatcher {
    public static final Logger LOGGER = LoggerFactory.getLogger(SchemasMappingWatcher.class);
    public static final String WATCH_NODE_NAME = "/IUAP_SCHEMAS_MAPPING";
    public static final String NODE_DATA_ENCODE = "GBK";
    private static ISchemasProvider schemasProvider;

    public ISchemasProvider getSchemasProvider() {
        return schemasProvider;
    }

    public void setSchemasProvider(ISchemasProvider schemasProvider) {
        SchemasMappingWatcher.schemasProvider = schemasProvider;
        this.initWatcher();
    }

    private void initWatcher() {
        CuratorFramework client = ConfigClientUtil.getClient();
        try {
            Stat state = (Stat)client.checkExists().forPath(WATCH_NODE_NAME);
            if (state == null) {
                String xmlStr = this.getInitContent();
                client.create().forPath(WATCH_NODE_NAME, xmlStr.getBytes());
            } else {
                byte[] configBytes = (byte[])client.getData().forPath(WATCH_NODE_NAME);
                String configStr = new String(configBytes, NODE_DATA_ENCODE);
                schemasProvider.refreshByConfig(configStr);
            }
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NodeExistsException) {
                LOGGER.info("already init watcher node! ignore it.");
            }
            LOGGER.error("init root node for schemas mapping error!", (Throwable)e);
        }
        try {
            this.startWatch(client);
        }
        catch (Exception e) {
            LOGGER.error("start listener forschemas mapping error!", (Throwable)e);
        }
    }

    private String getInitContent() {
        return this.getSchemasProvider().getInitConfig();
    }

    public void startWatch(CuratorFramework client) throws Exception {
        ExecutorService pool = Executors.newFixedThreadPool(2);
        final NodeCache nodeCache = new NodeCache(client, WATCH_NODE_NAME, false);
        nodeCache.start(true);
        nodeCache.getListenable().addListener((Object)new NodeCacheListener(){

            public void nodeChanged() throws Exception {
                String confStr = new String(nodeCache.getCurrentData().getData(), SchemasMappingWatcher.NODE_DATA_ENCODE);
                LOGGER.info("changed config is {}!", (Object)confStr);
                schemasProvider.refreshByConfig(confStr);
            }
        }, (Executor)pool);
    }
}

