/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.base.utils;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yonyou.iuap.generic.sign.SignEntity;
import com.yonyou.iuap.generic.sign.SignMake;
import com.yonyou.iuap.generic.utils.PropertiesUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.MDC;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.ContextLoader;

public class RestUtils {
    private static RestUtils restUtils = null;
    private RestTemplate template;

    public static RestUtils getInstance() {
        if (restUtils == null) {
            restUtils = new RestUtils();
        }
        return restUtils;
    }

    private RestUtils() {
        this.init();
    }

    private void init() {
        ApplicationContext ac = this.getAc();
        this.template = (RestTemplate)ac.getBean("dispatchRestTemplate");
    }

    private ApplicationContext getAc() {
        return ContextLoader.getCurrentWebApplicationContext();
    }

    public <T> T doGet(String url, Object request, Class<T> responseType) {
        return (T)this.doExe(url, request, responseType, HttpMethod.GET);
    }

    public <T> T doPost(String url, Object request, Class<T> responseType) {
        return (T)this.doExe(url, request, responseType, HttpMethod.POST);
    }

    private <T> T doExe(String url, Object request, Class<T> responseType, HttpMethod method) {
        HttpHeaders requestHeaders = new HttpHeaders();
        String cvalue = this.invocationToStr();
        requestHeaders.add("Authority", cvalue);
        HttpEntity requestEntity = new HttpEntity(request, (MultiValueMap)requestHeaders);
        ResponseEntity rss = this.template.exchange(url, method, requestEntity, responseType, new Object[0]);
        return (T)rss.getBody();
    }

    public <T> T doGetWithSign(String url, Object request, Class<T> responseType) {
        return (T)this.doExeWithSign(url, request, responseType, HttpMethod.GET);
    }

    public <T> T doPostWithSign(String url, Object request, Class<T> responseType) {
        return (T)this.doExeWithSign(url, request, responseType, HttpMethod.POST);
    }

    private <T> T doExeWithSign(String url, Object request, Class<T> responseType, HttpMethod method) {
        SignEntity signEntity;
        String prefix = null;
        String authFilePath = null;
        try {
            prefix = PropertiesUtils.getCustomerProperty((String)"context.name");
            authFilePath = PropertiesUtils.getCustomerProperty((String)(prefix + ".client.credential.path"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (method == HttpMethod.POST) {
            JSONObject msgDataJson = JSONObject.fromObject((Object)request);
            signEntity = SignMake.signEntity((String)url, (String)msgDataJson.toString(), (String)prefix, (String)authFilePath);
        } else {
            signEntity = SignMake.signEntity((String)url, null, (String)HttpMethod.GET.toString(), (String)prefix, (String)authFilePath);
        }
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("sign", signEntity.getSign());
        HttpEntity requestEntity = new HttpEntity(request, (MultiValueMap)requestHeaders);
        ResponseEntity rss = this.template.exchange(signEntity.getSignURL(), method, requestEntity, responseType, new Object[0]);
        return (T)rss.getBody();
    }

    private String invocationToStr() {
        String cvalue = "";
        Map data = this.setInvocationInfo();
        if (MapUtils.isNotEmpty((Map)data)) {
            for (Map.Entry entry : data.entrySet()) {
                cvalue = cvalue + (String)entry.getKey() + "=" + (String)entry.getValue() + ";";
            }
        }
        return cvalue;
    }

    private Map<String, String> setInvocationInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (InvocationInfoProxy.getCallid() != null) {
            map.put("u_callid", InvocationInfoProxy.getCallid());
        }
        if (InvocationInfoProxy.getLocale() != null) {
            map.put("u_locale", InvocationInfoProxy.getLocale());
        }
        if (InvocationInfoProxy.getSysid() != null) {
            map.put("u_sysid", InvocationInfoProxy.getSysid());
        }
        if (InvocationInfoProxy.getTenantid() != null) {
            map.put("tenantid", InvocationInfoProxy.getTenantid());
            map.put("current_tenant_id", InvocationInfoProxy.getTenantid());
        }
        if (InvocationInfoProxy.getTheme() != null) {
            map.put("u_theme", InvocationInfoProxy.getTheme());
        }
        if (InvocationInfoProxy.getTimeZone() != null) {
            map.put("u_timezone", InvocationInfoProxy.getTimeZone());
        }
        if (InvocationInfoProxy.getUserid() != null) {
            map.put("u_usercode", InvocationInfoProxy.getUserid());
            map.put("current_user_name", InvocationInfoProxy.getUserid());
        }
        if (InvocationInfoProxy.getUsername() != null) {
            map.put("u_username", InvocationInfoProxy.getUsername());
        }
        if (InvocationInfoProxy.getAppCode() != null) {
            map.put("u_appCode", InvocationInfoProxy.getAppCode());
        }
        if (InvocationInfoProxy.getProviderCode() != null) {
            map.put("u_providerCode", InvocationInfoProxy.getProviderCode());
        }
        if (InvocationInfoProxy.getToken() != null) {
            map.put("token", InvocationInfoProxy.getToken());
        }
        if (InvocationInfoProxy.getLogints() != null) {
            map.put("u_logints", InvocationInfoProxy.getLogints());
        }
        if (InvocationInfoProxy.getParamters() != null) {
            map.putAll(InvocationInfoProxy.getParamters());
        }
        map.put("call_thread_id", String.valueOf(MDC.get((String)"call_thread_id")));
        return map;
    }
}

