/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.common;

import com.yonyou.iuap.dispatch.DailyTimeIntervalTaskConfig;
import com.yonyou.iuap.dispatch.DispatchManager;
import com.yonyou.iuap.dispatch.common.SpringContextUtil;
import com.yonyou.iuap.dispatch.server.common.RecallUtil;
import com.yonyou.iuap.dispatch.server.service.TaskParamService;
import com.yonyou.iuap.dispatch.server.service.TaskRecallParamService;
import com.yonyou.iuap.dispatch.server.service.TaskService;
import com.yonyou.iuap.dispatch.server.service.TaskTimeService;
import com.yonyou.iuap.dispatch.server.util.Util;
import com.yonyou.iuap.entity.Task;
import com.yonyou.iuap.entity.TaskTime;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PreparedTaskAutoRunThread
extends Thread {
    protected static Logger logger = LoggerFactory.getLogger(PreparedTaskAutoRunThread.class);
    private static final long waitingTime = 60000L;

    @Override
    public void run() {
        logger.debug("scaning prepared task starts");
        try {
            PreparedTaskAutoRunThread.sleep((long)60000L);
            this.taskAutoRun();
        }
        catch (Exception e) {
            logger.error("create socket server error", (Throwable)e);
        }
        logger.debug("scaning prepared task is over");
    }

    private void taskAutoRun() {
        List taskList = this.getTaskService().selectAllTask();
        for (Task task : taskList) {
            String url = this.getTaskService().getTaskWayById(task.getTaskwayid()).getUrl();
            String sysid = task.getSysid();
            String tenantid = task.getTenantid();
            List taskParams = this.getTaskParamService().getTaskParamByTaskWayId(task.getTaskwayid());
            List taskRecallParams = this.getTaskRecallParamService().selectTaskRecallParamByTaskId(task.getId());
            HashMap<String, String> recallData = new HashMap<String, String>();
            recallData.put("option", Util.getOptionValue((String)url, (String)tenantid, (String)sysid));
            recallData.put("data", Util.getDataValue((List)taskParams, (List)taskRecallParams));
            DailyTimeIntervalTaskConfig taskConfig = null;
            TaskTime taskTime = this.getTaskTimeService().selectByTaskId(task.getId());
            try {
                taskConfig = Util.convertToTaskConfig((String)task.getId(), (String)task.getGroupid(), (TaskTime)taskTime);
            }
            catch (ParseException e) {
                logger.error(e.getMessage() + " task error,please check. the task is " + task.getCode(), (Throwable)e);
            }
            Date now = new Date();
            OperableTrigger trigger = Util.getTrigger((DailyTimeIntervalTaskConfig)taskConfig, (String)task.getId(), (String)task.getGroupid(), (TaskTime)taskTime, (Date)now);
            String nextTime = Util.getNextExecuteTime((OperableTrigger)trigger, (String)task.getId(), (String)task.getGroupid(), (TaskTime)taskTime);
            if ("\u5df2\u8fc7\u671f".equals(nextTime)) continue;
            DispatchManager.addDailyTimeIntervalTrigger((DailyTimeIntervalTaskConfig)taskConfig, (Class)RecallUtil.getRecall((String)"HTTP"), recallData, (boolean)false, (boolean)true);
        }
    }

    private TaskService getTaskService() {
        return (TaskService)SpringContextUtil.getBean((String)"TaskService");
    }

    private TaskTimeService getTaskTimeService() {
        return (TaskTimeService)SpringContextUtil.getBean((String)"TaskTimeService");
    }

    private TaskParamService getTaskParamService() {
        return (TaskParamService)SpringContextUtil.getBean((String)"TaskParamService");
    }

    private TaskRecallParamService getTaskRecallParamService() {
        return (TaskRecallParamService)SpringContextUtil.getBean((String)"TaskRecallParamService");
    }
}

