/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.common;

import com.yonyou.iuap.dispatch.common.SpringContextUtil;
import com.yonyou.iuap.dispatch.server.common.ConfigUtil;
import com.yonyou.iuap.dispatch.server.service.DispatchServerService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketServer
extends Thread {
    protected static Logger logger = LoggerFactory.getLogger(SocketServer.class);
    private static ServerSocket server;

    @Override
    public void run() {
        logger.error("start socket server");
        try {
            server = new ServerSocket(Integer.valueOf(ConfigUtil.getProperties((String)"dispatch.socket.port")));
            this.startListener();
        }
        catch (Exception e) {
            logger.error("create socket server error", (Throwable)e);
        }
    }

    private void startListener() throws IOException {
        logger.debug("server waiting for connect.");
        while (true) {
            try {
                while (true) {
                    this.doReceiver(server.accept());
                }
            }
            catch (Exception e) {
                logger.error("receiver data fail ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReceiver(Socket client) throws IOException {
        try {
            logger.debug("receive a connect success.");
            BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
            PrintWriter writer = new PrintWriter(client.getOutputStream());
            String data = reader.readLine();
            DispatchServerService dispatchServerService = (DispatchServerService)SpringContextUtil.getBean((String)"dispatchServerService");
            String addResult = dispatchServerService.addTask(data);
            if (addResult == null) {
                writer.println("SUCCESS");
            } else {
                writer.println("FAIL");
            }
            writer.flush();
        }
        catch (Exception e) {
            logger.error("receiver data fail ", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }
}

