/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.iuap.dispatch.server.common.HttpUtil;
import com.yonyou.iuap.dispatch.server.service.DispatchServerService;
import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dispatchserver"})
public class DispatchServerController {
    private static Logger logger = LoggerFactory.getLogger(DispatchServerController.class);
    @Autowired
    DispatchServerService dispatchServerService;

    @RequestMapping(value={"/add"})
    @ResponseBody
    public Map<String, Object> addTask(HttpServletRequest request) {
        String data = null;
        try {
            data = HttpUtil.receive((InputStream)request.getInputStream());
            logger.debug("addTask data: " + data);
            String dataAddInvocationInfo = this.processInvocationInfo(request, data);
            String result = this.dispatchServerService.addTask(dataAddInvocationInfo);
            if (result == null) {
                return this.getMessage(Boolean.valueOf(true), null, null);
            }
            return this.getMessage(Boolean.valueOf(false), result, null);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u4efb\u52a1\u6d41", (Throwable)e);
            return this.getMessage(Boolean.valueOf(false), "receive task data error", null);
        }
    }

    private String processInvocationInfo(HttpServletRequest request, String data) {
        String recallConfig = data;
        String sysid = InvocationInfoProxyAdapter.getSysid();
        String tenantid = InvocationInfoProxyAdapter.getTenantid();
        if (sysid != null && tenantid != null) {
            JSONObject jsonObj = (JSONObject)JSONObject.parse((String)data);
            JSONObject recallConfigJson = (JSONObject)jsonObj.get((Object)"recallConfig");
            JSONObject optionJson = (JSONObject)recallConfigJson.get((Object)"option");
            if (optionJson.getString("tenantid") == null) {
                optionJson.put("tenantid", (Object)tenantid);
            }
            if (optionJson.getString("sysid") == null) {
                optionJson.put("sysid", (Object)sysid);
            }
            recallConfig = jsonObj.toJSONString();
        }
        return recallConfig;
    }

    @RequestMapping(value={"/pause"})
    @ResponseBody
    public Map<String, Object> pauseTask(HttpServletRequest request) {
        String data = null;
        try {
            data = HttpUtil.receive((InputStream)request.getInputStream());
            logger.debug("pauseTask data: " + data);
            String result = this.dispatchServerService.pauseTask(data);
            if (result == null) {
                return this.getMessage(Boolean.valueOf(true), null, null);
            }
            return this.getMessage(Boolean.valueOf(false), result, null);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u4efb\u52a1\u6d41", (Throwable)e);
            return this.getMessage(Boolean.valueOf(false), "receive task data error", null);
        }
    }

    @RequestMapping(value={"/resume"})
    @ResponseBody
    public Map<String, Object> resumeTask(HttpServletRequest request) {
        String data = null;
        try {
            data = HttpUtil.receive((InputStream)request.getInputStream());
            logger.debug("resumeTask data: " + data);
            String result = this.dispatchServerService.resumeTask(data);
            if (result == null) {
                return this.getMessage(Boolean.valueOf(true), null, null);
            }
            return this.getMessage(Boolean.valueOf(false), result, null);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u4efb\u52a1\u6d41", (Throwable)e);
            return this.getMessage(Boolean.valueOf(false), "receive task data error", null);
        }
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public Map<String, Object> deleteTask(HttpServletRequest request) {
        String data = null;
        try {
            data = HttpUtil.receive((InputStream)request.getInputStream());
            logger.debug("deleteTask data: " + data);
            String result = this.dispatchServerService.deleteTask(data);
            if (result == null) {
                return this.getMessage(Boolean.valueOf(true), null, null);
            }
            return this.getMessage(Boolean.valueOf(false), result, null);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u4efb\u52a1\u6d41", (Throwable)e);
            return this.getMessage(Boolean.valueOf(false), "receive task data error", null);
        }
    }

    @RequestMapping(value={"/trigger"})
    @ResponseBody
    public Map<String, Object> triggerTask(HttpServletRequest request) {
        String data = null;
        try {
            data = HttpUtil.receive((InputStream)request.getInputStream());
            logger.debug("triggerTask data: " + data);
            String result = this.dispatchServerService.triggerTask(data);
            if (result == null) {
                return this.getMessage(Boolean.valueOf(true), null, null);
            }
            return this.getMessage(Boolean.valueOf(false), result, null);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u4efb\u52a1\u6d41", (Throwable)e);
            return this.getMessage(Boolean.valueOf(false), "receive task data error", null);
        }
    }

    private Map<String, Object> getMessage(Boolean success, String error, Object resultValue) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("error", error);
        result.put("resultValue", resultValue);
        return result;
    }
}

