/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.controller;

import com.alibaba.fastjson.util.TypeUtils;
import com.yonyou.iuap.dispatch.DailyTimeIntervalTaskConfig;
import com.yonyou.iuap.dispatch.DispatchManager;
import com.yonyou.iuap.dispatch.server.common.RecallUtil;
import com.yonyou.iuap.dispatch.server.service.DispatchServerService;
import com.yonyou.iuap.dispatch.server.service.TaskGroupService;
import com.yonyou.iuap.dispatch.server.service.TaskLogService;
import com.yonyou.iuap.dispatch.server.service.TaskParamService;
import com.yonyou.iuap.dispatch.server.service.TaskRecallParamService;
import com.yonyou.iuap.dispatch.server.service.TaskService;
import com.yonyou.iuap.dispatch.server.service.TaskTimeService;
import com.yonyou.iuap.dispatch.server.service.TaskUserService;
import com.yonyou.iuap.dispatch.server.util.Util;
import com.yonyou.iuap.entity.Task;
import com.yonyou.iuap.entity.TaskParam;
import com.yonyou.iuap.entity.TaskRecallParam;
import com.yonyou.iuap.entity.TaskTime;
import com.yonyou.iuap.entity.TaskUser;
import com.yonyou.iuap.entity.TaskVo;
import com.yonyou.iuap.entity.TaskWay;
import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/task4Finance"})
public class Task4FinanceController {
    private static Logger logger = LoggerFactory.getLogger(Task4FinanceController.class);
    @Autowired
    TaskService taskService;
    @Autowired
    TaskGroupService taskGroupService;
    @Autowired
    DispatchServerService dispatchServerService;
    @Autowired
    TaskLogService taskLogService;
    @Autowired
    TaskParamService taskParamService;
    @Autowired
    TaskTimeService taskTimeService;
    @Autowired
    TaskUserService taskUserService;
    @Autowired
    TaskRecallParamService taskRecallParamService;

    @RequestMapping(value={"/getTaskWay"})
    @ResponseBody
    public Map<String, Object> getTaskWay() {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        ArrayList<TaskWay> taskways = new ArrayList<TaskWay>();
        try {
            List taskway = this.taskService.getAllTaskWay();
            for (TaskWay way : taskway) {
                List taskParam = this.taskParamService.getTaskParamByTaskWayId(way.getId());
                way.setTaskParams(taskParam);
                taskways.add(way);
            }
            retMap.put("status", 1);
            retMap.put("taskway", taskways);
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u8c03\u7528\u89c4\u5219\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @RequestMapping(value={"/saveTask"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> saveTask(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String param = request.getParameter("data");
        String taskid = null;
        try {
            JSONObject dataJson = new JSONObject(param);
            if (dataJson.has("task")) {
                JSONObject taskJson = dataJson.getJSONObject("task");
                Task task = this.parseTask(taskJson);
                task.setId(task.getId());
                taskid = task.getId();
                JSONObject taskWayJson = taskJson.getJSONObject("taskway");
                String taskWayId = taskWayJson.getString("id");
                String url = this.taskService.getTaskWayById(taskWayId).getUrl();
                String sysid = InvocationInfoProxyAdapter.getSysid();
                String tenantid = InvocationInfoProxyAdapter.getTenantid();
                List taskParams = this.parseTaskWay(taskJson);
                HashMap<String, String> recallData = new HashMap<String, String>();
                recallData.put("option", Util.getOptionValue((String)url, (String)tenantid, (String)sysid));
                recallData.put("data", Util.getDataValue((List)taskParams, null));
                TaskTime taskTime = this.parseTaskTime(taskJson, task.getId());
                if (taskTime == null) {
                    retMap.put("status", 0);
                    retMap.put("msg", "\u5f02\u5e38:\u6dfb\u52a0\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                    return retMap;
                }
                String nextTime = this.getNextExecuteTime(task.getId(), task.getGroupid(), taskTime);
                if ("\u5df2\u8fc7\u671f".equals(nextTime)) {
                    retMap.put("status", 0);
                    retMap.put("msg", "\u5931\u8d25:\u5df2\u8fc7\u671f");
                    retMap.put("taskid", taskid);
                    return retMap;
                }
                DailyTimeIntervalTaskConfig taskConfig = Util.convertToTaskConfig((String)task.getId(), (String)task.getGroupid(), (TaskTime)taskTime);
                DispatchManager.addDailyTimeIntervalTrigger((DailyTimeIntervalTaskConfig)taskConfig, (Class)RecallUtil.getRecall((String)"HTTP"), recallData, (boolean)true);
                if (taskJson.has("id") && !StringUtils.isEmpty((Object)taskJson.getString("id"))) {
                    this.taskService.updateByPrimaryKey(task);
                    this.taskRecallParamService.deleteByTaskId(taskid);
                    this.taskRecallParamService.insertTaskRecallParam(taskParams, taskid);
                } else {
                    task.setFlag(Integer.valueOf(1));
                    this.taskService.addTask(task);
                    this.taskRecallParamService.insertTaskRecallParam(taskParams, taskid);
                }
                JSONObject timeWayJson = taskJson.getJSONObject("timeway");
                if (timeWayJson.has("id") && !StringUtils.isEmpty((Object)timeWayJson.getString("id"))) {
                    taskTime.setId(timeWayJson.getString("id"));
                    this.taskTimeService.updateByPrimaryKey(taskTime);
                } else {
                    this.taskTimeService.saveTaskTime(taskTime);
                }
                this.saveTaskUser(taskJson, task.getId());
            }
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u6dfb\u52a0\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
            return retMap;
        }
        retMap.put("status", 1);
        retMap.put("msg", "\u6210\u529f:\u6dfb\u52a0\u4efb\u52a1\u6210\u529f\uff01");
        retMap.put("taskid", taskid);
        logger.debug("\u6dfb\u52a0\u4efb\u52a1\u6210\u529f\uff01");
        return retMap;
    }

    @RequestMapping(value={"/findTaskByid"})
    @ResponseBody
    public Map<String, Object> findTaskByid(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String id = request.getParameter("id");
            Task task = this.taskService.getTaskByPrimaryKey(id);
            retMap.put("status", 1);
            retMap.put("task", task);
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @RequestMapping(value={"/findTaskByGroupId"})
    @ResponseBody
    public Map<String, Object> findTaskByGroupId(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String gid = request.getParameter("gid");
            int pageNow = Integer.parseInt(request.getParameter("pageCurrent"));
            int pageSize = Integer.parseInt(request.getParameter("pageSize"));
            int totalPage = 1;
            int totalRecode = this.taskService.getTaskCountByGroupId(gid);
            totalPage = (totalRecode + pageSize - 1) / pageSize;
            List tasks = this.taskService.getTaskByGroupId(gid, pageNow - 1, pageSize);
            ArrayList<TaskVo> taskRet = new ArrayList<TaskVo>();
            for (Task task : tasks) {
                TaskVo taskVo = this.taskService.getTaskById(task.getId());
                this.setNextExecuteTime(taskVo);
                taskRet.add(taskVo);
            }
            retMap.put("number", pageNow);
            retMap.put("totalPage", totalPage);
            retMap.put("totalCount", totalRecode);
            retMap.put("tasks", taskRet);
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    private void setNextExecuteTime(TaskVo taskVo) {
        if (taskVo.getTaskFlag() == 0) {
            taskVo.setNextTime("\u5df2\u505c\u7528");
        } else if (taskVo.getTaskFlag() == 2) {
            taskVo.setNextTime("\u5df2\u8fc7\u671f");
        } else {
            TaskTime taskTime = this.taskTimeService.selectByTaskId(taskVo.getId());
            taskVo.setNextTime(this.getNextExecuteTime(taskVo.getId(), taskVo.getGroupid(), taskTime));
            if ("\u5df2\u8fc7\u671f".equals(taskVo.getNextTime())) {
                taskVo.setTaskFlag(2);
            }
        }
    }

    private String getNextExecuteTime(String taskId, String groupId, TaskTime taskTime) {
        String nextTime = "";
        DailyTimeIntervalTaskConfig taskConfig = null;
        try {
            Date now = new Date();
            taskConfig = Util.convertToTaskConfig((String)taskId, (String)groupId, (TaskTime)taskTime);
            OperableTrigger trigger = Util.getTrigger((DailyTimeIntervalTaskConfig)taskConfig, (String)taskId, (String)groupId, (TaskTime)taskTime, (Date)now);
            nextTime = Util.getNextExecuteTime((OperableTrigger)trigger, (String)taskId, (String)groupId, (TaskTime)taskTime);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return nextTime;
    }

    @RequestMapping(value={"/findTaskByName"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> findTaskByName(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String taskName = request.getParameter("taskName");
            int pageNow = Integer.parseInt(request.getParameter("pageCurrent"));
            int pageSize = Integer.parseInt(request.getParameter("pageSize"));
            int totalPage = 1;
            int totalRecode = this.taskService.selectConutTaskByLikeName("%" + taskName + "%");
            totalPage = (totalRecode + pageSize - 1) / pageSize;
            List tasks = this.taskService.getTaskByLikeName("%" + taskName + "%", pageNow - 1, pageSize);
            ArrayList<TaskVo> taskRet = new ArrayList<TaskVo>();
            for (Task task : tasks) {
                TaskVo taskVo = this.taskService.getTaskById(task.getId());
                this.setNextExecuteTime(taskVo);
                taskRet.add(taskVo);
            }
            retMap.put("number", pageNow);
            retMap.put("totalPage", totalPage);
            retMap.put("tasks", taskRet);
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @RequestMapping(value={"/searchTask"})
    @ResponseBody
    public Map<String, Object> searchTask(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String taskName;
            int pageNow = Integer.parseInt(request.getParameter("pageCurrent"));
            int pageSize = Integer.parseInt(request.getParameter("pageSize"));
            int totalPage = 1;
            int totalRecode = pageSize;
            totalPage = (totalRecode + pageSize - 1) / pageSize;
            String gid = request.getParameter("gid");
            List tasks = null;
            if (gid != null && !"".equals(gid.trim())) {
                tasks = this.taskService.getTaskByGroupId(gid, (pageNow - 1) * pageSize, pageSize);
            }
            if ((taskName = request.getParameter("taskName")) != null && !"".equals(taskName.trim())) {
                tasks = this.taskService.getTaskByLikeName("%" + taskName + "%");
            }
            retMap.put("status", 1);
            retMap.put("tasks", tasks);
            retMap.put("number", pageNow);
            retMap.put("totalPage", totalPage);
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @RequestMapping(value={"/findTaskDetilById"})
    @ResponseBody
    public void findTaskDetilById(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String id = request.getParameter("id");
            TaskVo taskVo = this.taskService.getTaskById(id);
            String gName = this.taskGroupService.getByPrimaryKey(taskVo.getGroupid()).getName();
            String taskWayName = this.taskService.getTaskWayById(taskVo.getTaskwayid()).getName();
            taskVo.setgName(gName);
            taskVo.setTaskwayname(taskWayName);
            List taskParams = this.taskParamService.getTaskParamByTaskWayId(taskVo.getTaskwayid());
            List taskRecallParams = this.taskRecallParamService.selectTaskRecallParamByTaskId(id);
            HashMap<String, String> taskParamValueMap = new HashMap<String, String>();
            for (TaskRecallParam taskRecallParam : taskRecallParams) {
                taskParamValueMap.put(taskRecallParam.getTaskparamid(), taskRecallParam.getParamvalue());
            }
            TaskTime tasktime = this.taskTimeService.selectByTaskId(taskVo.getId());
            if (tasktime == null) {
                retMap.put("status", 0);
                retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                JSONObject returnJson = new JSONObject(retMap);
                this.writeJSON(response, String.valueOf(returnJson));
                return;
            }
            String modevaule = tasktime.getModevaule();
            StringBuffer modeval = new StringBuffer();
            if (!StringUtils.isEmpty((Object)modevaule)) {
                int i = 0;
                for (String tmp : modevaule.split(";")) {
                    if (i != 0) {
                        modeval.append(",\"" + tmp + "\"");
                    } else {
                        modeval.append("\"" + tmp + "\"");
                    }
                    ++i;
                }
            }
            StringBuffer taskParamsStr = new StringBuffer();
            int index = 0;
            for (TaskParam taskParam : taskParams) {
                if (index == 0) {
                    taskParamsStr.append("{");
                } else {
                    taskParamsStr.append(",{");
                }
                taskParamsStr.append("\"id\":\"" + taskParam.getId() + "\"");
                taskParamsStr.append(",\"code\":\"" + taskParam.getCode() + "\"");
                taskParamsStr.append(",\"name\":\"" + taskParam.getName() + "\"");
                taskParamsStr.append(",\"paramvalue\":\"" + (String)taskParamValueMap.get(taskParam.getId()) + "\"");
                taskParamsStr.append("}");
                ++index;
            }
            List users = this.taskUserService.queryTaskUserByTaskId(taskVo.getId());
            StringBuffer taskmsg = new StringBuffer();
            index = 0;
            for (TaskUser user : users) {
                if (index == 0) {
                    taskmsg.append("{");
                } else {
                    taskmsg.append(",{");
                }
                taskmsg.append("\"id\":\"" + user.getId() + "\"");
                taskmsg.append(",\"userid\":\"" + user.getUserid() + "\"");
                taskmsg.append(",\"userCode\":\"" + user.getUserCode() + "\"");
                taskmsg.append(",\"userName\":\"" + user.getUserName() + "\"");
                taskmsg.append(",\"msg\":" + user.getMsg() + "");
                taskmsg.append(",\"email\":" + user.getEmail() + "");
                taskmsg.append(",\"phone\":" + user.getPhone() + "");
                taskmsg.append("}");
                ++index;
            }
            String data = "{\"status\":1,\"task\":{\"id\":\"" + taskVo.getId() + "\",\"taskcode\":\"" + taskVo.getTaskCode() + "\",\"taskname\":\"" + taskVo.getTaskName() + "\",\"gname\":\"" + gName + "\",\"taskwayname\":\"" + taskWayName + "\",\"taskdesc\":\"" + (taskVo.getDescription() == null ? "" : taskVo.getDescription()) + "\",\"flag\":" + taskVo.getTaskFlag() + ",\"sus\":" + taskVo.getTaskSusCount() + ",\"fail\":" + taskVo.getTaskFailCount() + ",\"gid\":\"" + taskVo.getGroupid() + "\",\"taskway\":{\"id\":\"" + taskVo.getTaskwayid() + "\",\"taskParams\":[" + taskParamsStr.toString() + "]},\"timeway\":{\"id\":\"" + tasktime.getId() + "\",\"starttime\":\"" + new SimpleDateFormat("yyyy-MM-dd HH:mm").format(tasktime.getStarttime()) + "\",\"endtime\":\"" + new SimpleDateFormat("yyyy-MM-dd HH:mm").format(tasktime.getEndtime()) + "\",\"modetime\":{\"modetype\":" + "\"" + tasktime.getModetype() + "\",\"modefrequency\":\"" + tasktime.getModefrequency() + "\",\"modevaule\":[" + modeval.toString() + "]},\"dura\":{\"duramode\":" + "\"" + tasktime.getDuramode() + "\",\"duravalue\":\"" + tasktime.getDuravalue() + "\",\"period\":{\"periodmode\":" + "\"" + tasktime.getPeriodmode() + "\",\"periodstart\":\"" + tasktime.getPeriodstart() + "\",\"periodend\":\"" + tasktime.getPeriodend() + "\"}}},\"taskmsg\":[" + taskmsg.toString() + "]}}";
            JSONObject returnJson = new JSONObject(data);
            this.writeJSON(response, String.valueOf(returnJson));
        }
        catch (IOException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/resumeTask"})
    @ResponseBody
    public Map<String, Object> resumeTask(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String[] ids;
            String taskids = request.getParameter("ids").trim();
            for (String id : ids = taskids.split(",")) {
                Task task = this.taskService.getTaskByPrimaryKey(id);
                if (task == null || task.getFlag() != null && task.getFlag() == 1) continue;
                String jobName = task.getId();
                String groupName = task.getGroupid();
                TaskTime taskTime = this.taskTimeService.selectByTaskId(task.getId());
                String nextTime = this.getNextExecuteTime(task.getId(), task.getGroupid(), taskTime);
                if ("\u5df2\u8fc7\u671f".equals(nextTime)) {
                    retMap.put("status", 0);
                    retMap.put("msg", "\u5931\u8d25:\u5df2\u8fc7\u671f");
                    retMap.put("taskid", task.getId());
                    return retMap;
                }
                String resumeTaskMsg = DispatchManager.resumeJob((String)jobName, (String)groupName);
                if (resumeTaskMsg != null) {
                    if (resumeTaskMsg.equals("job is not exist")) {
                        retMap.put("status", 0);
                        retMap.put("msg", "\u5f02\u5e38:job is not exist");
                        logger.error(resumeTaskMsg);
                    } else {
                        retMap.put("status", 0);
                        retMap.put("msg", "\u5f02\u5e38:\u4efb\u52a1\u64cd\u4f5c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                        logger.error(resumeTaskMsg);
                    }
                    return retMap;
                }
                task.setFlag(Integer.valueOf(1));
                this.taskService.updateByPrimaryKey(task);
            }
            retMap.put("status", 1);
            retMap.put("msg", "\u6210\u529f:\u4efb\u52a1\u64cd\u4f5c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u4efb\u52a1\u64cd\u4f5c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @RequestMapping(value={"/stopTask"})
    @ResponseBody
    public Map<String, Object> stopTask(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String[] ids;
            String taskids = request.getParameter("ids").trim();
            for (String id : ids = taskids.split(",")) {
                String groupName;
                Task task = this.taskService.getTaskByPrimaryKey(id);
                if (task == null || task.getFlag() == 0) continue;
                String jobName = task.getId();
                String taskMsg = DispatchManager.pauseJob((String)jobName, (String)(groupName = task.getGroupid()));
                if (taskMsg != null) {
                    if (taskMsg.equals("job is not exist")) {
                        retMap.put("status", 0);
                        retMap.put("msg", "\u5f02\u5e38:job is not exist");
                        logger.error(taskMsg);
                    } else {
                        retMap.put("status", 0);
                        retMap.put("msg", "\u5f02\u5e38:\u4efb\u52a1\u64cd\u4f5c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                        logger.error(taskMsg);
                    }
                    return retMap;
                }
                task.setFlag(Integer.valueOf(0));
                this.taskService.updateByPrimaryKey(task);
            }
            retMap.put("status", 1);
            retMap.put("msg", "\u6210\u529f:\u4efb\u52a1\u64cd\u4f5c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u4efb\u52a1\u64cd\u4f5c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @RequestMapping(value={"/delTask"})
    @ResponseBody
    public Map<String, Object> delTask(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String[] ids;
            String taskids = request.getParameter("ids").trim();
            for (String id : ids = taskids.split(",")) {
                String groupName;
                Task task = this.taskService.getTaskByPrimaryKey(id);
                if (task == null) continue;
                String jobName = task.getId();
                String taskMsg = DispatchManager.deleteJob((String)jobName, (String)(groupName = task.getGroupid()));
                if (taskMsg != null && !taskMsg.equals("job is not exist")) {
                    retMap.put("status", 0);
                    retMap.put("msg", "\u5f02\u5e38:\u4efb\u52a1\u64cd\u4f5c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                    logger.error(taskMsg);
                    return retMap;
                }
                this.deleteTask(task);
            }
            retMap.put("status", 1);
            retMap.put("msg", "\u6210\u529f:\u4efb\u52a1\u64cd\u4f5c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u4efb\u52a1\u64cd\u4f5c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    private void deleteTask(Task task) {
        this.taskService.deleteByPrimaryKey(task.getId());
        this.taskTimeService.deleteByTaskId(task.getId());
        this.taskRecallParamService.deleteByTaskId(task.getId());
        this.taskLogService.deleteByTaskid(task.getId());
        this.taskUserService.deleteTaskUsersById(task.getId());
    }

    private Task parseTask(JSONObject taskJson) throws JSONException {
        Task task = new Task();
        task.setName(taskJson.getString("taskname"));
        task.setCode(taskJson.getString("taskcode"));
        task.setGroupid(taskJson.getString("gid"));
        task.setTenantid(taskJson.getString("tenantid"));
        task.setSysid(taskJson.getString("sysid"));
        task.setUserid(taskJson.getString("userid"));
        JSONObject taskWayJson = taskJson.getJSONObject("taskway");
        String taskWayId = taskWayJson.getString("id");
        task.setTaskwayid(taskWayId);
        task.setCreatetime(new Date());
        if (taskJson.has("taskdesc")) {
            task.setDescription(taskJson.getString("taskdesc"));
        }
        if (taskJson.has("financeid") && !StringUtils.isEmpty((Object)taskJson.getString("financeid"))) {
            task.setId(taskJson.getString("financeid"));
        }
        if (taskJson.has("flag")) {
            task.setFlag(Integer.valueOf(taskJson.getString("flag")));
        }
        return task;
    }

    private List<TaskParam> parseTaskWay(JSONObject taskJson) throws JSONException {
        ArrayList<TaskParam> taskParames = new ArrayList<TaskParam>();
        if (taskJson.has("taskway")) {
            JSONObject taskWayJson = taskJson.getJSONObject("taskway");
            String taskWayId = taskWayJson.getString("id");
            if (taskWayJson.has("taskParams")) {
                JSONArray taskParamsJson = taskWayJson.getJSONArray("taskParams");
                for (int i = 0; i < taskParamsJson.length(); ++i) {
                    TaskParam taskParam = new TaskParam();
                    JSONObject taskParamJson = taskParamsJson.getJSONObject(i);
                    String taskParamId = taskParamJson.getString("id");
                    TaskParam taskParamEntiy = this.taskParamService.selectByPrimaryKey(taskParamId);
                    taskParam.setId(taskParamJson.getString("id"));
                    taskParam.setTaskwayid(taskWayId);
                    taskParam.setCode(taskParamEntiy.getCode());
                    String paramName = taskParamEntiy.getName();
                    taskParam.setName(paramName);
                    String paramvalue = taskParamJson.getString("paramvalue");
                    taskParam.setParamvalue(paramvalue);
                    taskParames.add(taskParam);
                }
            }
        }
        return taskParames;
    }

    private TaskTime parseTaskTime(JSONObject taskJson, String taskId) throws JSONException {
        if (taskJson.has("timeway")) {
            TaskTime taskTime = new TaskTime();
            taskTime.setTaskid(taskId);
            JSONObject timeWayJson = taskJson.getJSONObject("timeway");
            taskTime.setStarttime(TypeUtils.castToDate((Object)(timeWayJson.getString("starttime") + ":00")));
            taskTime.setEndtime(TypeUtils.castToDate((Object)(timeWayJson.getString("endtime") + ":00")));
            JSONObject modeTimeJson = timeWayJson.getJSONObject("modetime");
            taskTime.setModetype(Integer.valueOf(modeTimeJson.getInt("modetype")));
            taskTime.setModefrequency(Integer.valueOf(modeTimeJson.getInt("modefrequency")));
            if (modeTimeJson.has("modevaule")) {
                JSONArray modeValue = modeTimeJson.getJSONArray("modevaule");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < modeValue.length(); ++i) {
                    sb.append(modeValue.get(i) + ";");
                }
                taskTime.setModevaule(sb.toString());
            }
            JSONObject duraJson = timeWayJson.getJSONObject("dura");
            taskTime.setDuramode(Integer.valueOf(duraJson.getInt("duramode")));
            taskTime.setDuravalue(duraJson.getString("duravalue"));
            if (duraJson.has("period")) {
                JSONObject periodJson = duraJson.getJSONObject("period");
                taskTime.setPeriodmode(Integer.valueOf(periodJson.getInt("periodmode")));
                taskTime.setPeriodstart(periodJson.getString("periodstart"));
                taskTime.setPeriodend(periodJson.getString("periodend"));
            }
            return taskTime;
        }
        return null;
    }

    private boolean saveTaskUser(JSONObject taskJson, String taskid) throws JSONException {
        ArrayList<TaskUser> taskUsers = new ArrayList<TaskUser>();
        try {
            if (taskJson.has("taskmsg")) {
                JSONArray taskMsgJsons = taskJson.getJSONArray("taskmsg");
                this.taskUserService.deleteTaskUsersById(taskid);
                for (int i = 0; i < taskMsgJsons.length(); ++i) {
                    TaskUser taskUser = new TaskUser();
                    taskUser.setTaskid(taskid);
                    JSONObject taskMsgJson = taskMsgJsons.getJSONObject(i);
                    taskUser.setUserCode(taskMsgJson.getString("userCode"));
                    taskUser.setUserName(taskMsgJson.getString("userName"));
                    taskUser.setMsg(Integer.valueOf(taskMsgJson.getInt("msg")));
                    taskUser.setEmail(Integer.valueOf(taskMsgJson.getInt("email")));
                    taskUser.setPhone(Integer.valueOf(taskMsgJson.getInt("phone")));
                    taskUser.setUserid(taskMsgJson.getString("userid"));
                    taskUsers.add(taskUser);
                    this.taskUserService.saveTaskUser(taskUser);
                }
            }
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private void writeJSON(HttpServletResponse response, String json) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(json);
        response.flushBuffer();
    }

    @RequestMapping(value={"/getTaskWayParamByTaskWayId"})
    @ResponseBody
    public Map<String, Object> getTaskWayParamByTaskWayId(HttpServletRequest request) {
        String taskWayId = request.getParameter("taskWayId");
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            List taskParam = this.taskParamService.getTaskParamByTaskWayId(taskWayId);
            retMap.put("status", 1);
            retMap.put("taskWayParam", taskParam);
        }
        catch (Exception e) {
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u8c03\u7528\u89c4\u5219\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }
}

