/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.controller;

import com.yonyou.iuap.dispatch.server.service.TaskGroupService;
import com.yonyou.iuap.dispatch.server.service.TaskService;
import com.yonyou.iuap.entity.TaskGroup;
import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/taskgroup"})
public class TaskGroupController {
    private static Logger logger = LoggerFactory.getLogger(TaskGroupController.class);
    @Autowired
    TaskGroupService taskGroupService;
    @Autowired
    TaskService taskService;

    @RequestMapping(value={"/addTaskGroup"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> addTaskGroup(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            TaskGroup record = new TaskGroup();
            String param = request.getParameter("data");
            JSONObject jsObj = JSONObject.fromObject((Object)param);
            String sysid = InvocationInfoProxyAdapter.getSysid();
            String tenantid = InvocationInfoProxyAdapter.getTenantid();
            record.setName(jsObj.getString("gName"));
            record.setSysid(sysid);
            record.setTenantid(tenantid);
            if (this.taskGroupService.getByName(record.getName())) {
                retMap.put("status", 0);
                retMap.put("msg", "\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                logger.error("\u5931\u8d25:\u6dfb\u52a0\u5206\u7ec4\u5e95\u5c42\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff01");
                return retMap;
            }
            int ret = this.taskGroupService.addTaskGroup(record);
            if (ret == 1) {
                retMap.put("status", 1);
                retMap.put("msg", "\u6210\u529f:\u6dfb\u52a0\u5206\u7ec4\u6210\u529f\uff01");
                logger.debug("\u6210\u529f:\u6dfb\u52a0\u5206\u7ec4\u6210\u529f\uff01");
            } else {
                retMap.put("status", 0);
                retMap.put("msg", "\u5931\u8d25:\u6dfb\u52a0\u5206\u7ec4\u5e95\u5c42\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff01");
                logger.debug("\u5931\u8d25:\u6dfb\u52a0\u5206\u7ec4\u5e95\u5c42\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u6dfb\u52a0\u5206\u7ec4\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    private String getRequestString(HttpServletRequest request) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        String s = null;
        StringBuffer sb = new StringBuffer();
        while ((s = reader.readLine()) != null) {
            sb.append(s);
        }
        reader.close();
        String jsonStr = sb.toString();
        return jsonStr;
    }

    @RequestMapping(value={"/findAllTaskGroup"})
    @ResponseBody
    public Map<String, Object> findAllTaskGroup() {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String sysid = InvocationInfoProxyAdapter.getSysid();
            String tenantid = InvocationInfoProxyAdapter.getTenantid();
            List list = this.taskGroupService.findAllTaskGroup(tenantid == null ? "tenant" : tenantid, sysid == null ? "wbalone" : sysid);
            ArrayList retList = new ArrayList();
            for (TaskGroup taskGroup : list) {
                String groupId = taskGroup.getId();
                int taskCount = this.taskService.getTaskCountByGroupId(groupId);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put("taskCount", taskCount);
                ret.put("gid", groupId);
                ret.put("gname", taskGroup.getName());
                retList.add(ret);
            }
            retMap.put("groups", retList);
            retMap.put("status", 1);
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u5206\u7ec4\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @RequestMapping(value={"/delTaskGroupById"})
    @ResponseBody
    public Map<String, Object> delTaskGroupById(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String gid = request.getParameter("gid").trim();
            int totalRecode = this.taskService.getTaskCountByGroupId(gid);
            if (totalRecode > 0) {
                retMap.put("status", 0);
                retMap.put("msg", "\u5206\u7ec4\u4e0b\u4efb\u52a1\u4e0d\u7a7a\uff0c\u4e0d\u53ef\u5220\u9664\uff01");
                return retMap;
            }
            this.taskGroupService.deleteByPrimaryKey(gid);
            retMap.put("status", 1);
            retMap.put("msg", "\u6210\u529f:\u5220\u9664\u5206\u7ec4\u6210\u529f\uff01");
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u4efb\u52a1\u64cd\u4f5c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }
}

