/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.controller;

import com.yonyou.iuap.dispatch.server.service.TaskLogService;
import com.yonyou.iuap.entity.TaskLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tasklog"})
public class TaskLogController {
    private static Logger logger = LoggerFactory.getLogger(TaskLogController.class);
    @Autowired
    TaskLogService taskLogService;

    @RequestMapping(value={"/deleteByPrimaryKey"})
    @ResponseBody
    public int deleteByPrimaryKey(HttpServletRequest request) {
        String id = request.getParameter("id");
        int ret = 0;
        try {
            ret = this.taskLogService.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    @RequestMapping(value={"/selectByPrimaryKey"})
    @ResponseBody
    public TaskLog selectByPrimaryKey(HttpServletRequest request) {
        TaskLog taskLog = null;
        String id = request.getParameter("id");
        try {
            taskLog = this.taskLogService.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return taskLog;
    }

    @RequestMapping(value={"/getTaskLogVOByTaskId"})
    @ResponseBody
    public Map<String, Object> getTaskLogVOByTaskId(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String taskid = request.getParameter("taskid");
            int pageNow = Integer.parseInt(request.getParameter("pageCurrent"));
            int pageSize = Integer.parseInt(request.getParameter("pageSize"));
            int totalPage = 1;
            int totalRecord = this.taskLogService.getTaskLogCountByTaskId(taskid);
            totalPage = (totalRecord + pageSize - 1) / pageSize;
            List taskLogVOs = this.taskLogService.getTaskLogVOByTaskId(taskid, pageNow - 1, pageSize);
            retMap.put("number", pageNow);
            retMap.put("totalPage", totalPage);
            retMap.put("tasklogVOs", taskLogVOs);
            retMap.put("totalNumber", totalRecord);
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @RequestMapping(value={"/getTaskLogVO"})
    @ResponseBody
    public Map<String, Object> getTaskLogVO(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            int pageNow = Integer.parseInt(request.getParameter("pageCurrent"));
            int pageSize = Integer.parseInt(request.getParameter("pageSize"));
            int totalPage = 1;
            int totalRecord = this.taskLogService.getTaskLogCount();
            totalPage = (totalRecord + pageSize - 1) / pageSize;
            List taskLogVOs = this.taskLogService.getTaskLogVO(pageNow - 1, pageSize);
            retMap.put("number", pageNow);
            retMap.put("totalPage", totalPage);
            retMap.put("tasklogVOs", taskLogVOs);
            retMap.put("totalNumber", totalRecord);
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @RequestMapping(value={"/getTaskLogVOByTaskLogID"})
    @ResponseBody
    public Map<String, Object> getTaskLogVOByTaskLogID(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            String tasklogid = request.getParameter("tasklogid");
            List taskLogVOs = this.taskLogService.getTaskLogVOByTaskLogID(tasklogid);
            retMap.put("tasklogVOs", taskLogVOs);
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @RequestMapping(value={"/getTaskLogVOBySystemDefaultGroup"})
    @ResponseBody
    public Map<String, Object> getTaskLogVOBySystemDefaultGroup(HttpServletRequest request) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            int pageNow = Integer.parseInt(request.getParameter("pageCurrent"));
            int pageSize = Integer.parseInt(request.getParameter("pageSize"));
            int totalPage = 1;
            int totalRecord = this.taskLogService.getTaskLogCountBySystemDefaultGroup();
            totalPage = (totalRecord + pageSize - 1) / pageSize;
            List taskLogVOs = this.taskLogService.getTaskLogVOBySystemDefaultGroup(pageNow - 1, pageSize);
            retMap.put("number", pageNow);
            retMap.put("totalPage", totalPage);
            retMap.put("tasklogVOs", taskLogVOs);
            retMap.put("totalNumber", totalRecord);
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }
}

