/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.dispatch.server.service.ITaskUserService;
import com.yonyou.iuap.entity.TaskUser;
import com.yonyou.iuap.user.service.UserInfoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/taskuser"})
public class TaskUserController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITaskUserService taskUserService;
    @Autowired
    private UserInfoService userInfoService;

    @ResponseBody
    @RequestMapping(value={"/queryUsersByPages"}, method={RequestMethod.POST})
    public Map<String, Object> queryUsersByPages(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String jsonString = request.getParameter("data");
        Map dataMap = null;
        try {
            dataMap = (Map)new ObjectMapper().readValue(jsonString, HashMap.class);
        }
        catch (IOException e) {
            this.logger.error("JSON\u8f6c\u6362\u6210Map\u65f6\u51fa\u9519\uff0cjsonString : " + jsonString, (Throwable)e);
            returnMap.put("msg", "\u4f20\u5165\u7684\u53c2\u6570\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u662f\u4e00\u4e2a\u6807\u51c6\u7684JSON\u5b57\u7b26\u4e32\u3002Parameter : " + jsonString);
            returnMap.put("status", 0);
            return returnMap;
        }
        Object size = dataMap.get("pageSize");
        String pageSize = null;
        if (!StringUtils.isEmpty(size)) {
            pageSize = String.valueOf(size);
        }
        Object num = dataMap.get("pageNum");
        String pageNum = null;
        if (!StringUtils.isEmpty(num)) {
            pageNum = String.valueOf(num);
        }
        Object sort = dataMap.get("sortType");
        String sortType = null;
        if (!StringUtils.isEmpty(sort)) {
            sortType = String.valueOf(sort);
        }
        Object sear = dataMap.get("search");
        String search = null;
        if (!StringUtils.isEmpty(sear)) {
            search = String.valueOf(sear);
        }
        try {
            Map userMap = this.userInfoService.getUserListBypages(pageSize, pageNum, sortType, search);
            returnMap.put("data", userMap);
            returnMap.put("msg", "\u7528\u6237\u6570\u636e\u67e5\u8be2\u6210\u529f");
            returnMap.put("status", "1");
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            returnMap.put("msg", "\u7528\u6237\u6570\u636e\u67e5\u8be2\u5931\u8d25");
            returnMap.put("status", "0");
        }
        return returnMap;
    }

    @ResponseBody
    @RequestMapping(value={"/queryTaskUsers"}, method={RequestMethod.POST})
    public Map<String, Object> queryTaskUsers(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String taskId = request.getParameter("taskid");
        if (org.apache.commons.lang.StringUtils.isBlank((String)taskId)) {
            returnMap.put("msg", "\u4efb\u52a1Id\u4e3a\u7a7a\uff0c\u8bf7\u4f20\u5165\u8be5\u5fc5\u987b\u53c2\u6570");
            returnMap.put("status", "0");
            return returnMap;
        }
        List taskUserList = null;
        try {
            taskUserList = this.taskUserService.queryTaskUserByTaskId(taskId);
            returnMap.put("data", taskUserList);
            returnMap.put("msg", "\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
            returnMap.put("status", "1");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            returnMap.put("msg", "\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u51fa\u9519");
            returnMap.put("status", "0");
        }
        return returnMap;
    }

    @ResponseBody
    @RequestMapping(value={"/saveTaskUsers"}, method={RequestMethod.POST})
    public Map<String, Object> saveTaskUsers(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String dataJson = request.getParameter("data");
        Map dataMap = null;
        try {
            dataMap = (Map)new ObjectMapper().readValue(dataJson, HashMap.class);
        }
        catch (IOException e) {
            this.logger.error("JSON\u8f6c\u6362\u6210Map\u65f6\u51fa\u9519\uff0cjsonString : " + dataJson, (Throwable)e);
            returnMap.put("msg", "\u4f20\u5165\u7684\u53c2\u6570\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u662f\u4e00\u4e2a\u6807\u51c6\u7684JSON\u5b57\u7b26\u4e32\u3002Parameter : " + dataJson);
            returnMap.put("status", 0);
            return returnMap;
        }
        String taskId = null;
        try {
            taskId = (String)dataMap.get("taskid");
        }
        catch (NullPointerException e) {
            this.logger.error("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570\u4efb\u52a1id", (Throwable)e);
            returnMap.put("msg", "\u7528\u6237\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u4f20\u5165\u4efb\u52a1\u53c2\u6570Id");
            returnMap.put("status", "0");
            return returnMap;
        }
        try {
            List userList = (List)dataMap.get("taskuser");
            this.taskUserService.deleteTaskUsersById(taskId);
            List taskUserList = this.buildTaskUsers(taskId, userList);
            this.taskUserService.saveTaskUsers(taskUserList);
            returnMap.put("msg", "\u7528\u6237\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
            returnMap.put("status", "1");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            returnMap.put("msg", "\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u51fa\u9519");
            returnMap.put("status", "0");
        }
        return returnMap;
    }

    private List<TaskUser> buildTaskUsers(String taskId, List<Map<String, Object>> userList) {
        if (StringUtils.isEmpty(userList)) {
            return null;
        }
        ArrayList<TaskUser> taskUserList = new ArrayList<TaskUser>();
        for (Map<String, Object> map : userList) {
            TaskUser taskUser = new TaskUser();
            String id = (String)map.get("id");
            String ucode = (String)map.get("ucode");
            String uname = (String)map.get("uname");
            Integer msg = (Integer)map.get("msg");
            Integer email = (Integer)map.get("email");
            Integer phone = (Integer)map.get("phone");
            taskUser.setId(id);
            taskUser.setTaskid(taskId);
            taskUser.setUserCode(ucode);
            taskUser.setUserName(uname);
            taskUser.setMsg(msg);
            taskUser.setEmail(email);
            taskUser.setPhone(phone);
            taskUserList.add(taskUser);
        }
        return taskUserList;
    }
}

