/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.controller;

import com.yonyou.iuap.dispatch.server.service.TaskService;
import com.yonyou.iuap.dispatch.server.service.TaskWayClassService;
import com.yonyou.iuap.entity.TaskWay;
import com.yonyou.iuap.entity.TaskWayClass;
import iuap.ref.sdk.refmodel.model.AbstractTreeGridRefModel;
import iuap.ref.sdk.refmodel.vo.RefUITypeEnum;
import iuap.ref.sdk.refmodel.vo.RefViewModelVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/taskwayref"})
public class TaskWayRefController
extends AbstractTreeGridRefModel {
    private static Logger logger = LoggerFactory.getLogger(TaskWayRefController.class);
    private String REFNAME = "refname";
    private String REFCODE = "refcode";
    private String NAME = "name";
    private String REFPK = "refpk";
    private String PID = "pid";
    private String ID = "id";
    @Autowired
    TaskWayClassService taskWayClassService;
    @Autowired
    TaskService taskService;

    @ResponseBody
    public RefViewModelVO getRefModelInfo(@RequestBody RefViewModelVO refViewModel) {
        refViewModel = super.getRefModelInfo(refViewModel);
        refViewModel.setRefName("\u8c03\u7528\u89c4\u5219");
        refViewModel.setRootName("\u89c4\u5219\u5206\u7c7b");
        refViewModel.setStrFieldName(new String[]{"\u540d\u79f0"});
        refViewModel.setRefUIType(RefUITypeEnum.RefGridTree);
        return refViewModel;
    }

    public List<Map<String, String>> matchPKRefJSON(@RequestBody RefViewModelVO paramRefViewModelVO) {
        String[] pks = paramRefViewModelVO.getPk_val();
        if (pks == null || pks.length == 0) {
            return null;
        }
        List taskWays = this.taskService.getAllTaskWayByIds(pks);
        List retData = this.getTaskWays(taskWays);
        return retData;
    }

    public List<Map<String, String>> filterRefJSON(@RequestBody RefViewModelVO paramRefViewModelVO) {
        String blur = "%" + paramRefViewModelVO.getContent() + "%";
        List taskWays = this.taskService.filterMatch(blur);
        List retData = this.getTaskWays(taskWays);
        return retData;
    }

    public List<Map<String, String>> matchBlurRefJSON(@RequestBody RefViewModelVO paramRefViewModelVO) {
        String blur = paramRefViewModelVO.getContent();
        List taskWays = this.taskService.blurMatch(blur);
        List retData = this.getTaskWays(taskWays);
        return retData;
    }

    public List<Map<String, String>> blobRefClassSearch(@RequestBody RefViewModelVO paramRefViewModelVO) {
        List twc = this.taskWayClassService.selectAll();
        ArrayList<Map<String, String>> retData = new ArrayList<Map<String, String>>();
        for (TaskWayClass taskWayClass : twc) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(this.REFPK, taskWayClass.getId());
            map.put(this.REFCODE, taskWayClass.getCode());
            map.put(this.NAME, taskWayClass.getName());
            map.put(this.PID, taskWayClass.getParentid());
            map.put(this.ID, taskWayClass.getId());
            retData.add(map);
        }
        return retData;
    }

    public Map<String, Object> blobRefSearch(@RequestBody RefViewModelVO paramRefViewModelVO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String classid = paramRefViewModelVO.getCondition();
        String content = paramRefViewModelVO.getContent();
        List tw = new ArrayList();
        if (content != null) {
            String blur = "%" + content + "%";
            tw = this.taskService.getAllTaskWayByBlurParam(classid, blur);
        } else {
            tw = this.taskService.getAllTaskWay(classid);
        }
        List retData = this.getTaskWays(tw);
        map.put("dataList", retData);
        map.put("refViewModel", paramRefViewModelVO);
        return map;
    }

    private List<Map<String, String>> getTaskWays(List<TaskWay> tw) {
        ArrayList<Map<String, String>> retData = new ArrayList<Map<String, String>>();
        for (TaskWay taskWay : tw) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(this.REFPK, taskWay.getId());
            map.put(this.REFCODE, taskWay.getCode());
            map.put(this.REFNAME, taskWay.getName());
            retData.add(map);
        }
        return retData;
    }

    @RequestMapping(value={"/getClassData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, String>> getRefClassSearch() {
        List twc = this.taskWayClassService.selectAll();
        ArrayList<Map<String, String>> retData = new ArrayList<Map<String, String>>();
        for (TaskWayClass taskWayClass : twc) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(this.REFPK, taskWayClass.getId());
            map.put(this.REFCODE, taskWayClass.getCode());
            map.put(this.REFNAME, taskWayClass.getName());
            map.put(this.PID, taskWayClass.getParentid());
            map.put(this.ID, taskWayClass.getId());
            retData.add(map);
        }
        return retData;
    }

    @RequestMapping(value={"/getRefData"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getRefData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List tw = this.taskService.getAllTaskWay("2");
        List retData = this.getTaskWays(tw);
        map.put("dataList", retData);
        map.put("refViewModel", null);
        return map;
    }
}

