/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.controller.rest;

import com.alibaba.fastjson.util.TypeUtils;
import com.yonyou.iuap.dispatch.DailyTimeIntervalTaskConfig;
import com.yonyou.iuap.dispatch.DispatchManager;
import com.yonyou.iuap.dispatch.server.common.RecallUtil;
import com.yonyou.iuap.dispatch.server.service.DispatchServerService;
import com.yonyou.iuap.dispatch.server.service.TaskGroupService;
import com.yonyou.iuap.dispatch.server.service.TaskLogService;
import com.yonyou.iuap.dispatch.server.service.TaskParamService;
import com.yonyou.iuap.dispatch.server.service.TaskRecallParamService;
import com.yonyou.iuap.dispatch.server.service.TaskService;
import com.yonyou.iuap.dispatch.server.service.TaskTimeService;
import com.yonyou.iuap.dispatch.server.service.TaskUserService;
import com.yonyou.iuap.dispatch.server.util.Util;
import com.yonyou.iuap.entity.Task;
import com.yonyou.iuap.entity.TaskParam;
import com.yonyou.iuap.entity.TaskTime;
import com.yonyou.iuap.entity.TaskUser;
import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/taskrest"})
public class TaskRestController {
    private static Logger logger = LoggerFactory.getLogger(TaskRestController.class);
    @Autowired
    TaskService taskService;
    @Autowired
    TaskGroupService taskGroupService;
    @Autowired
    DispatchServerService dispatchServerService;
    @Autowired
    TaskLogService taskLogService;
    @Autowired
    TaskParamService taskParamService;
    @Autowired
    TaskTimeService taskTimeService;
    @Autowired
    TaskUserService taskUserService;
    @Autowired
    TaskRecallParamService taskRecallParamService;

    @RequestMapping(value={"/saveTask"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> saveTask(@RequestBody JSONObject dataJson) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String taskid = null;
        try {
            Task task;
            JSONObject taskJson;
            if (dataJson.has("task")) {
                Iterator i$;
                String taskcode;
                List tasks;
                taskJson = dataJson.getJSONObject("task");
                task = this.parseTask(taskJson);
                task.setId(task.getId());
                taskid = task.getId();
                JSONObject taskWayJson = taskJson.getJSONObject("taskway");
                String taskWayId = taskWayJson.getString("id");
                String url = this.taskService.getTaskWayById(taskWayId).getUrl();
                String sysid = null;
                String tenantid = null;
                if (taskJson.getString("sysid") != null && taskJson.getString("tenantid") != null) {
                    sysid = taskJson.getString("sysid");
                    tenantid = taskJson.getString("tenantid");
                    task.setTenantid(tenantid);
                    task.setSysid(sysid);
                } else {
                    sysid = InvocationInfoProxyAdapter.getSysid();
                    tenantid = InvocationInfoProxyAdapter.getTenantid();
                }
                List taskParams = this.parseTaskWay(taskJson);
                HashMap<String, String> recallData = new HashMap<String, String>();
                recallData.put("option", Util.getOptionValue((String)url, (String)tenantid, (String)sysid));
                recallData.put("data", Util.getDataValue((List)taskParams, null));
                TaskTime taskTime = this.parseTaskTime(taskJson, task.getId());
                if (taskTime == null) {
                    retMap.put("status", 0);
                    retMap.put("msg", "\u5f02\u5e38:\u6dfb\u52a0\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                    return retMap;
                }
                String nextTime = this.getNextExecuteTime(task.getId(), task.getGroupid(), taskTime);
                if ("\u5df2\u8fc7\u671f".equals(nextTime)) {
                    retMap.put("status", 0);
                    retMap.put("msg", "\u5931\u8d25:\u5df2\u8fc7\u671f");
                    retMap.put("taskid", taskid);
                    return retMap;
                }
                if (!taskJson.has("id") && null != (tasks = this.taskService.getTaskByCode(taskcode = task.getCode(), tenantid)) && (i$ = tasks.iterator()).hasNext()) {
                    Task t = (Task)i$.next();
                    retMap.put("status", 0);
                    retMap.put("msg", "\u4efb\u52a1\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                    retMap.put("taskid", t.getId());
                    return retMap;
                }
                DailyTimeIntervalTaskConfig taskConfig = Util.convertToTaskConfig((String)task.getId(), (String)task.getGroupid(), (TaskTime)taskTime);
                DispatchManager.addDailyTimeIntervalTrigger((DailyTimeIntervalTaskConfig)taskConfig, (Class)RecallUtil.getRecall((String)"HTTP"), recallData, (boolean)true);
                if (taskJson.has("id") && !StringUtils.isEmpty((Object)taskJson.getString("id"))) {
                    this.taskService.updateByPrimaryKey(task);
                    this.taskRecallParamService.deleteByTaskId(taskid);
                    this.taskRecallParamService.insertTaskRecallParam(taskParams, taskid);
                } else {
                    task.setFlag(Integer.valueOf(1));
                    this.taskService.addTask(task);
                    this.taskRecallParamService.insertTaskRecallParam(taskParams, taskid);
                }
                JSONObject timeWayJson = taskJson.getJSONObject("timeway");
                if (timeWayJson.has("id") && !StringUtils.isEmpty((Object)timeWayJson.getString("id"))) {
                    taskTime.setId(timeWayJson.getString("id"));
                    this.taskTimeService.updateByPrimaryKey(taskTime);
                } else {
                    this.taskTimeService.saveTaskTime(taskTime);
                }
            } else {
                retMap.put("status", 0);
                retMap.put("msg", "Json\u683c\u5f0f\u4e0d\u6b63\u786e");
                return retMap;
            }
            this.saveTaskUser(taskJson, task.getId());
        }
        catch (Exception e) {
            retMap.put("status", 0);
            retMap.put("msg", "\u5f02\u5e38:\u6dfb\u52a0\u4efb\u52a1\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
            return retMap;
        }
        retMap.put("status", 1);
        retMap.put("msg", "\u6210\u529f:\u6dfb\u52a0\u4efb\u52a1\u6210\u529f\uff01");
        retMap.put("taskid", taskid);
        logger.debug("\u6dfb\u52a0\u4efb\u52a1\u6210\u529f\uff01");
        return retMap;
    }

    private Task parseTask(JSONObject taskJson) throws JSONException {
        Task task = new Task();
        task.setName(taskJson.getString("taskname"));
        task.setCode(taskJson.getString("taskcode"));
        task.setGroupid(taskJson.getString("gid"));
        JSONObject taskWayJson = taskJson.getJSONObject("taskway");
        String taskWayId = taskWayJson.getString("id");
        task.setTaskwayid(taskWayId);
        task.setCreatetime(new Date());
        if (taskJson.has("taskdesc")) {
            task.setDescription(taskJson.getString("taskdesc"));
        }
        task.setSysid(taskJson.getString("sysid"));
        task.setTenantid(taskJson.getString("tenantid"));
        task.setUserid(taskJson.getString("userid"));
        if (taskJson.has("id") && !StringUtils.isEmpty((Object)taskJson.getString("id"))) {
            task.setId(taskJson.getString("id"));
        }
        if (taskJson.has("flag")) {
            task.setFlag(Integer.valueOf(taskJson.getString("flag")));
        }
        return task;
    }

    private List<TaskParam> parseTaskWay(JSONObject taskJson) throws JSONException {
        ArrayList<TaskParam> taskParames = new ArrayList<TaskParam>();
        if (taskJson.has("taskway")) {
            JSONObject taskWayJson = taskJson.getJSONObject("taskway");
            String taskWayId = taskWayJson.getString("id");
            if (taskWayJson.has("taskParams")) {
                JSONArray taskParamsJson = taskWayJson.getJSONArray("taskParams");
                for (int i = 0; i < taskParamsJson.length(); ++i) {
                    TaskParam taskParam = new TaskParam();
                    JSONObject taskParamJson = taskParamsJson.getJSONObject(i);
                    String taskParamId = taskParamJson.getString("id");
                    TaskParam taskParamEntiy = this.taskParamService.selectByPrimaryKey(taskParamId);
                    taskParam.setId(taskParamJson.getString("id"));
                    taskParam.setTaskwayid(taskWayId);
                    taskParam.setCode(taskParamEntiy.getCode());
                    String paramName = taskParamEntiy.getName();
                    taskParam.setName(paramName);
                    String paramvalue = taskParamJson.getString("paramvalue");
                    taskParam.setParamvalue(paramvalue);
                    taskParames.add(taskParam);
                }
            }
        }
        return taskParames;
    }

    private TaskTime parseTaskTime(JSONObject taskJson, String taskId) throws JSONException {
        if (taskJson.has("timeway")) {
            TaskTime taskTime = new TaskTime();
            taskTime.setTaskid(taskId);
            JSONObject timeWayJson = taskJson.getJSONObject("timeway");
            taskTime.setStarttime(TypeUtils.castToDate((Object)(timeWayJson.getString("starttime") + ":00")));
            taskTime.setEndtime(TypeUtils.castToDate((Object)(timeWayJson.getString("endtime") + ":00")));
            JSONObject modeTimeJson = timeWayJson.getJSONObject("modetime");
            taskTime.setModetype(Integer.valueOf(modeTimeJson.getInt("modetype")));
            taskTime.setModefrequency(Integer.valueOf(modeTimeJson.getInt("modefrequency")));
            if (modeTimeJson.has("modevaule")) {
                JSONArray modeValue = modeTimeJson.getJSONArray("modevaule");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < modeValue.length(); ++i) {
                    sb.append(modeValue.get(i) + ";");
                }
                taskTime.setModevaule(sb.toString());
            }
            JSONObject duraJson = timeWayJson.getJSONObject("dura");
            taskTime.setDuramode(Integer.valueOf(duraJson.getInt("duramode")));
            taskTime.setDuravalue(duraJson.getString("duravalue"));
            if (duraJson.has("period")) {
                JSONObject periodJson = duraJson.getJSONObject("period");
                taskTime.setPeriodmode(Integer.valueOf(periodJson.getInt("periodmode")));
                taskTime.setPeriodstart(periodJson.getString("periodstart"));
                taskTime.setPeriodend(periodJson.getString("periodend"));
            }
            return taskTime;
        }
        return null;
    }

    private boolean saveTaskUser(JSONObject taskJson, String taskid) throws JSONException {
        ArrayList<TaskUser> taskUsers = new ArrayList<TaskUser>();
        try {
            if (taskJson.has("taskmsg")) {
                JSONArray taskMsgJsons = taskJson.getJSONArray("taskmsg");
                this.taskUserService.deleteTaskUsersById(taskid);
                for (int i = 0; i < taskMsgJsons.length(); ++i) {
                    TaskUser taskUser = new TaskUser();
                    taskUser.setTaskid(taskid);
                    JSONObject taskMsgJson = taskMsgJsons.getJSONObject(i);
                    taskUser.setUserCode(taskMsgJson.getString("userCode"));
                    taskUser.setUserName(taskMsgJson.getString("userName"));
                    taskUser.setMsg(Integer.valueOf(taskMsgJson.getInt("msg")));
                    taskUser.setEmail(Integer.valueOf(taskMsgJson.getInt("email")));
                    taskUser.setPhone(Integer.valueOf(taskMsgJson.getInt("phone")));
                    taskUser.setUserid(taskMsgJson.getString("userid"));
                    taskUsers.add(taskUser);
                    this.taskUserService.saveTaskUser(taskUser);
                }
            }
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private void writeJSON(HttpServletResponse response, String json) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(json);
        response.flushBuffer();
    }

    @RequestMapping(value={"/getTaskWayParamByTaskWayId"})
    @ResponseBody
    public Map<String, Object> getTaskWayParamByTaskWayId(HttpServletRequest request) {
        String taskWayId = request.getParameter("taskWayId");
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            List taskParam = this.taskParamService.getTaskParamByTaskWayId(taskWayId);
            retMap.put("status", 1);
            retMap.put("taskWayParam", taskParam);
        }
        catch (Exception e) {
            retMap.put("msg", "\u5f02\u5e38:\u67e5\u8be2\u8c03\u7528\u89c4\u5219\u7cfb\u7edf\u5f02\u5e38\u6216\u8005\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    private String getNextExecuteTime(String taskId, String groupId, TaskTime taskTime) {
        String nextTime = "";
        DailyTimeIntervalTaskConfig taskConfig = null;
        try {
            Date now = new Date();
            taskConfig = Util.convertToTaskConfig((String)taskId, (String)groupId, (TaskTime)taskTime);
            OperableTrigger trigger = Util.getTrigger((DailyTimeIntervalTaskConfig)taskConfig, (String)taskId, (String)groupId, (TaskTime)taskTime, (Date)now);
            nextTime = Util.getNextExecuteTime((OperableTrigger)trigger, (String)taskId, (String)groupId, (TaskTime)taskTime);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return nextTime;
    }
}

