/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.recall;

import com.alibaba.fastjson.JSON;
import com.yonyou.iuap.base.utils.RestUtils;
import com.yonyou.iuap.dispatch.ITask;
import com.yonyou.iuap.dispatch.common.SpringContextUtil;
import com.yonyou.iuap.dispatch.server.service.ISendMessageService;
import com.yonyou.iuap.dispatch.server.service.TaskLogService;
import com.yonyou.iuap.dispatch.server.service.TaskService;
import com.yonyou.iuap.entity.Task;
import com.yonyou.iuap.entity.TaskLog;
import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.quartz.JobDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class HttpRecall
implements ITask {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(HttpRecall.class);

    public void execute(Map<String, Object> data) {
        com.alibaba.fastjson.JSONObject dataJson = JSON.parseObject((String)data.get("option").toString());
        String url = dataJson.getString("url");
        String sysid = dataJson.getString("sysid");
        String tenantid = dataJson.getString("tenantid");
        HashMap<String, String> cookies = new HashMap<String, String>();
        cookies.put("sysid", sysid);
        cookies.put("tenantid", tenantid);
        JobDetail jobDetail = (JobDetail)data.get("jobinfo");
        TaskLog taskLog = null;
        InvocationInfoProxyAdapter.setSysid((String)sysid);
        InvocationInfoProxyAdapter.setTenantid((String)tenantid);
        taskLog = this.insertTaskLogVO(jobDetail);
        Map<String, String> map = new HashMap();
        try {
            logger.debug("\u5f00\u59cb\u6267\u884c\u4efb\u52a1,\u4efb\u52a1 URL\u662f" + url);
            String result = (String)RestUtils.getInstance().doPostWithSign(url, (Object)this.getReturnData(data, taskLog.getId()), String.class);
            logger.debug("\u6267\u884c\u4efb\u52a1\u7ed3\u675f,\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
            map = this.processResult(result);
            this.updateTaskLogVO(taskLog, map);
            this.senMsg(map, jobDetail, true);
        }
        catch (Exception e) {
            String content = "post url exception. the url is " + url + "\n\t" + e.getMessage();
            logger.error("post url exception. the url is " + url, (Throwable)e);
            String msgContent = "\u4efb\u52a1\u6267\u884c\u5931\u8d25,\u5177\u4f53\u4efb\u52a1\u7684url\u662f" + url + "\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage();
            map.put("sendMsgContent", msgContent);
            this.updateTaskLogVO4Failure(taskLog, msgContent);
            this.senMsg(map, jobDetail, false);
        }
    }

    private void senMsg(Map<String, Object> map, JobDetail jobDetail, boolean isSuccess) {
        try {
            Object msgContentObj = map.get("sendMsgContent");
            String msgContent = "";
            msgContent = StringUtils.isEmpty((Object)msgContentObj) ? "\u4efb\u52a1\u6267\u884c\u6210\u529f,\u4f46\u8fd4\u56de\u7ed9\u6d88\u606f\u63a5\u6536\u8005\u7684\u4fe1\u606f\u4e3a\u7a7a" + msgContent : String.valueOf(msgContentObj);
            logger.debug("\u4efb\u52a1\u53d1\u9001\u6d88\u606f\u5f00\u59cb");
            this.getSendMessageService().sendMsg(jobDetail.getKey().getName(), msgContent, "\u4efb\u52a1\u6267\u884c\u72b6\u6001", isSuccess);
            logger.debug("\u4efb\u52a1\u53d1\u9001\u6d88\u606f\u7ed3\u675f");
        }
        catch (IOException e) {
            logger.error("\u4efb\u52a1\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private Map<String, String> getReturnData(Map<String, Object> data, String taskLogId) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : data.keySet()) {
            if ("data".equals(key)) {
                map.put(key, data.get(key) == null ? null : data.get(key).toString());
                continue;
            }
            map.put(key, null);
        }
        map.put("tasklogid", taskLogId);
        return map;
    }

    private ISendMessageService getSendMessageService() {
        return (ISendMessageService)SpringContextUtil.getBean((String)"SendMessageService");
    }

    private TaskLogService getTaskLogService() {
        return (TaskLogService)SpringContextUtil.getBean((String)"TaskLogService");
    }

    private TaskService getTaskService() {
        return (TaskService)SpringContextUtil.getBean((String)"TaskService");
    }

    private TaskLog insertTaskLogVO(JobDetail jobDetail) {
        TaskLog taskLog = new TaskLog();
        taskLog.setStarttime(new Date());
        taskLog.setTaskid(jobDetail.getKey().getName());
        Object jobcode = jobDetail.getJobDataMap().get((Object)"jobCode");
        Object jobgroupCode = jobDetail.getJobDataMap().get((Object)"jobGroupCode");
        taskLog.setJobcode(jobcode == null ? null : jobcode.toString());
        taskLog.setJobgroupcode(jobgroupCode == null ? null : jobgroupCode.toString());
        Task task = this.getTaskService().getTaskByPrimaryKey(jobDetail.getKey().getName());
        if (task == null) {
            taskLog.setVisible(Integer.valueOf(0));
        } else {
            taskLog.setVisible(Integer.valueOf(1));
        }
        this.getTaskLogService().insert(taskLog);
        return taskLog;
    }

    private void updateTaskLogVO(TaskLog taskLog, Map<String, Object> returnMsgMap) {
        Date endTime = new Date();
        if (endTime.getTime() < taskLog.getStarttime().getTime()) {
            endTime = taskLog.getStarttime();
        }
        taskLog.setEndtime(new Date());
        Object asynchronized = returnMsgMap.get("asynchronized");
        if (asynchronized != null && "true".equals(asynchronized.toString())) {
            taskLog.setFlag(Integer.valueOf(2));
            this.getTaskLogService().updateByPrimaryKeyWithBLOBs(taskLog);
            return;
        }
        Integer intflag = 0;
        Object objFlag = returnMsgMap.get("success");
        if (objFlag != null) {
            intflag = "true".equals(objFlag.toString()) ? 1 : 0;
        }
        taskLog.setFlag(intflag);
        Object objContent = returnMsgMap.get("resultValue");
        String content = objContent == null ? "\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c" : objContent.toString();
        try {
            taskLog.setContent(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.getTaskLogService().updateByPrimaryKey(taskLog);
    }

    private void updateTaskLogVO4Failure(TaskLog taskLog, String failureContent) {
        taskLog.setEndtime(new Date());
        taskLog.setFlag(Integer.valueOf(0));
        try {
            taskLog.setContent(failureContent.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.getTaskLogService().updateByPrimaryKey(taskLog);
    }

    private Map<String, Object> processResult(String returnStr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONObject json;
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)returnStr) && (json = JSONObject.fromObject((Object)returnStr.trim())) != null) {
                map.put("success", json.get("success"));
                map.put("resultValue", json.get("resultValue"));
                map.put("sendMsgContent", json.get("sendMsgContent"));
                map.put("asynchronized", json.get("asynchronized"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            map.put("resultValue", "Json\u89e3\u6790\u9519\u8bef\uff0c\u8c03\u7528URL\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a" + returnStr);
        }
        return map;
    }
}

