/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.recall;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yonyou.iuap.dispatch.ITask;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketRecall
implements ITask {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(SocketRecall.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, Object> data) {
        try {
            JSONObject dataJson = JSON.parseObject((String)data.get("option").toString());
            String socketHost = dataJson.getString("host");
            int socketPort = dataJson.getIntValue("port");
            Socket client = new Socket();
            InetSocketAddress remoteAddr = new InetSocketAddress(socketHost, socketPort);
            client.connect(remoteAddr, 60000);
            logger.debug("client create connect to server success.");
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
                PrintWriter writer = new PrintWriter(client.getOutputStream());
                int i = 3;
                while (i-- > 0) {
                    writer.println(JSON.toJSONString(data));
                    writer.flush();
                    String result = reader.readLine();
                    if ("SUCCESS".equals(result)) {
                        logger.debug("send trigger task data to client success.");
                        break;
                    }
                    logger.debug("send trigger task data to client fail.");
                }
            }
            finally {
                client.close();
            }
        }
        catch (Exception e) {
            logger.error("execute task error", (Throwable)e);
        }
    }
}

