/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yonyou.iuap.dispatch.CronTaskConfig;
import com.yonyou.iuap.dispatch.DispatchManager;
import com.yonyou.iuap.dispatch.SimpleTaskConfig;
import com.yonyou.iuap.dispatch.TimeConfig;
import com.yonyou.iuap.dispatch.common.IntervalTypeEnum;
import com.yonyou.iuap.dispatch.server.common.RecallUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DispatchServerService {
    private static Logger logger = LoggerFactory.getLogger(DispatchServerService.class);

    public String addTask(String data) {
        try {
            JSONObject dataJson = JSON.parseObject((String)data);
            boolean replace = dataJson.getBooleanValue("replace");
            HashMap<String, String> recallData = new HashMap<String, String>();
            JSONObject recallConfigJson = JSON.parseObject((String)dataJson.getString("recallConfig"));
            String recallConfigOption = recallConfigJson.getString("option");
            recallData.put("option", recallConfigOption);
            recallData.put("data", recallConfigJson.getString("data"));
            String recallType = recallConfigJson.getString("recallType");
            JSONObject taskConfigJson = JSON.parseObject((String)dataJson.getString("taskConfig"));
            String triggerType = taskConfigJson.getString("triggerType");
            if ("CronTrigger".equals(triggerType)) {
                CronTaskConfig taskConfig = (CronTaskConfig)this.convertToCronTaskConfig(taskConfigJson);
                DispatchManager.add((CronTaskConfig)taskConfig, (Class)RecallUtil.getRecall((String)recallType), recallData, (boolean)replace);
                return null;
            }
            if ("SimpleTrigger".equals(triggerType)) {
                SimpleTaskConfig taskConfig = (SimpleTaskConfig)this.convertToSimpleTaskConfig(taskConfigJson);
                DispatchManager.add((SimpleTaskConfig)taskConfig, (Class)RecallUtil.getRecall((String)recallType), recallData, (boolean)replace);
                return null;
            }
            logger.error("taskConfig data format error");
            return "taskConfig data format error";
        }
        catch (Exception e) {
            logger.error("add task", (Throwable)e);
            return e.getMessage();
        }
    }

    public String pauseTask(String data) {
        JSONObject dataJson = JSON.parseObject((String)data);
        return DispatchManager.pauseJob((String)dataJson.getString("jobName"), (String)dataJson.getString("groupName"));
    }

    public String resumeTask(String data) {
        JSONObject dataJson = JSON.parseObject((String)data);
        return DispatchManager.resumeJob((String)dataJson.getString("jobName"), (String)dataJson.getString("groupName"));
    }

    public String deleteTask(String data) {
        JSONObject dataJson = JSON.parseObject((String)data);
        return DispatchManager.deleteJob((String)dataJson.getString("jobName"), (String)dataJson.getString("groupName"));
    }

    public String triggerTask(String data) {
        JSONObject dataJson = JSON.parseObject((String)data);
        return DispatchManager.triggerJob((String)dataJson.getString("jobName"), (String)dataJson.getString("groupName"));
    }

    private Object convertToCronTaskConfig(JSONObject dataJson) {
        CronTaskConfig taskConfig = new CronTaskConfig();
        taskConfig.setJobCode(dataJson.getString("jobCode"));
        taskConfig.setGroupCode(dataJson.getString("groupCode"));
        taskConfig.setCronExpress(dataJson.getString("cronExpress"));
        if (dataJson.get((Object)"endDate") != null) {
            taskConfig.setEndDate(dataJson.getDate("endDate"));
        }
        taskConfig.setPriority(dataJson.getIntValue("priority"));
        return taskConfig;
    }

    private Object convertToSimpleTaskConfig(JSONObject dataJson) {
        SimpleTaskConfig taskConfig = new SimpleTaskConfig();
        taskConfig.setJobCode(dataJson.getString("jobCode"));
        taskConfig.setGroupCode(dataJson.getString("groupCode"));
        if (dataJson.get((Object)"startDate") != null) {
            taskConfig.setStartDate(dataJson.getDate("startDate"));
        }
        if (dataJson.get((Object)"endDate") != null) {
            taskConfig.setEndDate(dataJson.getDate("endDate"));
        }
        taskConfig.setPriority(dataJson.getIntValue("priority"));
        taskConfig.setTimeConfig(this.getTimeConfig(dataJson));
        return taskConfig;
    }

    private TimeConfig getTimeConfig(JSONObject dataJson) {
        try {
            JSONObject timeConfigJson = JSON.parseObject((String)dataJson.getString("timeConfig"));
            if (timeConfigJson == null) {
                return null;
            }
            timeConfigJson.getObject("intervalType", IntervalTypeEnum.class);
            TimeConfig timeConfig = new TimeConfig(timeConfigJson.getIntValue("interval"), (IntervalTypeEnum)timeConfigJson.getObject("intervalType", IntervalTypeEnum.class), timeConfigJson.getBooleanValue("isForever"), timeConfigJson.getIntValue("repeatCount"));
            return timeConfig;
        }
        catch (Exception e) {
            logger.error("get TimeConfig", (Throwable)e);
            return null;
        }
    }
}

