/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.service;

import com.yonyou.iuap.dao.TaskMapper;
import com.yonyou.iuap.dao.TaskWayMapper;
import com.yonyou.iuap.entity.Task;
import com.yonyou.iuap.entity.TaskVo;
import com.yonyou.iuap.entity.TaskWay;
import com.yonyou.iuap.mybatis.type.PageResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

@Service(value="TaskService")
public class TaskService {
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private TaskWayMapper taskWayMapper;

    public int addTask(Task record) {
        return this.taskMapper.insert(record);
    }

    public int deleteByPrimaryKey(String id) {
        return this.taskMapper.deleteByPrimaryKey(id);
    }

    public int getTaskCountByGroupId(String groupId) {
        return this.taskMapper.selectCountTaskByGroupId(groupId);
    }

    public Task getTaskByPrimaryKey(String id) {
        return this.taskMapper.selectByPrimaryKey(id);
    }

    public List<Task> getTaskByGroupId(String gid, int pageNow, int pageSize) {
        PageRequest pageRequest = new PageRequest(pageNow, pageSize);
        PageResult pageResult = this.taskMapper.retrievePageTaskByGroupId(pageRequest, gid);
        List list = pageResult.getContent();
        return list;
    }

    public int updateByPrimaryKey(Task record) {
        return this.taskMapper.updateByPrimaryKey(record);
    }

    public List<Task> getTaskByLikeName(String taskName) {
        return this.taskMapper.selectTaskByLikeName(taskName);
    }

    public List<Task> getTaskByCode(String taskCode, String tenantid) {
        return this.taskMapper.selectTaskByCode(taskCode, tenantid);
    }

    public List<Task> getTaskByLikeName(String taskName, int pageNow, int pageSize) {
        PageRequest pageRequest = new PageRequest(pageNow, pageSize);
        PageResult pageResult = this.taskMapper.retrievePageTaskByLikeName2(pageRequest, taskName);
        List list = pageResult.getContent();
        return list;
    }

    public TaskVo getTaskById(String id) {
        TaskVo taskVo = (TaskVo)this.taskMapper.selectTaskById(id);
        return taskVo;
    }

    public TaskWay getTaskWayById(String id) {
        return this.taskWayMapper.selectByPrimaryKey(id);
    }

    public List<TaskWay> getAllTaskWay() {
        return this.taskWayMapper.selectAll();
    }

    public List<TaskWay> getAllTaskWay(String taskWayClassId) {
        return this.taskWayMapper.selectAllByClassId(taskWayClassId);
    }

    public List<TaskWay> getAllTaskWayByBlurParam(String taskWayClassId, String blur) {
        return this.taskWayMapper.selectAllByClassIdAndBlur(taskWayClassId, blur);
    }

    public List<TaskWay> getAllTaskWayByIds(String[] ids) {
        return this.taskWayMapper.selectByPrimaryKeys(ids);
    }

    public List<TaskWay> blurMatch(String blur) {
        return this.taskWayMapper.blurMatch(blur);
    }

    public List<TaskWay> filterMatch(String blur) {
        return this.taskWayMapper.filterMatch(blur);
    }

    public int selectConutTaskByLikeName(String taskName) {
        return this.taskMapper.selectConutTaskByLikeName(taskName);
    }

    public List<Task> selectAllTask() {
        return this.taskMapper.selectAllTask();
    }
}

