/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.service;

import com.yonyou.iuap.dao.TaskUserMapper;
import com.yonyou.iuap.entity.TaskUser;
import com.yonyou.iuap.user.entity.UserEntity;
import com.yonyou.iuap.user.service.UserInfoService;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="TaskUserService")
public class TaskUserService {
    @Autowired
    private TaskUserMapper taskUserMapper;
    @Autowired
    @Qualifier(value="userInfoService")
    private UserInfoService userInfoservice;

    public int saveTaskUser(TaskUser record) {
        return this.taskUserMapper.insert(record);
    }

    public int updateTaskUser(TaskUser record) {
        return this.taskUserMapper.updateByPrimaryKey(record);
    }

    public List<TaskUser> queryTaskUserByTaskId(String taskid) {
        List users = this.taskUserMapper.queryTaskUserByTaskId(taskid);
        if (users == null) {
            return users;
        }
        HashMap<String, TaskUser> map = new HashMap<String, TaskUser>();
        String[] userIds = new String[users.size()];
        for (TaskUser taskUser : users) {
            map.put(taskUser.getUserid(), taskUser);
        }
        map.keySet().toArray(userIds);
        List userEntitys = this.userInfoservice.getUsersByIds(userIds);
        if (userEntitys == null) {
            return users;
        }
        for (UserEntity userEntity : userEntitys) {
            TaskUser user = (TaskUser)map.get(userEntity.getId());
            user.setUserCode(userEntity.getUserCode());
            user.setUserName(userEntity.getUserName());
        }
        return users;
    }

    public void deleteTaskUsersById(String taskid) {
        this.taskUserMapper.deleteTaskUsersById(taskid);
    }
}

