/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.service.impl;

import com.yonyou.iuap.dispatch.server.common.ConfigUtil;
import com.yonyou.iuap.dispatch.server.service.ISendMessageService;
import com.yonyou.iuap.dispatch.server.service.ITaskUserService;
import com.yonyou.iuap.dispatch.server.service.TaskService;
import com.yonyou.iuap.entity.Task;
import com.yonyou.iuap.entity.TaskUser;
import com.yonyou.uap.msg.sdk.MessageCenterUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SendMessageService")
public class DefaultSendMessageServiceImpl
implements ISendMessageService {
    @Autowired
    private ITaskUserService taskUserService;
    @Autowired
    private TaskService taskService;

    public void sendMsg(String taskid, String msgContent, String msgTitle, boolean isTaskSuccess) throws IOException {
        Task taskVO = this.taskService.getTaskByPrimaryKey(taskid);
        List taskUserList = null;
        taskUserList = isTaskSuccess ? this.taskUserService.queryTaskUserByTaskId(taskid) : this.getATaskCreatorUser(taskVO);
        if (null == taskUserList || taskUserList.size() < 1) {
            return;
        }
        List channelList = this.getChannelCode();
        Map dataMap = this.buildBaseDataMap(msgContent, msgTitle, taskVO.getTenantid());
        Map channelUserMap = this.getUserListByChannel(channelList, taskUserList);
        for (String channelCode : channelList) {
            dataMap.put("channel", new String[]{channelCode});
            List receiver = (List)channelUserMap.get(channelCode);
            if (receiver.size() <= 0) continue;
            dataMap.put("recevier", receiver);
            String parameterData = "{data:" + JSONObject.fromObject((Object)dataMap).toString() + "}";
            MessageCenterUtil.pushTextMessage((String)parameterData);
        }
    }

    private List<TaskUser> getATaskCreatorUser(Task taskVO) {
        ArrayList<TaskUser> userList = new ArrayList<TaskUser>();
        TaskUser user = new TaskUser();
        user.setUserid(taskVO == null ? null : taskVO.getUserid());
        user.setEmail(Integer.valueOf(1));
        user.setMsg(Integer.valueOf(1));
        user.setPhone(Integer.valueOf(0));
        userList.add(user);
        return userList;
    }

    private Map<String, List<String>> getUserListByChannel(List<String> channelList, List<TaskUser> taskUserList) {
        HashMap<String, List<String>> channelUserMap = new HashMap<String, List<String>>();
        HashSet<String> emailTaskUsers = new HashSet<String>();
        HashSet<String> smsTaskUsers = new HashSet<String>();
        HashSet<String> sysTaskUsers = new HashSet<String>();
        for (TaskUser taskUser : taskUserList) {
            if (taskUser.getEmail().equals(1)) {
                emailTaskUsers.add(taskUser.getUserid());
            }
            if (taskUser.getPhone().equals(1)) {
                smsTaskUsers.add(taskUser.getUserid());
            }
            if (!taskUser.getMsg().equals(1)) continue;
            sysTaskUsers.add(taskUser.getUserid());
        }
        for (String channelCode : channelList) {
            ArrayList<String> receiver = new ArrayList<String>();
            if (channelCode.equals(ConfigUtil.getProperties((String)"email.msgChannelCode"))) {
                receiver.addAll(emailTaskUsers);
            }
            if (channelCode.equals(ConfigUtil.getProperties((String)"sms.msgChannelCode"))) {
                receiver.addAll(smsTaskUsers);
            }
            if (channelCode.equals(ConfigUtil.getProperties((String)"sys.msgChannelCode"))) {
                receiver.addAll(sysTaskUsers);
            }
            channelUserMap.put(channelCode, receiver);
        }
        return channelUserMap;
    }

    private Map<String, Object> buildBaseDataMap(String msgContent, String msgTitle, String tenantid) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String msgtype = ConfigUtil.getProperties((String)"msg.msgtype");
        dataMap.put("msgtype", msgtype);
        dataMap.put("subject", msgTitle);
        dataMap.put("content", msgContent);
        dataMap.put("sendman", "\u4efb\u52a1\u8c03\u5ea6\u7cfb\u7edf\u53d1\u9001");
        dataMap.put("tenantid", tenantid);
        return dataMap;
    }

    private List<String> getChannelCode() {
        ArrayList<String> channelCodeList = new ArrayList<String>();
        String emailChannelCode = ConfigUtil.getProperties((String)"email.msgChannelCode");
        String smsChannelCode = ConfigUtil.getProperties((String)"sms.msgChannelCode");
        String sysChannelCode = ConfigUtil.getProperties((String)"sys.msgChannelCode");
        if (StringUtils.isNotBlank((String)emailChannelCode)) {
            channelCodeList.add(emailChannelCode);
        }
        if (StringUtils.isNotBlank((String)smsChannelCode)) {
            channelCodeList.add(smsChannelCode);
        }
        if (StringUtils.isNotBlank((String)sysChannelCode)) {
            channelCodeList.add(sysChannelCode);
        }
        return channelCodeList;
    }
}

