/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.dispatch.server.util;

import com.yonyou.iuap.dispatch.DailyTimeIntervalTaskConfig;
import com.yonyou.iuap.entity.TaskParam;
import com.yonyou.iuap.entity.TaskRecallParam;
import com.yonyou.iuap.entity.TaskTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.quartz.Calendar;
import org.quartz.DateBuilder;
import org.quartz.TimeOfDay;
import org.quartz.TriggerUtils;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.MonthlyCalendar;
import org.quartz.impl.calendar.WeeklyCalendar;
import org.quartz.impl.triggers.DailyTimeIntervalTriggerImpl;
import org.quartz.spi.OperableTrigger;

/*
 * Exception performing whole class analysis ignored.
 */
public class Util {
    public static DateBuilder.IntervalUnit getIntervalUnit(TaskTime taskTime) {
        DateBuilder.IntervalUnit intervalUnit = null;
        int periodmode = taskTime.getPeriodmode();
        intervalUnit = periodmode == 0 ? DateBuilder.IntervalUnit.HOUR : DateBuilder.IntervalUnit.MINUTE;
        return intervalUnit;
    }

    public static String getTimeDiff(Date beginDate, Date endDate) {
        String timeDiff = null;
        if (endDate == null || endDate.getTime() < beginDate.getTime()) {
            timeDiff = "\u5df2\u8fc7\u671f";
            return timeDiff;
        }
        long timeDis = endDate.getTime() - beginDate.getTime();
        long mins = timeDis / 1000L / 60L;
        long minuteOfDay = 1440L;
        long minuteOfHour = 60L;
        timeDiff = mins > minuteOfDay ? mins / 1440L + "\u5929" + mins % 1440L / 60L + " \u5c0f\u65f6 " + mins % 1440L % 60L + " \u5206\u949f" : (mins > minuteOfHour ? mins / 60L + " \u5c0f\u65f6 " + mins % 60L + " \u5206\u949f" : mins + " \u5206\u949f");
        return timeDiff;
    }

    public static DailyTimeIntervalTaskConfig convertToTaskConfig(String taskId, String groupId, TaskTime taskTime) throws ParseException {
        DailyTimeIntervalTaskConfig taskConfig = new DailyTimeIntervalTaskConfig();
        taskConfig.setJobCode(taskId);
        taskConfig.setGroupCode(groupId);
        taskConfig.setStartDate(taskTime.getStarttime());
        taskConfig.setEndDate(taskTime.getEndtime());
        Util.praseDura((TaskTime)taskTime, (DailyTimeIntervalTaskConfig)taskConfig);
        int modetype = taskTime.getModetype();
        if (modetype == 0) {
            BaseCalendar base = new BaseCalendar();
            taskConfig.setCalendar((Calendar)base);
        }
        String modeValue = taskTime.getModevaule();
        if (modetype == 1) {
            WeeklyCalendar calendar = Util.getWeeklyCalendar((String)modeValue);
            taskConfig.setCalendar((Calendar)calendar);
            return taskConfig;
        }
        if (modetype == 2) {
            MonthlyCalendar monthlyCalendar = Util.getMonthlyCalendar((int)Integer.valueOf(modeValue.split(";")[0]));
            taskConfig.setCalendar((Calendar)monthlyCalendar);
            return taskConfig;
        }
        return taskConfig;
    }

    public static void praseDura(TaskTime taskTime, DailyTimeIntervalTaskConfig taskConfig) throws ParseException {
        int duramode = taskTime.getDuramode();
        String duravalue = taskTime.getDuravalue();
        if (duramode == 0) {
            int h = Integer.valueOf(duravalue.split(":")[0]);
            int m = Integer.valueOf(duravalue.split(":")[1]);
            TimeOfDay startTimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)h, (int)m, (int)0);
            TimeOfDay endTimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)h, (int)m, (int)1);
            taskConfig.setStartTimeOfDay(startTimeOfDay);
            taskConfig.setEndTimeOfDay(endTimeOfDay);
            taskConfig.setIntervalUnit(DateBuilder.IntervalUnit.SECOND);
            taskConfig.setRepeatInterval(2);
            return;
        }
        if (duramode == 1) {
            taskConfig.setRepeatInterval(Integer.valueOf(duravalue).intValue());
            String periodstart = taskTime.getPeriodstart();
            TimeOfDay startTimeOfDay = TimeOfDay.hourAndMinuteFromDate((Date)new SimpleDateFormat("HH:mm:ss").parse(periodstart + ":00"));
            taskConfig.setStartTimeOfDay(startTimeOfDay);
            String periodend = taskTime.getPeriodend();
            TimeOfDay endTimeOfDay = TimeOfDay.hourAndMinuteFromDate((Date)new SimpleDateFormat("HH:mm:ss").parse(periodend + ":00"));
            taskConfig.setEndTimeOfDay(endTimeOfDay);
            taskConfig.setIntervalUnit(Util.getIntervalUnit((TaskTime)taskTime));
        }
    }

    public static WeeklyCalendar getWeeklyCalendar(String weekDay) {
        String[] modeValue = weekDay.split(";");
        List<String> days = Arrays.asList(modeValue);
        WeeklyCalendar calender = new WeeklyCalendar();
        for (int i = 1; i < 8; ++i) {
            calender.setDayExcluded(i, true);
        }
        for (String day : days) {
            calender.setDayExcluded(Integer.valueOf(day) + 1, false);
        }
        return calender;
    }

    public static MonthlyCalendar getMonthlyCalendar(int day) {
        MonthlyCalendar calender = new MonthlyCalendar();
        for (int i = 1; i < 32; ++i) {
            if (i == day) {
                calender.setDayExcluded(i, false);
                continue;
            }
            calender.setDayExcluded(i, true);
        }
        return calender;
    }

    public static String getOptionValue(String url, String tenantid, String sysid) {
        String optionValue = "{\"url\":\"" + url + "\"," + "\"tenantid\":\"" + tenantid + "\"," + "\"sysid\":\"" + sysid + "\"" + "}";
        return optionValue;
    }

    public static String getDataValue(List<TaskParam> taskParams, List<TaskRecallParam> taskRecallParams) {
        StringBuffer paramsData = new StringBuffer();
        paramsData.append("{");
        HashMap<String, String> paramValueMap = new HashMap<String, String>();
        if (taskRecallParams != null && taskRecallParams.size() > 0) {
            for (TaskRecallParam taskRecallParam : taskRecallParams) {
                paramValueMap.put(taskRecallParam.getTaskparamid(), taskRecallParam.getParamvalue());
            }
        }
        for (int i = 0; i < taskParams.size(); ++i) {
            String value;
            TaskParam taskParam = taskParams.get(i);
            String string = value = paramValueMap.get(taskParam.getId()) == null ? taskParam.getParamvalue() : (String)paramValueMap.get(taskParam.getId());
            if (i == taskParams.size() - 1) {
                paramsData.append("\"" + taskParam.getCode() + "\":");
                paramsData.append("\"" + value + "\"");
                continue;
            }
            paramsData.append("\"" + taskParam.getCode() + "\":");
            paramsData.append("\"" + value + "\",");
        }
        paramsData.append("}");
        return paramsData.toString();
    }

    public static String getNextExecuteTime(OperableTrigger trigger, String taskId, String groupId, TaskTime taskTime) {
        String nextTime = "";
        DailyTimeIntervalTaskConfig taskConfig = null;
        try {
            Date now = new Date();
            taskConfig = Util.convertToTaskConfig((String)taskId, (String)groupId, (TaskTime)taskTime);
            if (trigger == null) {
                nextTime = "\u5df2\u8fc7\u671f";
                return nextTime;
            }
            Date nextDate = TriggerUtils.computeEndTimeToAllowParticularNumberOfFirings((OperableTrigger)trigger, (Calendar)taskConfig.getCalendar(), (int)1);
            nextTime = Util.getTimeDiff((Date)now, (Date)nextDate);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return nextTime;
    }

    public static OperableTrigger getTrigger(DailyTimeIntervalTaskConfig taskConfig, String taskId, String groupId, TaskTime taskTime, Date beginDate) {
        DailyTimeIntervalTriggerImpl trigger = null;
        Date startDate = beginDate;
        if (taskConfig.getStartDate() != null && taskConfig.getStartDate().getTime() > beginDate.getTime()) {
            startDate = taskConfig.getStartDate();
        }
        if (taskConfig.getEndDate() != null && taskConfig.getEndDate().getTime() < startDate.getTime()) {
            return null;
        }
        trigger = new DailyTimeIntervalTriggerImpl(taskId, groupId, startDate, taskConfig.getEndDate(), taskConfig.getStartTimeOfDay(), taskConfig.getEndTimeOfDay(), Util.getIntervalUnit((TaskTime)taskTime), taskConfig.getRepeatInterval());
        return trigger;
    }
}

