/*
 * Decompiled with CFR 0.152.
 */
package iuap.ref.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.iweb.exception.WebRuntimeException;
import iuap.ref.base.context.RefPlatform;
import iuap.ref.entity.UIrefEntity;
import iuap.ref.sdk.refmodel.vo.RefViewModelVO;
import iuap.ref.service.inf.IUIrefService;
import iuap.uitemplate.base.context.Platform;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class WebRefModelUtil {
    private ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    @Qualifier(value="referRestTemplate")
    private RestTemplate template;
    @Autowired
    @Qualifier(value="UIrefServiceImpl")
    private IUIrefService iUIrefService;

    public String getRefModel(String refCode, RefViewModelVO refViewModel) {
        HttpServletRequest request = null;
        String refmodelview = "";
        try {
            UIrefEntity refEntity = this.iUIrefService.queryRefModelByCode(refCode);
            if (refEntity == null) {
                throw new WebRuntimeException("\u6ca1\u6709\u627e\u5230\u53c2\u7167\u6ce8\u518c\u4fe1\u606f!refCode=" + refCode);
            }
            String refRestUrl = refEntity.getRefurl();
            RefViewModelVO refModel = null;
            if (StringUtils.isNotEmpty((String)refRestUrl)) {
                this.checkRefServerURL(request);
                refRestUrl = RefPlatform.getBaseHome() + refRestUrl;
                refViewModel.setRefModelUrl(refRestUrl);
                refModel = (RefViewModelVO)this.template.postForObject(refRestUrl + "getRefModelInfo", (Object)refViewModel, RefViewModelVO.class, new Object[0]);
            }
            refmodelview = this.objectMapper.writeValueAsString(refModel);
        }
        catch (Exception e) {
            Platform.getUITemplatLogger().error(e.getMessage(), (Throwable)e);
        }
        return refmodelview;
    }

    private void checkRefServerURL(HttpServletRequest request) {
        if (StringUtils.equalsIgnoreCase((String)RefPlatform.getBaseHome(), (String)"-1")) {
            String refCtx = "http://" + request.getServerName() + ":" + request.getServerPort();
            RefPlatform.setBaseHome((String)refCtx);
        }
    }
}

