define([ 'jquery', 'text!pages/task/man/list.html',"dialogmin","uui"], function($, template,dialogmin) {
    var getgroupUrl = '/taskgroup/findAllTaskGroup.do';//获取分组列表
    var addGroupUrl = '/taskgroup/addTaskGroup.do';//添加分组
    var getlistUrl = '/task/findTaskByGroupId.do?';//获取任务列表
    var opentaskUrl = "/task/resumeTask.do?ids=";//启用任务
    var closetaskUrl = "/task/stopTask.do?ids=";//停用任务
    var deleteUrl = "/task/delTask.do?ids=";//删除任务
    var deletegidUrl="/taskgroup/delTaskGroupById.do?gid=";//删除分组
    var searchUrl="/task/findTaskByName.do?";//删除分组

    var showdetailUrl = '/tmp/detail/detail/:resId/:timestamp';//详情
    var modifyUrl = '/taskedit/man/modify/:resId';//修改
    var addUrl = '/taskadd/man/add/:resId';//添加
    var tasklogUrl = '/tasklog/man/list/:resId';//日志
    var tasklistUrl = '/task/man/list/:resId';//日志
    var pagesize=10;
    addRouter(showdetailUrl);
    addRouter(tasklistUrl);
    addRouter(modifyUrl);
    addRouter(addUrl);
    addRouter(tasklogUrl);
    var viewModel = {
        data : ko.observableArray([]),
        datalist : ko.observableArray([]),
        groupName:ko.observable(""),
        number:ko.observable(""),
        gid:"",
        taskId:ko.observableArray([]),
        selectId:[],
    };
    viewModel.addGroup = function(){
        $(".tasklist-top-newgroup").show();
    };
    viewModel.closeGroup = function(){
        $(".tasklist-top-newgroup").hide();
    };
    viewModel.selectmutil = function(){
        var _this = $(".btn-selectmutil");
        var table = $(".tasklist-right-table");
        if(_this.hasClass("active")){
            _this.removeClass("active");
            table.find(".task_round").show();
            table.find(".list_checkbox").hide();
            $(".select_number").hide()
        }else{
            _this.addClass("active");
            table.find(".task_round").hide();
            table.find(".list_checkbox").show();
            $(".select_number").show()
        }
    };
    viewModel.selectmutilClose = function(){
        var _this = $(".btn-selectmutil");
        var table = $(".tasklist-right-table");
        _this.removeClass("active");
        table.find(".task_round").show();
        table.find(".list_checkbox").hide();
        $(".select_number").hide()
    }
    viewModel.detail = function(id){//添加跳转
        // window.router.init();//跳转弹出框时，先初始化一次路由；
        var timestamp=new Date().getTime();
        window.router.setRoute('/tmp/detail/detail/'+id+'/'+timestamp);
        return false
    };
    viewModel.edit = function(id){//修改
        console.log(id)
        window.router.setRoute('/taskedit/man/modify/'+id);
        return false
    };

    viewModel.addTask = function(){//添加跳转
        var id=viewModel.gid;
        window.router.setRoute('/taskadd/man/add/'+id);
        return false
    };
    viewModel.taskLog = function(){//日志
        window.router.setRoute('/tasklog/man/list/all');
        return false
    };
    viewModel.taskLoglist = function(id){//日志
        window.router.setRoute('/tasklog/man/list/'+id);
        return false
    };
    viewModel.modify = function(resId){
        window.router.setRoute('/app/modify/modify/'+resId);
        return false

    };
    viewModel.openTaskAll = function(id){//批量启用
        if(viewModel.selectId.length==0){
            dialogmin("请选择任务")
            return false;
        }
        var flag=false;
        for(var i=0;i<viewModel.selectId.length;i++){
            if(/^CANNOTDEL/.test(viewModel.selectId[i])){
                flag=true;
            }
        }
        if(flag){
            dialogmin("所选任务中有已过期任务，不能启用")
            return false;
        }
        $.ajax({
            type : 'get',
            url : $ctx + opentaskUrl+viewModel.selectId,
            cache:false,
            dataType : 'json',
            success : function(res) {
                if(res.status==1){
                    dialogmin("启用成功");
                    viewModel.selectId = [];
                    $(".select_number").html("0");
                    viewModel.datalist([]);
                    for(var i=1;i<=viewModel.number();i++){
                        viewModel.tasklist(viewModel.gid,i);
                    }
                    //viewModel.tasklist(viewModel.gid,viewModel.number());
                    viewModel.selectmutilClose()
                }else{
                    dialogmin(res.msg);
                }
            }
        });
        return false

    };
    viewModel.closeTaskAll = function(id){//批量停用
        if(viewModel.selectId.length==0){
            dialogmin("请选择任务")
            return false;
        }
        var flag=false;
        for(var i=0;i<viewModel.selectId.length;i++){
            if(/^CANNOTDEL/.test(viewModel.selectId[i])){
                flag=true;
            }
        }
        if(flag){
            dialogmin("所选任务中有已过期任务，不能停用")
            return false;
        }
        $.ajax({
            type : 'get',
            url : $ctx + closetaskUrl+viewModel.selectId,
            cache:false,
            dataType : 'json',
            success : function(res) {
                if(res.status==1){
                    dialogmin("停用成功");
                    viewModel.selectId = [];
                    $(".select_number").html("0");
                    viewModel.datalist([]);
                    for(var i=1;i<=viewModel.number();i++){
                        viewModel.tasklist(viewModel.gid,i);
                    }
                    //viewModel.tasklist(viewModel.gid,viewModel.number());
                    viewModel.selectmutilClose()
                }else{
                    dialogmin(res.msg);
                }
            }
        });
        return false

    };
    viewModel.delTaskAll = function(id){//批量删除
        if(viewModel.selectId.length==0){
            dialogmin("请选择任务");
            return false;
        }
        var ids=viewModel.selectId;
        for(var i=0;i<ids.length;i++){
            if(ids[i].indexOf('CANNOTDEL')==0){
                ids[i]=ids[i].split('CANNOTDEL')[1];
            }
        }
        window.md=u.dialog({id:'deleteDialog',content:"#delete-dialog",hasCloseMenu:true});
        var okButton = document.body.querySelector(".u-msg-ok");
        md.closeDiv.innerHTML="<span class='iconfont_iform icon-cancel02'></span>";
        if(okButton["uEvent"]){
            u.off(okButton,'click');
        }
        u.on(okButton,'click', function(){
            $.ajax({
                type : 'get',
                url : $ctx + deleteUrl+ids,
                cache:false,
                dataType : 'json',
                success : function(res) {
                    if(res.status==1){
                        dialogmin("删除成功");
                        viewModel.selectId = [];
                        $(".select_number").html("0");
                        viewModel.load(viewModel.gid);
                        viewModel.datalist([]);
                        for(var i=1;i<=viewModel.number();i++){
                            viewModel.tasklist(viewModel.gid,i);
                        }
                        //viewModel.tasklist(viewModel.gid,viewModel.number());
                        viewModel.selectmutilClose();
                        md.close();
                    }else{
                        dialogmin(res.msg);
                    }
                }
            });
        });
        var cancelButton = document.body.querySelector(".u-msg-cancel");
        if(cancelButton["uEvent"]){
            u.off(cancelButton,'click');
        }
        u.on(cancelButton,'click', function(){
            md.close();
        });
        return false
    };
    viewModel.opentask = function(id){

        var Tid =[];
        Tid.push(id)
        $.ajax({
            type : 'get',
            url : $ctx + opentaskUrl+Tid,
            cache:false,
            dataType : 'json',
            success : function(res) {
                if(res.status==1){
                    dialogmin("启用成功");
                    viewModel.datalist([]);
                    for(var i=1;i<=viewModel.number();i++){
                        viewModel.tasklist(viewModel.gid,i);
                    }
                    //viewModel.tasklist(viewModel.gid,viewModel.number());
                    viewModel.selectmutilClose()
                }else{
                    dialogmin(res.msg);
                }
            }
        });
        return false

    };
    viewModel.closetask = function(id){
        var Tid =[];
        Tid.push(id)
        $.ajax({
            type : 'get',
            url : $ctx + closetaskUrl+Tid,
            cache:false,
            dataType : 'json',
            success : function(res) {
                if(res.status==1){
                    dialogmin("停用成功");
                    viewModel.datalist([]);
                    for(var i=1;i<=viewModel.number();i++){

                        viewModel.tasklist(viewModel.gid,i);
                    }
                    //viewModel.tasklist(viewModel.gid,viewModel.number());
                    viewModel.selectmutilClose()
                }else{
                    dialogmin(res.msg);
                }
            }
        });
        return false

    };
    viewModel.del = function(id){//删除
        window.md=u.dialog({id:'deleteDialog',content:"#delete-dialog",hasCloseMenu:true});
        md.closeDiv.innerHTML="<span class='iconfont_iform icon-cancel02'></span>";
        var okButton = document.body.querySelector(".u-msg-ok");
        if(okButton["uEvent"]){
            u.off(okButton,'click');
        }
        u.on(okButton,'click', function(){
            var Tid =[];
            Tid.push(id);
            $.ajax({
                type : 'get',
                url : $ctx + deleteUrl+Tid,
                cache:false,
                dataType : 'json',
                success : function(res) {
                    if(res.status==1){

                        dialogmin("删除成功");
                        viewModel.load(viewModel.gid);
                        /* var residue=(viewModel.datalist().length-1)%pagesize;
                         if(residue==0){
                         viewModel.number(viewModel.number()-1);
                         }*/
                        viewModel.datalist([]);
                        viewModel.tasklist(viewModel.gid,1);
                        viewModel.selectmutilClose();
                        md.close();
                    }else{
                        dialogmin(res.msg);
                    }
                }
            });
        });
        var cancelButton = document.body.querySelector(".u-msg-cancel");
        if(cancelButton["uEvent"]){
            u.off(cancelButton,'click');
        }
        u.on(cancelButton,'click', function(){
            md.close();
        });
        return false;
    };
    viewModel.delgroup = function(id){//删除分组
        window.md=u.dialog({id:'deleteDialog',content:"#delete-dialog",hasCloseMenu:true});
        var okButton =document.body.querySelector(".u-msg-ok");
        md.closeDiv.innerHTML="<span class='iconfont_iform icon-cancel02'></span>";
        if(okButton["uEvent"]){
            u.off(okButton,'click');
        }
        u.on(okButton,'click', function(){
            $.ajax({
                type : 'get',
                url : $ctx + deletegidUrl+id,
                cache:false,
                dataType : 'json',
                success : function(res) {
                    if(res.status==1){
                        dialogmin("删除成功");
                        viewModel.load(viewModel.gid);
                        md.close();
                    }else{
                        dialogmin(res.msg);
                    }
                }
            });
        })
        var cancelButton = document.body.querySelector(".u-msg-cancel");
        if(cancelButton["uEvent"]){
            u.off(cancelButton,'click');
        }
        u.on(cancelButton,'click', function(){
            md.close();
        });
        return false
    };
    viewModel.tasksearch=function(){
        var taskname=$("#search").val();
        var queryData = {
            taskName:taskname,
            pageSize: pagesize,     //page size 每页显示条数
            pageCurrent: 1    //page num 当前页数
            //systemId:$systemId
        };
        $.ajax({
            type : 'POST',
            url : $ctx + searchUrl,
            cache:false,
            data:queryData,
            dataType : 'json',
            success : function(res) {
                $(".tasklist-left ul li a").removeClass("active");
                $(".allgroup .link-item").addClass("active");
                if(res.number==1){
                    viewModel.datalist(res.tasks);
                }else{
                    var allcontent = viewModel.datalist().concat(res.tasks);
                    viewModel.datalist(allcontent);
                }
                //var residue=res.tasks.length%pagesize;
                if(res.tasks.length<pagesize){
                    $(".loadmore").hide()
                }else{
                    $(".loadmore").show()
                }
                if(res.number==1&&res.tasks.length==0){
                    $(".groupNoTask").show();
                }else{
                    $(".groupNoTask").hide();
                }
                viewModel.checkboxselect();
                viewModel.number(res.number)

            }
        });
        return false
    };
    viewModel.loadmore = function(){
        viewModel.selectmutilClose();
        viewModel.tasklist(viewModel.gid,parseInt(viewModel.number())+1);
    };
    viewModel.goback=function(){
        window.parent.router.routes.sysmgr?window.parent.location.hash="#/sysmgr":window.history.back();
        return false;
    };//返回按钮，切入应用平台的管理中心
    viewModel.addGroupName = function(){
        if(viewModel.groupName()==""){
            dialogmin("请输入名称");
            return false
        }
        var gname={gName:viewModel.groupName()};
        $.ajax({
            type : 'POST',
            url : $ctx + addGroupUrl,
            cache:false,
            dataType : 'json',
            //contentType: "application/json; charset=utf-8",
            data: {
                "data":JSON.stringify(gname)
            },
            success : function(res) {
                if(res.status==1){
                    dialogmin("添加分组成功");
                    viewModel.load(viewModel.gid);
                    viewModel.closeGroup();
                    viewModel.groupName("");
                }else{
                    dialogmin(res.msg);
                }
            }
        });
    };
    viewModel.checkboxselect = function(){
        $(".list_checkbox").each(function(e){
            var _this = $(this);
            var _id =  _this.attr("data-id");
            var taskFlag=_this.attr("data-taskflag");
            if(taskFlag==2)_id='CANNOTDEL'+_id;
            _this.off().on('click',function(){

                if(_this.hasClass("ischoose")){
                    _this.removeClass("ischoose");
                    for(var i=0;i<viewModel.selectId.length;i++){
                        if(viewModel.selectId[i]===_id){
                            viewModel.selectId.splice(i,1);
                            i--;
                        }
                    }
                }else{
                    _this.addClass("ischoose");
                    viewModel.selectId.push(_id);
                }
                $(".select_number").html(parseInt(viewModel.selectId.length))

            })
        })
    };
    viewModel.load = function(gid){
        $.ajax({
            type : 'get',
            url : $ctx + getgroupUrl+"?systemId="+$systemId,
            cache:false,
            dataType : 'json',
            success : function(res) {
                if(res.status==1){
                    viewModel.data(res.groups);
                    if(!gid){
                        viewModel.tasklist(res.groups[0].gid,1);
                        $(".tasklist-left ul li a").eq(0).addClass("active");
                    }else{
                        if(!$(".tasklist-left ul li a[datagid='"+viewModel.gid+"']").html()){
                            viewModel.tasklist(res.groups[0].gid,1);
                            $(".tasklist-left ul li a").eq(0).addClass("active");
                        }else{
                            viewModel.tasklist(viewModel.gid,1);
                            $(".tasklist-left ul li a[datagid='"+viewModel.gid+"']").addClass("active");
                        }
                    }
                    viewModel.checkboxselect();
                    $(".tasklist-left ul li a").each(function(e){
                        var _this = $(this);
                        _this.click(function(){
                            viewModel.selectmutilClose();
                            $(".loadmore").show();
                            viewModel.selectId = [];
                            $(".select_number").html("0");
                            $(".tasklist-left ul li a").removeClass("active");
                            $(this).addClass("active");
                            viewModel.tasklist(res.groups[e].gid,1);
                        })
                    })
                }else{
                    dialogmin(res.msg);
                }
            }
        });

    }
    viewModel.tasklist = function(gid,pageIndex){

        var queryData = {
            gid:gid,
            pageSize: pagesize,     //page size 每页显示条数
            pageCurrent: pageIndex    //page num 当前页数
            //systemId:$systemId
        };
        $.ajax({
            type : 'get',
            url : $ctx + getlistUrl,
            cache:false,
            data:queryData,
            dataType : 'json',

            success : function(res) {
                if(viewModel.gid==gid){
                    $(".allgroup .link-item").removeClass("active");
                    if(res.number==1){
                        viewModel.datalist(res.tasks);
                    }else{
                        var allcontent = viewModel.datalist().concat(res.tasks);
                        viewModel.datalist(allcontent);
                    }
                }else{
                    viewModel.datalist(res.tasks);
                };
                // var residue=res.tasks.length%pagesize;
                if(res.tasks.length<pagesize){
                    $(".loadmore").hide()
                }else{
                    $(".loadmore").show()
                }
                if(res.number==1&&res.tasks.length==0){
                    $(".groupNoTask").show();
                }else{
                    $(".groupNoTask").hide();
                }
                viewModel.checkboxselect();
                viewModel.number(res.number)
                viewModel.gid=gid;
            }
        });
    };
    var init = function(parm) {
        $('#newTask').css('margin-left',$('.tasklist-right').offset().left-$('#newGroup').outerWidth()-40);
        viewModel.gid=parm[0];
        if(viewModel.gid=="0"){
            viewModel.gid="";
        }

        viewModel.load(viewModel.gid);
        $('#search').keydown(function(event){
            if (event.keyCode == "13") {
                viewModel.tasksearch();
            }
        })
    }

    return {
        'model' : viewModel,
        'template' : template,
        'init' : init
    };

});