define([ 'jquery',
        'text!pages/taskedit/man/modify.html','dialogmin','datetimepicker',"datetimepicker_lan",
        'utree',
        'refcommon',
        'refer',
        'refGrid',
        'refGridtree',
        'reflib',
        'refTree',
        'uiReferComp',
        'refDList'
    ],
    function($, template,dialogmin) {
        var addtaskUrl = "/task/saveTask.do";//添加任务
        var getgroupUrl = '/taskgroup/findAllTaskGroup.do';//获取分组列表
        var taskWayUrl = "/task/getTaskWay.do"//获取调用规则
        var taskuser = "/taskuser/queryUsersByPages.do"//获取用户参照表
        var edittask="/task/findTaskDetilById.do?id="//编辑任务
        var taskparmUrl="/task/getTaskWayParamByTaskWayId.do?taskWayId=";
        var refmodel="";
        var taskwayname="";
        var viewModel = {
            userlength:ko.observable(),//监测选择消息接收人列表长度
            system :  ko.observable(""),
            msgusercheck:ko.observableArray(['1']),
            resId:"",
            taskwayid:ko.observable(),
            taskwayparam:ko.observableArray([]),
            taskgroupid:ko.observable(),
            headform2: new u.DataTable({
                meta: {
                    'dataSourceId': {
                         'refmodel': '{"refUIType":"RefTree","refCode":"dispatch","rootName":"组织","refModelUrl":"http://127.0.0.1:8080/wbalone/organizationRef/","refName":"组织","refClientPageInfo":{"pageSize":100,"currPageIndex":0,"pageCount":0}}',
                        'refcfg': '{"isClearData":true,"ctx":"'+window.ctx+'","isMultiSelectedEnabled":false,"pageUrl":"uitemplate_web","isCheckListEnabled":true}'
                    }
                }
            }),
            /*任务列表*/
            taskData: new u.DataTable({
                meta:{
                    "taskcode":{
                        type:'string'
                    },
                    "taskname" : {
                        type: 'string'
                    },
                    "taskdesc" : {
                        type: 'string'
                    },
                    "gid" : {
                        type: 'string'
                    },
                    "id":{
                        type:'string'
                    },
                    "flag":{
                        type:'string'
                    }
                }
            }),
            /*用户列表*/
            groupListData: new u.DataTable({
                meta:{
                    "id":{
                        type:'string'
                    },
                    "userCode":{
                        type:'string'
                    },
                    "userName" : {
                        type: 'string'
                    },
                    "userid" : {
                        type: 'string'
                    },
                    "taskid" : {
                        type: 'string'
                    },
                    "msg" : {
                        type: 'integer'
                    },
                    "email" : {
                        type: 'integer'
                    },
                    "phone" : {
                        type: 'integer'
                    }
                }
            }),
            /*消息接收人设置*/
            receiverlist:new u.DataTable({
                meta:{
                    "userCode":{
                        type:'string'
                    },
                    "userName" : {
                        type: 'string'
                    },
                    "userid" : {
                        type: 'string'
                    },
                    "taskid" : {
                        type: 'string'
                    },
                    "msg" : {
                        type: 'integer'
                    },
                    "email" : {
                        type: 'integer'
                    },
                    "phone" : {
                        type: 'integer'
                    }
                }
            }),
            /*选择的消息接收人*/
            receiverSelectlist:new u.DataTable({
                meta:{
                    "userCode":{
                        type:'string'
                    },
                    "userName" : {
                        type: 'string'
                    },
                    "userid" : {
                        type: 'string'
                    },
                    "taskid" : {
                        type: 'string'
                    },
                    "msg" : {
                        type: 'integer'
                    },
                    "email" : {
                        type: 'integer'
                    },
                    "phone" : {
                        type: 'integer'
                    }
                }
            }),
            /*调用规则参数表*/
            ruledatalist: new u.DataTable({
                meta:{
                    "code":{
                        type:'string'
                    },
                    "name" : {
                        type: 'string'
                    },
                    "paramvalue" : {
                        type: 'string'
                    }
                }
            }),
            /*调用规则*/
            taskWaydata : new u.DataTable({
                meta:{
                    "id":{
                        type:'string'
                    },
                    "name" : {
                        type: 'string'
                    }
                }
            }),
            /*任务分组*/
            selData : new u.DataTable({
                meta:{
                    "gid":{
                        type:'string'
                    },
                    "gname" : {
                        type: 'string'
                    }
                }
            }),
            /*定时设置*/
            ruleDataTables:{
                timewayListData: new u.DataTable({
                    meta:{
                        "id":{
                            type:'string'
                        },
                        "starttime":{
                            type:'string'
                        },
                        "endtime" : {
                            type: 'string'
                        },
                        "modetime":{
                            type:'string'
                        },
                        "dura":{
                            type:'string'
                        }
                    }
                }),
                /*一天的定时模式与规则*/
                periodListData: new u.DataTable({
                    meta:{
                        "periodmode":{
                            type:'string'
                        },
                        "periodstart":{
                            type:'string'
                        },
                        "periodend" : {
                            type: 'string'
                        }
                    }
                }),
                modefrequency:ko.observable(1),//大体定时间隔
                circletype:ko.observable(),//控制大体的定时方式(天、周、月)
                weekselect:ko.observableArray([]), //控制每周复选框(1至7)
                monthselect:{
                    value:ko.observable(),
                    lastcheck:ko.observable(false)
                },//控制每月复选框()
                periodmode:ko.observable(),//周期内的定时方式（小时或分钟 ）
                duramode:ko.observable(),//一天内的定时方式(一次或周期)
                valueListData:new u.DataTable({
                    meta:{
                        "monthvalue":{
                            type:'string'
                        },
                        "onceduravalue":{
                            type:'string'
                        },
                        "cirminduravalue":{
                            type: 'string'
                        },
                        "cirhourduravalue":{
                            type: 'string'
                        }
                    }
                })
            },

            /*选择的定时方式*/

            ruleSelectDataTables:{
                timewayListData: new u.DataTable({
                    meta:{
                        "id":{
                            type:'string'
                        },
                        "starttime":{
                            type:'string'
                        },
                        "endtime" : {
                            type: 'string'
                        },
                        "modetime":{
                            type:'string'
                        },
                        "dura":{
                            type:'string'
                        }
                    }
                }),
                /*一天的定时模式与规则*/
                periodListData: new u.DataTable({
                    meta:{
                        "periodmode":{
                            type:'string'
                        },
                        "periodstart":{
                            type:'string'
                        },
                        "periodend" : {
                            type: 'string'
                        }
                    }
                }),
                modefrequency:ko.observable(1),//大体定时间隔
                circletype:ko.observable(),//控制大体的定时方式(天、周、月)
                weekselect:ko.observableArray([]), //控制每周复选框(1至7)
                monthselect:{
                    value:ko.observable(),
                    lastcheck:ko.observable(false)
                },//控制每月复选框()
                weekdays:ko.observableArray([]),//控制显示于页面的天数(星期一至星期日)
                periodmode:ko.observable(),//周期内的定时方式（小时或分钟 ）
                duramode:ko.observable(),//一天内的定时方式(一次或周期)
                valueListData:new u.DataTable({
                    meta:{
                        "monthvalue":{
                            type:'string'
                        },
                        "onceduravalue":{
                            type:'string'
                        },
                        "cirminduravalue":{
                            type: 'string'
                        },
                        "cirhourduravalue":{
                            type: 'string'
                        }
                    }
                })
            }
        };
        function ref(refCode){
            if (!refCode) return alert("缺少参数~~");
            $.ajax({
                type: "get",
                url: window.$ctx+'/iref_ctr/refInfo/',
                data: {
                    refCode: refCode || ""
                },
                traditional: true,
                async: false,
                dataType: "json",
                success: function (pRefmodel) {
                    refmodel = JSON.stringify(pRefmodel);
                    viewModel.headform2.setMeta('dataSourceId', 'refmodel', refmodel);
                }
            });
        }
        ref("dispatch");
        /* ko.bindingHandlers.update={
         update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
         var value = valueAccessor();
         var valueUnwrapped = ko.unwrap(value);
         if (valueUnwrapped == true)
         alert(1);
         // This will be called once when the binding is first applied to an element,
         // and again whenever any observables/computeds that are accessed change
         // Update the DOM element based on the supplied values here.
         }
         };*/
        Array.prototype.unique = function(){
            var indexs=[];
            var json = {};
            for(var i = 0; i < this.length; i++){
                if(!json[this[i].userid]&&this[i].userid){
                    json[this[i].userid] = 1;
                }else{
                    indexs.push(i);
                }
            }
            return indexs;
        };
        viewModel.goback = function(){
            var id=viewModel.taskgroupid();
            window.router.setRoute('/task/man/list/'+id);
            //var timestamp=new Date().getTime();
            //window.router.setRoute('/tmp/detail/detail/'+viewModel.resId+'/'+timestamp);
            return false;
        };
        /*
         * *定时规则
         *
         *
         * */
        viewModel.DateToUnix=function(string) {
            var f = string.split(' ', 2);
            var d = (f[0] ? f[0] : '').split('-', 3);
            var t = (f[1] ? f[1] : '').split(':', 3);
            var time=(new Date(
                    parseInt(d[0], 10) || null,
                    (parseInt(d[1], 10) || 1) - 1,
                    parseInt(d[2], 10) || null,
                    parseInt(t[0], 10) || null,
                    parseInt(t[1], 10) || null,
                    parseInt(t[2], 10) || null
                )).getTime() / 1000;
            return time;
        };
        /*设置定时*/
        viewModel.settimerule=function(){
            $('.task-timingrule_con').css('display','block');
            return false
        };
        /*取消设置*/
        viewModel.canceltimerule=function(){
            $('.task-timingrule_con').css('display','none');
            return false
        };
        /*定时规则保存*/
        viewModel.rulesubmit=function(){
            /*定时规则数据传递*/
            var seldata1=viewModel.ruleDataTables.timewayListData.getSimpleData();
            var seldata2=viewModel.ruleDataTables.periodListData.getSimpleData();
            var seldata5=viewModel.ruleDataTables.valueListData.getSimpleData();
            var seldata3=viewModel.ruleDataTables.circletype();
            var seldata4=viewModel.ruleDataTables.weekselect();
            var seldata6=viewModel.ruleDataTables.monthselect.lastcheck();
            var seldata7=viewModel.ruleDataTables.duramode();
            var seldata8=viewModel.ruleDataTables.periodmode();
            /*验证表单数据*/
            var timewayendtime=viewModel.ruleDataTables.timewayListData.getValue('endtime');
            var timewaystarttime=viewModel.ruleDataTables.timewayListData.getValue('starttime');
            var onceduravalue=viewModel.ruleDataTables.valueListData.getValue("onceduravalue");
            var cirhourduravalue=viewModel.ruleDataTables.valueListData.getValue("cirhourduravalue");
            var cirminduravalue=viewModel.ruleDataTables.valueListData.getValue("cirminduravalue");
            var monthvalue=viewModel.ruleDataTables.valueListData.getValue("monthvalue");
            var starttime=viewModel.ruleDataTables.periodListData.getValue('periodstart');
            var endtime=viewModel.ruleDataTables.periodListData.getValue('periodend');
            var weeksel=viewModel.ruleDataTables.weekselect();
            var Reginput = /^(0\d{1}|1\d{1}|2[0-3]):([0-5]\d{1})$/;
            if(timewayendtime==""||timewayendtime==undefined){
                dialogmin('请选择结束时间');
                return false
            }
            if(seldata3=="1"){
                if(weeksel==undefined||weeksel==""||weeksel==[]){
                    dialogmin('请选择每周的某些天');
                    return false
                }
            }else if(seldata3=="2"){
                if(monthvalue==undefined||monthvalue==""||parseInt(monthvalue)<=0||parseInt(monthvalue)>=32){
                    dialogmin('请输入每月正确的某一天');
                    return false
                }
            }
            if(seldata7=="0"){
                if(onceduravalue==""||!Reginput.test(onceduravalue)){
                    dialogmin("请输入正确格式的发生一次的时间");
                    return false
                }
            }else{
                if(seldata8=="0"){
                    if(cirhourduravalue==undefined||cirhourduravalue==""||cirhourduravalue<=0){
                        dialogmin('请输入正确的间隔小时');
                        return false
                    }
                }else{
                    if(cirminduravalue==undefined||cirminduravalue==""||cirminduravalue<=0){
                        dialogmin('请输入正确的间隔分钟');
                        return false
                    }
                }
                if(endtime==""||!Reginput.test(endtime)){
                    dialogmin("请输入正确格式的终止时间");
                    return false
                }
                if(starttime==""||!Reginput.test(starttime)){
                    dialogmin("请输入正确格式的起始时间");
                    return false
                }
                var starttimearray=starttime.split(":");
                var starttimehour=parseInt(starttimearray[0]);
                var starttimemin=parseInt(starttimearray[1]);
                var endtimearray=endtime.split(":");
                var endtimehour=parseInt(endtimearray[0]);
                var endtimemin=parseInt(endtimearray[1]);
                if(endtimehour<starttimehour||(endtimehour==starttimehour&&endtimemin<=starttimemin)){
                    dialogmin("周期起始时间应该早于终止时间");
                    return false
                }
            }
            var endtimeunix=viewModel.DateToUnix(timewayendtime);
            var starttimeunix=viewModel.DateToUnix(timewaystarttime);
            if(starttimeunix>=endtimeunix){
                dialogmin("开始时间应该早于结束时间");
                return false
            }
            /*将定时规则表单数据传递到主页面*/
            viewModel.ruleSelectDataTables.timewayListData.setSimpleData(seldata1);
            viewModel.ruleSelectDataTables.periodListData.setSimpleData(seldata2);
            viewModel.ruleSelectDataTables.valueListData.setSimpleData(seldata5);
            viewModel.ruleSelectDataTables.circletype(seldata3);
            viewModel.ruleSelectDataTables.weekselect(seldata4);
            viewModel.ruleSelectDataTables.monthselect.lastcheck(seldata6);
            viewModel.ruleSelectDataTables.duramode(seldata7);
            viewModel.ruleSelectDataTables.periodmode(seldata8);
            if(viewModel.ruleSelectDataTables.circletype()==1){
                var weekselect=[];
                var days=[
                    {day:"星期一"},
                    {day:"星期二"},
                    {day:"星期三"},
                    {day:"星期四"},
                    {day:"星期五"},
                    {day:"星期六"},
                    {day:"星期日"}
                ];
                weekselect=viewModel.ruleSelectDataTables.weekselect();
                weekselect.sort(function(a,b){
                    return a-b;
                });
                var weekdays=[];
                for(var i=0;i<weekselect.length;i++){
                    var index=weekselect[i]-1;
                    weekdays.push(days[index]);
                }
                viewModel.ruleSelectDataTables.weekdays(weekdays);
            }




            $('.task-timingrule_con').css('display','none');
        };
       /*
       * *
       * 定时规则表单计算功能
       * */
        function minminusfun(value){
            var step=5;
            var Reginput = /^(0\d{1}|1\d{1}|2[0-3]):([0-5]\d{1})$/;
            if(!Reginput.test(value)){
                dialogmin("请输入正确的时间格式");
                return value;
            }
            var timearray=value.split(":");
            var hour=parseInt(timearray[0]);
            var min=parseInt(timearray[1]);
            min=min-step;
            if(min<0){min=min+60;hour=hour-1;}
            if(hour<0){hour="23";}
            if(min<10){min="0"+min;}
            if(hour>=0&&hour<10){hour="0"+hour;}
            var num =hour+":"+min;
            return num;
        }
        function minaddfun(value){
            var step=5;
            var Reginput = /^(0\d{1}|1\d{1}|2[0-3]):([0-5]\d{1})$/;
            if(!Reginput.test(value)){
                dialogmin("请输入正确的时间格式");
                return value;
            }
            var timearray=value.split(":");
            var hour=parseInt(timearray[0]);
            var min=parseInt(timearray[1]);
            min=min+step;
            if(min>=60){min=min-60;hour=hour+1;}
            if(hour>=24){hour=0;}
            if(min<10){min="0"+min;}
            if(hour<10&&hour>=0){hour="0"+hour;}
            var num =hour+":"+min;
            return num;

        }
        viewModel.timeevents={
            minduravalue:function(){
                if(viewModel.ruleDataTables.periodmode()=="0"){
                    var num =parseInt($("#hourduravalue").val());
                    if(num>1){
                        num=num-1;
                        viewModel.ruleDataTables.valueListData.setValue("cirhourduravalue",num);
                    }
                }
                else{
                    var num =parseInt($("#minduravalue").val());
                    if(num>5){
                        num=num-5;
                        viewModel.ruleDataTables.valueListData.setValue("cirminduravalue",num);
                    }
                }
            },
            addduravalue:function(){
                if(viewModel.ruleDataTables.periodmode()=="0"){
                    var num =parseInt($("#hourduravalue").val());
                    num=num+1;
                    viewModel.ruleDataTables.valueListData.setValue("cirhourduravalue",num);
                }
                else{
                    var num =parseInt($("#minduravalue").val());
                    num=num+5;
                    viewModel.ruleDataTables.valueListData.setValue("cirminduravalue",num);
                }
            },
            minmonthselect:function(){
                var num =parseInt($(".monthselect").val());
                if(num>1){
                    num=num-1;
                    viewModel.ruleDataTables.valueListData.setValue("monthvalue",num);
                }
            },
            addmonthselect:function(){
                var num =parseInt($(".monthselect").val());
                num=num+1;
                viewModel.ruleDataTables.valueListData.setValue("monthvalue",num);
            },
            minperiodstart:function(){
                var time_input_val=viewModel.ruleDataTables.periodListData.getValue('periodstart');
                var num=minminusfun(time_input_val);
                viewModel.ruleDataTables.periodListData.setValue('periodstart',num);
            },
            minperiodend:function(){
                var time_input_val=viewModel.ruleDataTables.periodListData.getValue('periodend');
                var num=minminusfun(time_input_val);
                viewModel.ruleDataTables.periodListData.setValue('periodend',num);
            },
            addperiodstart:function(){
                var time_input_val= viewModel.ruleDataTables.periodListData.getValue('periodstart');
                var num=minaddfun(time_input_val);
                viewModel.ruleDataTables.periodListData.setValue('periodstart',num);
            },
            addperiodend:function(){
                var time_input_val= viewModel.ruleDataTables.periodListData.getValue('periodend');
                var num=minaddfun(time_input_val);
                viewModel.ruleDataTables.periodListData.setValue('periodend',num);
            },
            addonceduravalue:function(){
                var time_input_val= viewModel.ruleDataTables.valueListData.getValue('onceduravalue');
                var num=minaddfun(time_input_val);
                viewModel.ruleDataTables.valueListData.setValue('onceduravalue',num);
            },
            minonceduravalue:function(){
                var time_input_val= viewModel.ruleDataTables.valueListData.getValue('onceduravalue');
                var num=minminusfun(time_input_val);
                viewModel.ruleDataTables.valueListData.setValue('onceduravalue',num);
            }
        };

        /*
        * *
        * 定时类型控制
        * */
        viewModel.timeDay= function(){
            $(".circletype").click(function(){
                var val=$(this).val();
                viewModel.ruleDataTables.circletype(val);
            });
            $(".durmode").click(function(){
                var val=$(this).val();
                viewModel.ruleDataTables.duramode(val);
            });
            $(".peiriodselect").click(function(){
                var val=$(this).val();
                viewModel.ruleDataTables.periodmode(val);
            });
            $("#monthcheckbox").click(function(){
                if($(this).prop("checked")==true){
                    viewModel.ruleDataTables.monthselect.lastcheck(1);
                }else{
                    viewModel.ruleDataTables.monthselect.lastcheck(0);
                }
            });
        };
        /*
        * *
        *消息接收规则
        * */
/*        viewModel.complexListModel = function(items) {
            var self = this;
            debugger;
            self.receiverlist = [];
            ko.utils.arrayForEach(items, function (item) {
                var i = {
                    "id":ko.observable(item.id),
                    "name":ko.observable(item.name),
                    "code":ko.observable(item.code),
                    "msgcheck":ko.observable(item.msgcheck),
                    "mailcheck":ko.observable(item.mailcheck),
                    "phonecheck":ko.observable(item.phonecheck)
                };
                self.receiverlist.push(i);
            });
            self.receiverlist = ko.observableArray(self.receiverlist);
        };
        viewModel.complexListModel(arrays);*///数组内部元素进行属性监控

        /*增加消息接收人*/
        viewModel.addmsgrow=function(){
            viewModel.receiverlist.createEmptyRow();
            var chknum = $(".user_checkbox").size();//选项总个数
            var chk = 0;
            $(".user_checkbox").each(function () {
                if($(this).prop("checked")==true){
                    chk++;
                }
            });
            if(chknum==chk){//全选
                $("#all_checkbox").prop("checked",true);
            }else{//不全选
                $("#all_checkbox").prop("checked",false);
            }
        };
        /*批量删除消息接收人*/
        var delindexs=[];
        viewModel.delmsgrow=function(){
            delindexs=[];
            $(".user_checkbox").each(function () {
                if($(this).prop("checked")==true){
                    delindexs.push(parseInt($(this).val()));
                }
            });
            viewModel.receiverlist.removeRows(delindexs);

        };
        /*设置消息接收人*/
        viewModel.setmsg=function(){
            $('.task-receiverset_con').css('display','block');
            return false
        };
        /*取消设置消息接收人*/
        viewModel.cancelmsg=function(){
            $('.task-receiverset_con').css('display','none');
            return false
        };
        /*保存消息接收人*/
        viewModel.msgsubmit=function(){
            /*var receiverlist=[];
            for(var i=0;i<viewModel.receiverlist().length;i++){
                receiverlist[i]={};
                receiverlist[i].name=viewModel.receiverlist()[i].name();
                receiverlist[i].code=viewModel.receiverlist()[i].code();
                receiverlist[i].msgcheck=viewModel.receiverlist()[i].msgcheck();
                receiverlist[i].mailcheck=viewModel.receiverlist()[i].mailcheck();
                receiverlist[i].phonecheck=viewModel.receiverlist()[i].phonecheck();
            }
            console.log(receiverlist);*///将ko追踪数组改成普通json数组
            var userlist=viewModel.receiverlist.getSimpleData();
            var userselect=[];
            for(var i=0; i<userlist.length;i++){
                if((userlist[i].userCode!=undefined||userlist[i].userCode!="")&&(userlist[i].msg==true||userlist[i].email==true||userlist[i].phone==true)){
                    userselect.push(userlist[i]);
                }
            }
            viewModel.receiverSelectlist.setSimpleData(userselect);
            var receiverlength= viewModel.receiverSelectlist.rows._latestValue.length;
            viewModel.userlength(receiverlength);
            $('.task-receiverset_con').css('display','none');
        };
        /*
        * *
        * 保存任务
        * */
        viewModel.submit = function() {
            /*获取需要提交的表单数据*/
            var modevaule;
            var duravalue
           if(viewModel.ruleSelectDataTables.circletype()=="1"){
               modevaule=viewModel.ruleSelectDataTables.weekselect();
           }else if(viewModel.ruleSelectDataTables.circletype()=="2"){
               modevaule=[];
               modevaule.push(viewModel.ruleSelectDataTables.valueListData.getValue("monthvalue"));
               modevaule.push(viewModel.ruleSelectDataTables.monthselect.lastcheck());
           }else{
               modevaule=[];
           }
            if (viewModel.ruleSelectDataTables.duramode()=="0"){
                duravalue=viewModel.ruleSelectDataTables.valueListData.getValue("onceduravalue")
            }else {
                if(viewModel.ruleSelectDataTables.periodmode()=="0"){
                    duravalue=viewModel.ruleSelectDataTables.valueListData.getValue("cirhourduravalue")
                }else{
                    duravalue=viewModel.ruleSelectDataTables.valueListData.getValue("cirminduravalue")
                }
            }
            var taskcode=viewModel.taskData.getValue('taskcode');
            var taskname=viewModel.taskData.getValue('taskname');
            var taskdesc=viewModel.taskData.getValue('taskdesc');
            var gid=$(".task_group").val();
            var taskWaydataid=viewModel.taskwayid();
            var array=viewModel.receiverSelectlist.getSimpleData();
            for(var i=0;i<array.length;i++){
                if(array[i].msg==true){
                    array[i].msg=1;
                }else{
                    array[i].msg=0;
                }
                if(array[i].phone==true){
                    array[i].phone=1;
                }else{
                    array[i].phone=0;
                }
                if(array[i].email==true){
                    array[i].email=1;
                }else{
                    array[i].email=0;
                }
            }
            viewModel.receiverSelectlist.setSimpleData(array);
            var queryData ={
                "task":{
                    "taskcode": taskcode,
                    "taskname": taskname,
                    "taskdesc": taskdesc,
                    "id": viewModel.taskData.getValue('id'),
                    "gid": gid,
                    "flag":viewModel.taskData.getValue('flag'),
                    "taskmsg":viewModel.receiverSelectlist.getSimpleData(),
                    "taskway":{
                        "id":taskWaydataid,
                        "taskParams":viewModel.ruledatalist.getSimpleData()},
                    "timeway":{
                        "id":viewModel.ruleSelectDataTables.timewayListData.getValue('id'),
                        "starttime":viewModel.ruleSelectDataTables.timewayListData.getValue('starttime'),
                        "endtime":viewModel.ruleSelectDataTables.timewayListData.getValue('endtime'),
                        "modetime":{
                            "modetype":viewModel.ruleSelectDataTables.circletype(),
                            "modefrequency":"1",
                            "modevaule":modevaule
                        },
                        "dura":{
                            "duramode": viewModel.ruleSelectDataTables.duramode(),
                            "duravalue":duravalue,
                            "period":{
                                "periodmode":viewModel.ruleSelectDataTables.periodmode(),
                                "periodstart":viewModel.ruleSelectDataTables.periodListData.getValue('periodstart'),
                                "periodend":viewModel.ruleSelectDataTables.periodListData.getValue('periodend')
                            }
                        }}
                }
            };
            /*数据校验*/
            if(taskcode==undefined||taskcode==""){
                dialogmin('您的编码还没填呢~');
                return false
            }
            if(taskname==undefined||taskname==""){
                dialogmin('您的名称还没填呢~');
                return false
            }
            if($(".taskref .ac_input").val()==""||$(".taskref .ac_input").val()==undefined){
                dialogmin('您的调用规则还没选呢~');
                return false
            }
            if($("#timerulesetspan").css("display")=="block"){
                dialogmin("请设置定时规则");
                return false
            }
            $.ajax({
                type : 'POST',
                dataType : 'json',
                async : false,
                data: {
                    "data":JSON.stringify(queryData)
                },
                url : $ctx + addtaskUrl,
                success : function(data) {
                    if (data.status==1){
                        dialogmin("编辑成功");
                        viewModel.goback();
                    }else{
                        dialogmin(data.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    dialogmin("调用服务报错!!");
                }
            });
        };
        /*
         * *
         * 页面初始加载
         * */
        viewModel.load = function(){
            /*获取任务分组*/
            $.ajax({
                type : 'post',
                dataType : 'json',
                async : false,
                url : $ctx + edittask+viewModel.resId,
                success : function(data) {
                    if (data.status==1){
                       var taskdata=data;
                        viewModel.taskData.setSimpleData(taskdata.task);
                        viewModel.taskwayid(taskdata.task.taskway.id);
                        taskwayname=taskdata.task.taskwayname;
                        viewModel.ruledatalist.setSimpleData(taskdata.task.taskway.taskParams);
                        viewModel.taskgroupid(taskdata.task.gid);
                        /*消息接收人数据解析*/
                        viewModel.receiverlist.setSimpleData(taskdata.task.taskmsg);
                        viewModel.receiverSelectlist.setSimpleData(taskdata.task.taskmsg);
                        var receiverlength= viewModel.receiverSelectlist.rows._latestValue.length;
                        viewModel.userlength(receiverlength);
                        delindexs=[];
                        /*定时规则数据解析*/
                        viewModel.ruleDataTables.timewayListData.setSimpleData(taskdata.task.timeway);
                        viewModel.ruleDataTables.periodListData.setSimpleData(taskdata.task.timeway.dura.period);
                        viewModel.ruleDataTables.valueListData.createEmptyRow();
                        viewModel.ruleSelectDataTables.valueListData.createEmptyRow();
                        viewModel.ruleDataTables.circletype(taskdata.task.timeway.modetime.modetype);
                        if(viewModel.ruleDataTables.circletype()==1){
                            viewModel.ruleDataTables.weekselect(taskdata.task.timeway.modetime.modevaule);
                            viewModel.ruleDataTables.valueListData.setValue("monthvalue",1);
                            viewModel.ruleDataTables.monthselect.lastcheck(false);
                        }else if(viewModel.ruleDataTables.circletype()==2){
                            viewModel.ruleDataTables.valueListData.setValue("monthvalue",taskdata.task.timeway.modetime.modevaule[0]);
                            viewModel.ruleDataTables.monthselect.lastcheck(taskdata.task.timeway.modetime.modevaule[1]);
                            viewModel.ruleDataTables.weekselect([]);
                        }
                        viewModel.ruleDataTables.duramode(taskdata.task.timeway.dura.duramode);
                        viewModel.ruleDataTables.periodmode(taskdata.task.timeway.dura.period.periodmode);
                        if(viewModel.ruleDataTables.duramode()==0){
                            viewModel.ruleDataTables.valueListData.setValue("onceduravalue",taskdata.task.timeway.dura.duravalue);
                            viewModel.ruleDataTables.valueListData.setValue("cirhourduravalue",1);
                            viewModel.ruleDataTables.valueListData.setValue("cirminduravalue",5);
                        }else{
                            if( viewModel.ruleDataTables.periodmode()==0){
                                viewModel.ruleDataTables.valueListData.setValue("cirhourduravalue",taskdata.task.timeway.dura.duravalue);
                                viewModel.ruleDataTables.valueListData.setValue("cirminduravalue",5);
                            }else{
                                viewModel.ruleDataTables.valueListData.setValue("cirhourduravalue",1);
                                viewModel.ruleDataTables.valueListData.setValue("cirminduravalue",taskdata.task.timeway.dura.duravalue);
                            }
                            viewModel.ruleDataTables.valueListData.setValue("onceduravalue","08:00");
                        }

                        viewModel.ruleSelectDataTables.timewayListData.setSimpleData(taskdata.task.timeway);
                        viewModel.ruleSelectDataTables.periodListData.setSimpleData(taskdata.task.timeway.dura.period);
                        viewModel.ruleSelectDataTables.circletype(taskdata.task.timeway.modetime.modetype);
                        if(viewModel.ruleSelectDataTables.circletype()==1){
                            viewModel.ruleSelectDataTables.weekselect(taskdata.task.timeway.modetime.modevaule);
                            viewModel.ruleSelectDataTables.valueListData.setValue("monthvalue",1);
                            viewModel.ruleSelectDataTables.monthselect.lastcheck(false);
                            var weekselect=[];
                            var days=[ {day:"星期一"},
                                {day:"星期二"},
                                {day:"星期三"},
                                {day:"星期四"},
                                {day:"星期五"},
                                {day:"星期六"},
                                {day:"星期日"}];
                            weekselect=viewModel.ruleSelectDataTables.weekselect();

                            weekselect.sort(function(a,b){
                                    return a-b;
                                });
                            console.log(weekselect)
                            var weekdays=[];
                            for(var i=0;i<weekselect.length;i++){
                                var index=weekselect[i]-1;
                                weekdays.push(days[index]);
                            }
                            viewModel.ruleSelectDataTables.weekdays(weekdays);
                        }else if(viewModel.ruleSelectDataTables.circletype()==2){
                            viewModel.ruleSelectDataTables.valueListData.setValue("monthvalue",taskdata.task.timeway.modetime.modevaule[0]);
                            viewModel.ruleSelectDataTables.monthselect.lastcheck(taskdata.task.timeway.modetime.modevaule[1]);
                            viewModel.ruleSelectDataTables.weekselect([]);
                        }
                        viewModel.ruleSelectDataTables.duramode(taskdata.task.timeway.dura.duramode);
                        viewModel.ruleSelectDataTables.periodmode(taskdata.task.timeway.dura.period.periodmode);
                        if(viewModel.ruleSelectDataTables.duramode()==0){
                            viewModel.ruleSelectDataTables.valueListData.setValue("onceduravalue",taskdata.task.timeway.dura.duravalue);
                            viewModel.ruleSelectDataTables.valueListData.setValue("cirhourduravalue",1);
                            viewModel.ruleSelectDataTables.valueListData.setValue("cirminduravalue",5);
                        }else{
                            if( viewModel.ruleSelectDataTables.periodmode()==0){
                                viewModel.ruleSelectDataTables.valueListData.setValue("cirhourduravalue",taskdata.task.timeway.dura.duravalue);
                                viewModel.ruleSelectDataTables.valueListData.setValue("cirminduravalue",5);
                            }else{
                                viewModel.ruleSelectDataTables.valueListData.setValue("cirhourduravalue",1);
                                viewModel.ruleSelectDataTables.valueListData.setValue("cirminduravalue",taskdata.task.timeway.dura.duravalue);
                            }
                            viewModel.ruleDataTables.valueListData.setValue("onceduravalue","08:00");
                        }
                        var starttime=$(".form_datetimestart").val();
                        $(".form_datetimestart").datetimepicker({format: 'yyyy-mm-dd hh:ii', autoclose: true,language: 'zh-CN'});
                        $(".form_datetimeend").datetimepicker({format: 'yyyy-mm-dd hh:ii', autoclose: true,language: 'zh-CN',startDate:starttime});
                        var pre='<i class="uiconfont uicon-arrowleft"></i>';
                        var next='<i class="uiconfont uicon-arrowright"></i>';
                        $(".table-condensed .prev").html(pre);
                        $(".table-condensed .next").html(next);
                        /*  if(viewModel.receiverlist.getSimpleData().length==0){
                         $("#setreceiver").css("display","block");
                         $("#showreceiver").css("display","none");
                         }else*/

                    }else{
                        dialogmin(data.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    dialogmin("调用服务报错!!");
                }
            });
            $.ajax({
                type : 'post',
                dataType : 'json',
                async : false,
                url : $ctx + getgroupUrl,
                success : function(data) {
                    if (data.status==1){
                        var taskgroupid=viewModel.taskgroupid();
                        viewModel.selData.setSimpleData(data.groups);
                        var all_options=document.getElementById("task_group").options;
                        for(var i=0;i<data.groups.length;i++){
                            if(taskgroupid==data.groups[i].gid){
                                all_options[i].selected=true;
                            }
                        }
                    }else{
                        dialogmin(data.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    dialogmin("调用服务报错!!");
                }
            });
            $.ajax({
                type : 'post',
                dataType : 'json',
                async : false,
                url : $ctx + taskWayUrl,
                success : function(data) {
                    if (data.status==1){
                        var taskwaydata=data.taskway;
                        viewModel.taskWaydata.setSimpleData(taskwaydata);
                        var taskid=viewModel.taskwayid();
                        /*var taskwaypara=viewModel.taskwayparam();
                        viewModel.taskWaydata.setSimpleData(taskwaydata);
                        var all_options=document.getElementById("task_rule").options;
                        var seleitem=0;
                        for(var i=0;i<taskwaydata.length;i++){
                            if(taskid==taskwaydata[i].id){
                                taskwaydata[i].taskParams=taskwaypara;
                                viewModel.ruledatalist.setSimpleData(taskwaypara);
                                seleitem=i;
                            }
                        }

                        all_options[seleitem].selected=true;
                        $("#task_rule").change(function(){
                            var value=$("#task_rule").children('option:selected').val();
                            var taskdata= viewModel.taskWaydata.getSimpleData();
                            for(var i=0;i<taskdata.length;i++){
                                if(taskdata[i].id==value){
                                    viewModel.ruledatalist.setSimpleData(taskwaydata[i].taskParams)
                                }
                            }
                        });*/

                    }else{
                        dialogmin(data.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    dialogmin("调用服务报错!!");
                }
            });
            $(".modal-body").on("click","#all_checkbox",function () {
                if($("#all_checkbox").prop("checked")==true){
                    $(".user_checkbox").prop("checked",true);
                }else{
                    $(".user_checkbox").prop("checked",false);
                }

            });
            $(".modal-body").on("click",".user_checkbox", function(){
                    var chknum = $(".user_checkbox").size();//选项总个数
                    var chk = 0;
                    $(".user_checkbox").each(function () {
                        if($(this).prop("checked")==true){
                            chk++;
                        }
                    });
                    if(chknum==chk){//全选
                        $("#all_checkbox").prop("checked",true);
                    }else{//不全选
                        $("#all_checkbox").prop("checked",false);
                    }
                });
            $(".modal-body").on("click","#msgctn_checkbox",function () {
                var userlist=viewModel.receiverlist.getSimpleData();
                if($("#msgctn_checkbox").prop("checked")==true){
                    $(".msgctn_checkbox").prop("checked",true);
                    for(var i=0; i<userlist.length;i++){
                        userlist[i].msg=true;
                    }
                }else{
                    $(".msgctn_checkbox").prop("checked",false);
                    for(var i=0; i<userlist.length;i++){
                        userlist[i].msg=false;
                    }
                }
                viewModel.receiverlist.setSimpleData(userlist);
            });
            $(".modal-body").on("click",".msgctn_checkbox", function(){
                    var chknum = $(".msgctn_checkbox").size();//选项总个数
                    var chk = 0;
                    $(".msgctn_checkbox").each(function () {
                        if($(this).prop("checked")==true){
                            chk++;
                        }
                    });
                    if(chknum==chk){//全选
                        $("#msgctn_checkbox").prop("checked",true);
                    }else{//不全选
                        $("#msgctn_checkbox").prop("checked",false);
                    }
                });
            $(".modal-body").on("click","#mail_checkbox",function () {
                var userlist=viewModel.receiverlist.getSimpleData();
                if($("#mail_checkbox").prop("checked")==true){
                    $(".mail_checkbox").prop("checked",true);
                    for(var i=0; i<userlist.length;i++){
                        userlist[i].email=true;
                    }
                }else{
                    $(".mail_checkbox").prop("checked",false);
                    for(var i=0; i<userlist.length;i++){
                        userlist[i].email=false;
                    }
                }
                viewModel.receiverlist.setSimpleData(userlist);
            });
            $(".modal-body").on("click",".mail_checkbox", function(){
                    var chknum = $(".mail_checkbox").size();//选项总个数
                    var chk = 0;
                    $(".mail_checkbox").each(function () {
                        if($(this).prop("checked")==true){
                            chk++;
                        }
                    });
                    if(chknum==chk){//全选
                        $("#mail_checkbox").prop("checked",true);
                    }else{//不全选
                        $("#mail_checkbox").prop("checked",false);
                    }
                });
            $(".modal-body").on("click","#phonemsg_checkbox",function () {
                var userlist=viewModel.receiverlist.getSimpleData();
                if($("#phonemsg_checkbox").prop("checked")==true){
                    $(".phonemsg_checkbox").prop("checked",true);
                    for(var i=0; i<userlist.length;i++){
                        userlist[i].phone=true;
                    }
                }else{
                    $(".phonemsg_checkbox").prop("checked",false);
                    for(var i=0; i<userlist.length;i++){
                        userlist[i].phone=false;
                    }
                }
                viewModel.receiverlist.setSimpleData(userlist);
            });
            $(".modal-body").on("click",".phonemsg_checkbox", function(){
                    var chknum = $(".phonemsg_checkbox").size();//选项总个数
                    var chk = 0;
                    $(".phonemsg_checkbox").each(function () {
                        if($(this).prop("checked")==true){
                            chk++;
                        }
                    });
                    if(chknum==chk){//全选
                        $("#phonemsg_checkbox").prop("checked",true);
                    }else{//不全选
                        $("#phonemsg_checkbox").prop("checked",false);
                    }
                });
            //viewModel.data().cronexpression1 = 1;

        };


        /*用户参照*/
        viewModel.setuser=function(index){
            //用户编码信息查询
            viewModel.receiverlist.setRowFocus(index);
            var userquerydata={};
            userquerydata.pageNum=1;//第几页数据
            userquerydata.pageSize=5;
            viewModel.pagination.ele.options.pageSize=5;
            userAjaxFunction(userquerydata);
            $('#addModal').css("display","block");
            return false
        };
        viewModel.canceluser=function(){
            $('#addModal').css("display","none");
            return false
        };
        //参照确定按钮
        viewModel.confirmuser=function(){
            var reArray=viewModel.receiverlist.getSimpleData();
            var groupArray=viewModel.groupListData.getSimpleData({type:'select'});
            var concatArray=reArray.concat(groupArray);
            var indexs=concatArray.unique();
            viewModel.receiverlist.setSimpleData(concatArray);
            viewModel.receiverlist.removeRows(indexs);
            $('#addModal').css( "display","none");
        }
        viewModel.afterAdd=function(element, index, data) {
            if (element.nodeType === 1) {
                u.compMgr.updateComp(element);
            }
        };
        //用户参照对话框条件检索
        viewModel.userConditionSearchFunc=function(){
            var srchval=$(".user-search-input").val();
            var userquerydata={
                pageNum:viewModel.pagination.ele.options.currentPage,
                pageSize:viewModel.pagination.ele.options.pageSize,
                search:srchval
            };
            userAjaxFunction(userquerydata);
        };
        //分页查询
        var userAjaxFunction = function(userquerydata){
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: $ctx+taskuser,
                async: false,
                data: {
                    "data":JSON.stringify(userquerydata)
                },
                success: function (res) {
                    if(res.status==1)
                    {
                        var data=res.data;
                        var totalcount=data.totalElements;
                        var pageSize=viewModel.pagination.ele.options.pageSize;
                        var pageNum=viewModel.pagination.ele.options.currentPage;
                        var totalpage=Math.ceil(totalcount/pageSize);
                        /*更新分页*/
                        viewModel.pagination.ele.update({
                            totalPages:totalpage,
                            pageSize:pageSize,
                            currentPage:pageNum,
                            totalCount:totalcount
                        });
                        for(var i=0;i<data.userList.length;i++){
                            data.userList[i].userid=data.userList[i].id;
                        }//消息的用户id字段，转换任务的用户userid字段
                        viewModel.groupListData.setSimpleData(data.userList);
                        viewModel.groupListData.setRowUnSelect(0);
                    }
                }
            });
        };
        /*分页控件*/
        viewModel.pagination={
            element:null,
            init:function(){
                var element = $('#pagination')[0];
                this.ele= new u.pagination({el:element,jumppage:true});
                this.ele.update({
                    pageSize:viewModel.pagination.ele.options.pageSize,
                    currentPage:1
                });//默认设置当前页码及pageSize
                this.ele.options.pageList=[5,10,15];//显示条数选择，默认只能选
                this.ele.on('pageChange', function (currentPage) {
                    var srchval=$(".user-search-input").val();
                    var userquerydata={
                        pageNum:currentPage+1,
                        pageSize:viewModel.pagination.ele.options.pageSize,
                        search:srchval
                    };
                    userAjaxFunction(userquerydata);
                });
                this.ele.on('sizeChange', function (siz) {
                    var srchval=$(".user-search-input").val();
                    var userquerydata={
                        pageNum:viewModel.pagination.ele.options.currentPage,
                        pageSize:siz,
                        search:srchval
                    };
                    viewModel.pagination.ele.options.pageSize=siz;
                    userAjaxFunction(userquerydata);
                });
            }
        };
        var init = function(parm){
            viewModel.resId = parm[0];
            viewModel.timeDay();
            viewModel.load();
            viewModel.pagination.init();
            viewModel.headform2.createEmptyRow(); //创建空行
            viewModel.headform2.setRowSelect(0);
            $(".tasklist-laycontent .ac_input").val(taskwayname);
            viewModel.headform2.on('dataSourceId.valueChange', function (ele) {
                var compId = ele.newValue;
                var rows =  viewModel.headform2.getChangedRows();
                if (compId) {
                    viewModel.taskwayid(compId);
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: $ctx+taskparmUrl+compId,
                        async: false,
                        success: function (res) {
                            if(res.status==1)
                            {
                                viewModel.ruledatalist.setSimpleData(res.taskWayParam);
                            }
                        }
                    });
                }
                viewModel.headform2.setValue("dataSourceId", "");
            });
        };
        return {
            'viewModel' : viewModel,
            'template' : template,
            'init':init

        };

    });