define([ 'jquery', 'text!pages/tasklog/man/list.html',"dialogmin"], function($, template,dialogmin) {
    var getgroupUrl = '/taskgroup/findAllTaskGroup.do';//获取分组列表
    var getlistUrl = '/task/searchTask.do';//获取任务列表
    var getAllLoglistUrl = '/tasklog/getTaskLogVO.do';//获取全部日志列表
    var getsearchLoglistUrl = '/task/searchTask.do';//获取搜索日志列表
    var getLoglistUrl = '/tasklog/getTaskLogVOByTaskId.do';//获取单个任务日志列表
    var getsysLoglistUrl = '/tasklog/getTaskLogVOBySystemDefaultGroup.do';//获取默认日志列表
    var showdetailUrl = '/tmp/logdetail/detail/:resId/:pagenum';//详情
    var tasklogUrl = "/tasklog/getTaskLogVOByTaskLogID.do?tasklogid=";

    addRouter(showdetailUrl);

    var viewModel = {
        data : ko.observable({}),
        datalist : ko.observable({}),
        dataloglist:{
            content : ko.observableArray([]),
            totalPages : ko.observable(0),
            number : ko.observable(0)
        },
        setData : function(data) {
            this.dataloglist.content(data.tasklogVOs);
            this.dataloglist.totalPages(data.totalPage);
            this.dataloglist.number(data.number);
        },
        number:ko.observable(""),
        lognumber:ko.observable(""),
        logdata :  ko.observable({}),
        picdata :  ko.observable([]),
        gid:"",
        taskid:"",
        searchflag:"",
        searchtaskid:"",
        sysflag:""
    };
    viewModel.showSreach = function(){
        var tasklog = $(".tasklog-search");

        if(tasklog.css("display")=="none"){
            tasklog.show();
            $(".tasklog-search-left").show();
            viewModel.tasklist(viewModel.gid,1);
        }else{
            tasklog.hide();
        }

    };
    viewModel.closeSreach = function(){
        $(".tasklog-search").hide();
        $(".tasklog-search-left").show();
    	$(".tasklog-search-right").removeClass("havesreach");
    };
    viewModel.detail = function(id){
        $(".Upview_con").css("display","block");
        $.ajax({
            type : 'get',
            url : $ctx + tasklogUrl+ id,
            dataType : 'json',
            success : function(res) {
                viewModel.logdata(res.tasklogVOs[0])
            }
        });
    };
    viewModel.goback = function(){//返回
        var id="0";
        window.router.setRoute('/task/man/list/'+id);
    };
    viewModel.gobacklist=function(){
        $(".Upview_con").css("display","none");
    };
    viewModel.load = function(){
        $.ajax({
            type : 'get',
            url : $ctx + getgroupUrl+"?systemId="+$systemId,
            cache:false,
            dataType : 'json',
            success : function(res) {
                if(res.status==1){
                    viewModel.data(res.groups);
                    viewModel.tasklist(res.groups[0].gid,1);
                    $(".tasklog-search-left ul li").eq(0).addClass("active");
                    $(".tasklog-search-left ul li").each(function(e){
                        var _this = $(this);
                        _this.click(function(){
                            $(".tasklog-search-left ul li").removeClass("active");
                            $(".systeam").removeClass("active");
                            $(this).addClass("active");
                            viewModel.tasklist(res.groups[e].gid,1);
                        })
                    })
                }else{
                    dialogmin(res.msg);
                }
            }
        });

        //搜索框添加回车事件
        
        $("#searchTaskInput").keypress(function(e){
            if(e.keyCode == 13) {
                // 回车
            viewModel.searchTask();
              }
            });
    }
    viewModel.searchTask = function(){
        var taskNameval = $("#searchTaskInput").val();
        if(taskNameval==""){
            dialogmin("请输入搜索关键字")
            return false
        }
        var queryData = {
            taskName:taskNameval,
            pageSize: 1000,     //page size 每页显示条数
            pageCurrent: 1    //page num 当前页数
            //systemId:$systemId
        };
        $.ajax({
            type : 'get',
            url : $ctx + getsearchLoglistUrl,
            cache:false,
            data:queryData,
            dataType : 'json',
            success : function(res) {
            	$(".tasklog-search-left").hide();
            	$(".tasklog-search-right").addClass("havesreach");
                viewModel.datalist(res.tasks);
                $("#searchTaskInput").val("")
            }
        });
    };
    viewModel.tasklist = function(gid,pageIndex){
        var queryData = {
            gid:gid,
            pageSize: 1000,     //page size 每页显示条数
            pageCurrent: pageIndex    //page num 当前页数
            //systemId:$systemId
        };

        $.ajax({
            type : 'get',
            url : $ctx + getlistUrl,
            cache:false,
            data:queryData,
            dataType : 'json',
            success : function(res) {

                viewModel.datalist(res.tasks);
                viewModel.number(res.number)
                viewModel.gid=gid;

            }
        });
    };
    viewModel.allloglist = function(pageIndex,pageS){
        var queryData = {
            pageSize: pageS||10,     //page size 每页显示条数
            pageCurrent: pageIndex    //page num 当前页数
        };
        $.ajax({
            type : 'get',
            url : $ctx + getAllLoglistUrl,
            cache:false,
            data:queryData,
            dataType : 'json',
            success : function(res) {
                viewModel.setData(res);
                viewModel.lognumber(res.number);
                viewModel.sysflag=0;
                var totalcount=res.totalNumber;
                var pagesize=pageS||viewModel.pagination.ele.options.pageSize;
                var pagenum=pageIndex;
                var totalpage=Math.ceil(totalcount/pagesize);
                /*更新分页*/
                viewModel.pagination.ele.update({
                    totalPages:totalpage,
                    pageSize:pagesize,
                    currentPage:pagenum,
                    totalCount:totalcount
                });

                /*$("#pagination").pagination({
                    totalPages : viewModel.dataloglist.totalPages(),
                    currentPage : viewModel.dataloglist.number(),
                    page : function(page) {
                        viewModel.allloglist(page);

                    }
                });*/
            }
        });
    };
    viewModel.oneloglist = function (pageIndex, selectPageSize){
        var queryData = {
            taskid:viewModel.taskid,
            pageSize: selectPageSize || 9,     //page size 每页显示条数
            pageCurrent: pageIndex    //page num 当前页数
        };
        $.ajax({
            type : 'get',
            url : $ctx + getLoglistUrl,
            cache:false,
            data:queryData,
            dataType : 'json',
            success : function(res) {
                viewModel.setData(res);
                viewModel.lognumber(res.number);
                viewModel.sysflag=0;
                if(res.tasklogVOs.length==0){
                    $('.notasklog').show();
                    $(".tasklog-main-top").hide();
                }
                var totalcount=res.totalNumber;
                var pagesize=selectPageSize||viewModel.pagination.ele.options.pageSize;
                var pagenum=pageIndex;
                var totalpage = Math.ceil(totalcount / queryData.pageSize);
                /*更新分页*/
                var lastNum = totalcount % queryData.pageSize, lastPageIndex = Math.round(totalcount / queryData.pageSize);
                viewModel.pagination.ele.update({
                    totalPages:totalpage,
                    pageSize: queryData.pageSize,
                    currentPage:pagenum,
                    totalCount:totalcount
                });

            }
        });
    };
    viewModel.systasklog = function(pageIndex){
        $(".aside-nav li").removeClass("active");
        $(".systeam").addClass("active");
        var queryData = {
            pageSize: 10,     //page size 每页显示条数
            pageCurrent: pageIndex   //page num 当前页数
        };
        $.ajax({
            type : 'get',
            url : $ctx + getsysLoglistUrl,
            cache:false,
            data:queryData,
            dataType : 'json',
            success : function(res) {
                viewModel.setData(res);
                viewModel.lognumber(res.number);
                viewModel.sysflag=1;
                $(".tasklog-search").hide();
                if(res.tasklogVOs.length==0){
                    $('.notasklog').show();
                    $(".tasklog-main-top").hide();
                }else{
                    $('.notasklog').hide();
                    $(".tasklog-main-top").show();
                }
                /* $("#pagination").pagination({
                 totalPages : viewModel.dataloglist.totalPages(),
                 currentPage : viewModel.dataloglist.number(),
                 page : function(page) {
                 viewModel.allloglist(page);
                 }
                 });*/
                var totalcount=res.totalNumber;
                var pagesize=viewModel.pagination.ele.options.pageSize;
                var pagenum=res.number;
                var totalpage=Math.ceil(totalcount/pagesize);
                /*更新分页*/
                viewModel.pagination.ele.update({
                    totalPages:totalpage,
                    pageSize:pagesize,
                    currentPage:pagenum,
                    totalCount:totalcount
                });
            }
        });
    };
    viewModel.searchtasklog = function(id,pageIndex){
        var queryData = {
            taskid:id,
            pageSize: 10,     //page size 每页显示条数
            pageCurrent: pageIndex    //page num 当前页数
        };
        $.ajax({
            type : 'get',
            url : $ctx + getLoglistUrl,
            cache:false,
            data:queryData,
            dataType : 'json',
            success : function(res) {
                viewModel.setData(res);
                viewModel.lognumber(res.number);
                viewModel.searchflag=1;
                viewModel.searchtaskid=id;
                viewModel.sysflag=0;
                $(".tasklog-search").hide();
                if(res.tasklogVOs.length==0){
                    $('.notasklog').show();
                    $(".tasklog-main-top").hide();
                }else{
                    $('.notasklog').hide();
                    $(".tasklog-main-top").show();
                }
               /* $("#pagination").pagination({
                    totalPages : viewModel.dataloglist.totalPages(),
                    currentPage : viewModel.dataloglist.number(),
                    page : function(page) {
                        viewModel.allloglist(page);
                    }
                });*/
                $(".tasklog-search-right").removeClass("havesreach");
                var totalcount=res.totalNumber;
                var pagesize=viewModel.pagination.ele.options.pageSize;
                var pagenum=res.number;
                var totalpage=Math.ceil(totalcount/pagesize);
                /*更新分页*/
                viewModel.pagination.ele.update({
                    totalPages:totalpage,
                    pageSize:pagesize,
                    currentPage:pagenum,
                    totalCount:totalcount
                });

            }
        });
    };
    viewModel.searchPage = function() {
        this.load();
    };
    /*分页控件*/
    viewModel.pagination={
        element:null,
        init:function(){
            var element = $('#pagination')[0];
            this.ele= new u.pagination({el:element,jumppage:true});
            this.ele.update({
                pageSize:10,
                currentPage:1
            });//默认设置当前页码及pageSize
            this.ele.options.pageList=[10,20,50];//显示条数选择，默认只能选10
            this.ele.on('pageChange', function (currentPage) {
                var userquerydata={
                    pagenum:currentPage+1,
                    pagesize:viewModel.pagination.ele.options.pageSize/*,
                    search:srchval*/
                };
                userAjaxFunction(userquerydata);
            });
            this.ele.on('sizeChange', function (siz) {
                var userquerydata={
                    pagenum:1,
                    pagesize:siz/*,
                    search:srchval*/
                };
                userAjaxFunction(userquerydata);
            });
        }
    };
    var userAjaxFunction = function(userquerydata){
        if(viewModel.sysflag==1){
            viewModel.systasklog(userquerydata.pagenum);
        }else{
            if(viewModel.searchflag==1){
                viewModel.searchtasklog(viewModel.searchtaskid,userquerydata.pagenum);
            }else{
                if(viewModel.taskid=="all"){
                    viewModel.allloglist(userquerydata.pagenum, userquerydata.pagesize);
                }else{
                    viewModel.oneloglist(userquerydata.pagenum, userquerydata.pagesize)
                }
            }
        }

    };
    var init = function(parm) {
        viewModel.load();
        viewModel.taskid = parm[0];
        viewModel.pagination.init();
        if(viewModel.taskid=="all"){
            viewModel.allloglist(1);
        }else{
            viewModel.oneloglist(1)
        }
    };

    return {
        'viewModel' : viewModel,
        'template' : template,
        'init' : init
    };

});