/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.web.cache.redis;

import com.yonyou.web.esapi.EncryptException;
import com.yonyou.web.utils.SerializUtil;
import com.yonyou.web.utils.StringUtils;
import com.yonyou.web.utils.TokenGenerator;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.JedisUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public class RedisCacheManager {
    protected Logger logger = Logger.getLogger(this.getClass());
    private JedisTemplate jedisTemplate;

    public JedisTemplate getJedisTemplate() {
        return this.jedisTemplate;
    }

    public void setJedisTemplate(JedisTemplate jedisTemplate) {
        this.jedisTemplate = jedisTemplate;
    }

    public String findSeed() throws EncryptException {
        String seed = this.getSeedValue("token_seed");
        if (StringUtils.isBlank((String)seed)) {
            seed = TokenGenerator.genSeed();
            this.jedisTemplate.set("token_seed", seed);
        }
        return seed;
    }

    public String getSeedValue(String key) {
        return this.jedisTemplate.get(key);
    }

    public <T extends Serializable> void putTimedCache(String key, T value, int timeout) {
        this.setex(key, value, timeout);
    }

    public <T extends Serializable> void set(final String key, final T value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName("UTF-8"));
                byte[] valueBytes = SerializUtil.objectToByte(value);
                jedis.set(keyBytes, valueBytes);
            }
        });
    }

    public <T extends Serializable> void setex(final String key, final T value, final int timeout) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] valueBytes = SerializUtil.objectToByte(value);
                byte[] keyBytes = key.getBytes(Charset.forName("UTF-8"));
                jedis.setex(keyBytes, timeout, valueBytes);
            }
        });
    }

    public void expire(final String key, final int timeout) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.expire(key, timeout);
            }
        });
    }

    public Boolean exists(final String key) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.exists(key);
            }
        });
    }

    public <T extends Serializable> T get(final String key) {
        return (T)((Serializable)this.execute(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName("UTF-8"));
                if (keyBytes == null) {
                    return null;
                }
                byte[] valueBytes = jedis.get(keyBytes);
                if (valueBytes == null) {
                    return null;
                }
                return (Serializable)SerializUtil.byteToObject(valueBytes);
            }
        }));
    }

    public <T extends Serializable> T hget(final String key, final String fieldName) {
        return (T)((Serializable)this.execute(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                byte[] fieldBytes;
                byte[] keyBytes = key.getBytes(Charset.forName("UTF-8"));
                byte[] attrBytes = jedis.hget(keyBytes, fieldBytes = fieldName.getBytes(Charset.forName("UTF-8")));
                if (attrBytes == null) {
                    return null;
                }
                return (Serializable)SerializUtil.byteToObject(attrBytes);
            }
        }));
    }

    public Map<byte[], byte[]> hgetAll(final String key) {
        return this.execute(new JedisAction<Map<byte[], byte[]>>(){

            @Override
            public Map<byte[], byte[]> action(Jedis jedis) {
                return jedis.hgetAll(key.getBytes(Charset.forName("UTF-8")));
            }
        });
    }

    public <T extends Serializable> void hset(final String key, final String fieldName, final T value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName("UTF-8"));
                byte[] fieldBytes = fieldName.getBytes(Charset.forName("UTF-8"));
                byte[] valueBytes = SerializUtil.objectToByte(value);
                jedis.hset(keyBytes, fieldBytes, valueBytes);
            }
        });
    }

    public <T extends Serializable> void hdel(final String key, final String fieldName) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName("UTF-8"));
                byte[] fieldBytes = fieldName.getBytes(Charset.forName("UTF-8"));
                jedis.hdel(keyBytes, (byte[][])new byte[][]{fieldBytes});
            }
        });
    }

    public void removeCache(String key) {
        if (!StringUtils.isBlank((String)key)) {
            this.jedisTemplate.del(new String[]{key});
        }
    }

    public <T> T execute(JedisAction<T> jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisTemplate.getJedisPool().getResource();
            T t = jedisAction.action(jedis);
            return t;
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public void execute(JedisActionNoResult jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisTemplate.getJedisPool().getResource();
            jedisAction.action(jedis);
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleJedisException(JedisException jedisException) {
        if (jedisException instanceof JedisConnectionException) {
            this.logger.error((Object)("Redis connection " + this.jedisTemplate.getJedisPool().getAddress() + " lost."), (Throwable)jedisException);
            return true;
        } else if (jedisException instanceof JedisDataException) {
            if (jedisException.getMessage() == null || jedisException.getMessage().indexOf("READONLY") == -1) return false;
            this.logger.error((Object)("Redis connection " + this.jedisTemplate.getJedisPool().getAddress() + " are read-only slave."), (Throwable)jedisException);
            return true;
        } else {
            this.logger.error((Object)"Jedis exception happen.", (Throwable)jedisException);
        }
        return true;
    }

    protected void closeResource(Jedis jedis, boolean conectionBroken) {
        try {
            if (conectionBroken) {
                this.jedisTemplate.getJedisPool().returnBrokenResource(jedis);
            } else {
                this.jedisTemplate.getJedisPool().returnResource(jedis);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"return back jedis failed, will fore close the jedis.", (Throwable)e);
            JedisUtils.destroyJedis((Jedis)jedis);
        }
    }

    public static interface JedisActionNoResult {
        public void action(Jedis var1);
    }

    public static interface JedisAction<T> {
        public T action(Jedis var1);
    }
}

