/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.web.cache.session;

import com.yonyou.web.cache.redis.RedisCacheManager;
import com.yonyou.web.utils.StringUtils;
import java.io.Serializable;

public class SessionCacheManager
extends RedisCacheManager {
    public static final String USER_INFO_LOGIN = "ubpm.user.info.login";
    private int sessionTimeout = 3600;

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public <T extends Serializable> void putUserCache(String key, T value) {
        this.putTimedCache(key, value, this.sessionTimeout);
    }

    public <T extends Serializable> void cacheUser(String uname, T user) {
        this.putUserCache(this.createUserCacheKey(uname), user);
    }

    public <T extends Serializable> T getUserCache(String key) {
        boolean isExist = this.exists(key);
        T result = null;
        if (isExist) {
            this.expire(key, this.sessionTimeout);
            result = this.get(key);
        }
        return result;
    }

    public <T extends Serializable> T getUser(String uname) {
        return StringUtils.isNotBlank((String)uname) ? (T)this.getUserCache(this.createUserCacheKey(uname)) : null;
    }

    public <T extends Serializable> void disCacheUser(String uname) {
        this.removeCache(this.createUserCacheKey(uname));
    }

    private String createUserCacheKey(String uname) {
        return new StringBuffer(USER_INFO_LOGIN).append(":").append(uname).toString();
    }
}

