/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.web.esapi;

import com.yonyou.web.esapi.EncryptException;
import java.io.IOException;
import javax.crypto.SecretKey;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Encryptor;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.IntegrityException;

public class IEOPEncryptor {
    private static final Encryptor encryptor = ESAPI.encryptor();
    private static final Encoder encoder = ESAPI.encoder();
    private static final int hash_iterations = 1024;

    public String encrypt(String text) throws EncryptException {
        PlainText plainText = new PlainText(text);
        try {
            CipherText cipherText = encryptor.encrypt(plainText);
            return encoder.encodeForBase64(cipherText.asPortableSerializedByteArray(), false);
        }
        catch (EncryptionException e) {
            throw new EncryptException(e);
        }
    }

    public String encrypt(SecretKey key, String text) throws EncryptException {
        PlainText plainText = new PlainText(text);
        CipherText cipherText = null;
        try {
            cipherText = encryptor.encrypt(key, plainText);
            return encoder.encodeForBase64(cipherText.asPortableSerializedByteArray(), false);
        }
        catch (EncryptionException e) {
            throw new EncryptException(e);
        }
    }

    public String decrypt(byte[] data) throws EncryptException {
        try {
            PlainText plainText = encryptor.decrypt(CipherText.fromPortableSerializedBytes((byte[])data));
            return plainText.toString();
        }
        catch (EncryptionException e) {
            throw new EncryptException(e);
        }
    }

    public String decrypt(String text) throws IOException, EncryptException {
        byte[] data = encoder.decodeFromBase64(text);
        return this.decrypt(data);
    }

    public String decrypt(SecretKey key, byte[] data) throws EncryptException {
        try {
            PlainText plainText = encryptor.decrypt(key, CipherText.fromPortableSerializedBytes((byte[])data));
            return plainText.toString();
        }
        catch (EncryptionException e) {
            throw new EncryptException(e);
        }
    }

    public String decrypt(SecretKey key, String text) throws EncryptException, IOException {
        byte[] data = encoder.decodeFromBase64(text);
        return this.decrypt(key, data);
    }

    public String hash(String text, String salt) throws EncryptException {
        return this.hash(text, salt, 1024);
    }

    public String hash(String text, String salt, int iterations) throws EncryptException {
        try {
            return encryptor.hash(text, salt, iterations);
        }
        catch (EncryptionException e) {
            throw new EncryptException(e);
        }
    }

    public String sign(String text) throws EncryptException {
        try {
            return encryptor.sign(text);
        }
        catch (EncryptionException e) {
            throw new EncryptException(e);
        }
    }

    public boolean verifySignature(String sign, String data) {
        return encryptor.verifySignature(sign, data);
    }

    public String seal(String text, long expiration) throws EncryptException {
        try {
            return encryptor.seal(text, expiration);
        }
        catch (IntegrityException e) {
            throw new EncryptException(e);
        }
    }

    public String unseal(String text) throws EncryptException {
        try {
            return encryptor.unseal(text);
        }
        catch (EncryptionException e) {
            throw new EncryptException(e);
        }
    }

    public long getCurrentTime() {
        return encryptor.getTimeStamp();
    }

    public long getRelativeTime(long offset) {
        return encryptor.getRelativeTimeStamp(offset);
    }
}

