/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.web.utils;

import com.yonyou.web.utils.CookieUtil;
import com.yonyou.web.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class HttpUtil {
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_TOKEN = "authorization";
    public static final String PARAM_DIGEST = "digest";

    public static boolean isAjax(ServletRequest request) {
        HttpServletRequest rq;
        String requestType;
        boolean isAjax = false;
        if (request instanceof HttpServletRequest && (requestType = (rq = (HttpServletRequest)request).getHeader("X-Requested-With")) != null && "XMLHttpRequest".equals(requestType)) {
            isAjax = true;
        }
        return isAjax;
    }

    public static String getRequestToken(ServletRequest request) {
        String tokenStr = null;
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String cookie = httpRequest.getHeader("cookie");
            if (StringUtils.isNotBlank((String)cookie)) {
                int start = cookie.lastIndexOf(PARAM_TOKEN);
                if (start >= 0) {
                    int end = cookie.indexOf(";", start);
                    tokenStr = end < 0 ? cookie.substring(start).replace("authorization=", "") : cookie.substring(start, end).replace("authorization=", "");
                }
                try {
                    if (tokenStr != null && tokenStr.indexOf("%") != -1) {
                        tokenStr = URLDecoder.decode(tokenStr, "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    tokenStr = null;
                    Logger.getLogger(HttpUtil.class).error((Object)e);
                }
            }
            if (StringUtils.isBlank(tokenStr)) {
                tokenStr = CookieUtil.findCookieValue(httpRequest.getCookies(), PARAM_TOKEN);
            }
        }
        return tokenStr;
    }
}

