/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.web.utils;

import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RSAUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAUtils.class);
    private static final String ALGORITHOM = "RSA";
    private static final int KEY_SIZE = 1024;
    private static final Provider DEFAULT_PROVIDER = new BouncyCastleProvider();
    private static KeyPairGenerator keyPairGen = null;
    private static KeyFactory keyFactory = null;
    private static KeyPair oneKeyPair = null;

    private RSAUtils() {
    }

    public static synchronized KeyPair generateKeyPair() {
        try {
            keyPairGen.initialize(1024, new SecureRandom(DateFormatUtils.format((long)System.currentTimeMillis(), (String)"yyyyMMdd").getBytes()));
            oneKeyPair = keyPairGen.generateKeyPair();
            return oneKeyPair;
        }
        catch (InvalidParameterException ex) {
            LOGGER.error("KeyPairGenerator does not support a key length of 1024.", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            LOGGER.error("RSAUtils#KEY_PAIR_GEN is null, can not generate KeyPairGenerator instance.", (Throwable)ex);
        }
        return null;
    }

    public static KeyPair getKeyPair() {
        return oneKeyPair;
    }

    public static void setKeyPair(KeyPair redisKeyPair) {
        oneKeyPair = redisKeyPair;
    }

    public static RSAPublicKey generateRSAPublicKey(byte[] modulus, byte[] publicExponent) {
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(publicExponent));
        try {
            return (RSAPublicKey)keyFactory.generatePublic(publicKeySpec);
        }
        catch (InvalidKeySpecException ex) {
            LOGGER.error("RSAPublicKeySpec is unavailable.", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            LOGGER.error("RSAUtils#KEY_FACTORY is null, can not generate KeyFactory instance.", (Throwable)ex);
        }
        return null;
    }

    public static RSAPrivateKey generateRSAPrivateKey(byte[] modulus, byte[] privateExponent) {
        RSAPrivateKeySpec privateKeySpec = new RSAPrivateKeySpec(new BigInteger(modulus), new BigInteger(privateExponent));
        try {
            return (RSAPrivateKey)keyFactory.generatePrivate(privateKeySpec);
        }
        catch (InvalidKeySpecException ex) {
            LOGGER.error("RSAPrivateKeySpec is unavailable.", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            LOGGER.error("RSAUtils#KEY_FACTORY is null, can not generate KeyFactory instance.", (Throwable)ex);
        }
        return null;
    }

    public static RSAPrivateKey getRSAPrivateKey(String hexModulus, String hexPrivateExponent) {
        if (StringUtils.isBlank((String)hexModulus) || StringUtils.isBlank((String)hexPrivateExponent)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("hexModulus and hexPrivateExponent cannot be empty. RSAPrivateKey value is null to return.");
            }
            return null;
        }
        byte[] modulus = null;
        byte[] privateExponent = null;
        try {
            modulus = Hex.decodeHex((char[])hexModulus.toCharArray());
            privateExponent = Hex.decodeHex((char[])hexPrivateExponent.toCharArray());
        }
        catch (DecoderException ex) {
            LOGGER.error("hexModulus or hexPrivateExponent value is invalid. return null(RSAPrivateKey).");
        }
        if (modulus != null && privateExponent != null) {
            return RSAUtils.generateRSAPrivateKey(modulus, privateExponent);
        }
        return null;
    }

    public static RSAPublicKey getRSAPublidKey(String hexModulus, String hexPublicExponent) {
        if (StringUtils.isBlank((String)hexModulus) || StringUtils.isBlank((String)hexPublicExponent)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("hexModulus and hexPublicExponent cannot be empty. return null(RSAPublicKey).");
            }
            return null;
        }
        byte[] modulus = null;
        byte[] publicExponent = null;
        try {
            modulus = Hex.decodeHex((char[])hexModulus.toCharArray());
            publicExponent = Hex.decodeHex((char[])hexPublicExponent.toCharArray());
        }
        catch (DecoderException ex) {
            LOGGER.error("hexModulus or hexPublicExponent value is invalid. return null(RSAPublicKey).");
        }
        if (modulus != null && publicExponent != null) {
            return RSAUtils.generateRSAPublicKey(modulus, publicExponent);
        }
        return null;
    }

    public static byte[] encrypt(PublicKey publicKey, byte[] data) throws Exception {
        Cipher ci = Cipher.getInstance(ALGORITHOM, DEFAULT_PROVIDER);
        ci.init(1, publicKey);
        return ci.doFinal(data);
    }

    public static byte[] decrypt(PrivateKey privateKey, byte[] data) throws Exception {
        Cipher ci = Cipher.getInstance(ALGORITHOM, DEFAULT_PROVIDER);
        ci.init(2, privateKey);
        return ci.doFinal(data);
    }

    public static String encryptString(PublicKey publicKey, String plaintext) {
        if (publicKey == null || plaintext == null) {
            return null;
        }
        byte[] data = plaintext.getBytes();
        try {
            byte[] en_data = RSAUtils.encrypt(publicKey, data);
            return new String(Hex.encodeHex((byte[])en_data));
        }
        catch (Exception ex) {
            LOGGER.error(ex.getCause().getMessage());
            return null;
        }
    }

    public static String encryptString(String plaintext) {
        if (plaintext == null) {
            return null;
        }
        byte[] data = plaintext.getBytes();
        KeyPair keyPair = RSAUtils.getKeyPair();
        try {
            byte[] en_data = RSAUtils.encrypt((RSAPublicKey)keyPair.getPublic(), data);
            return new String(Hex.encodeHex((byte[])en_data));
        }
        catch (NullPointerException ex) {
            LOGGER.error("keyPair cannot be null.");
        }
        catch (Exception ex) {
            LOGGER.error(ex.getCause().getMessage());
        }
        return null;
    }

    public static String decryptString(PrivateKey privateKey, String encrypttext) {
        if (privateKey == null || StringUtils.isBlank((String)encrypttext)) {
            return null;
        }
        try {
            byte[] en_data = Hex.decodeHex((char[])encrypttext.toCharArray());
            byte[] data = RSAUtils.decrypt(privateKey, en_data);
            return new String(data);
        }
        catch (Exception ex) {
            LOGGER.error(String.format("\"%s\" Decryption failed. Cause: %s", encrypttext, ex.getCause().getMessage()));
            return null;
        }
    }

    public static String decryptString(String encrypttext) {
        if (StringUtils.isBlank((String)encrypttext)) {
            return null;
        }
        KeyPair keyPair = RSAUtils.getKeyPair();
        try {
            byte[] en_data = Hex.decodeHex((char[])encrypttext.toCharArray());
            byte[] data = RSAUtils.decrypt((RSAPrivateKey)keyPair.getPrivate(), en_data);
            return new String(data);
        }
        catch (NullPointerException ex) {
            LOGGER.error("keyPair cannot be null.");
        }
        catch (Exception ex) {
            LOGGER.error(String.format("\"%s\" Decryption failed. Cause: %s", encrypttext, ex.getMessage()));
        }
        return null;
    }

    public static String decryptStringByJs(String encrypttext) {
        String text = RSAUtils.decryptString(encrypttext);
        if (text == null) {
            return null;
        }
        return StringUtils.reverse((String)text);
    }

    public static RSAPublicKey getDefaultPublicKey() {
        KeyPair keyPair = RSAUtils.getKeyPair();
        if (keyPair != null) {
            return (RSAPublicKey)keyPair.getPublic();
        }
        return null;
    }

    public static RSAPrivateKey getDefaultPrivateKey() {
        KeyPair keyPair = RSAUtils.getKeyPair();
        if (keyPair != null) {
            return (RSAPrivateKey)keyPair.getPrivate();
        }
        return null;
    }

    static {
        try {
            keyPairGen = KeyPairGenerator.getInstance(ALGORITHOM, DEFAULT_PROVIDER);
            keyFactory = KeyFactory.getInstance(ALGORITHOM, DEFAULT_PROVIDER);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error(ex.getMessage());
        }
    }
}

