/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
public class DataBindingProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private DataBinding binding;

    public DataBindingProvider() {
    }

    public DataBindingProvider(DataBinding db) {
        this.binding = db;
    }

    public void setDataBinding(DataBinding db) {
        this.binding = db;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return true;
    }

    public Object readFrom(Class<Object> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            XMLStreamReader reader = this.createReader(clazz, genericType, is);
            DataReader<XMLStreamReader> dataReader = this.binding.createReader(XMLStreamReader.class);
            return dataReader.read(null, reader, clazz);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    protected XMLStreamReader createReader(Class<?> clazz, Type genericType, InputStream is) throws Exception {
        return StaxUtils.createXMLStreamReader(is);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (byte[].class.isAssignableFrom(t.getClass())) {
            return ((byte[])t).length;
        }
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return true;
    }

    public void writeTo(Object o, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            XMLStreamWriter writer = this.createWriter(clazz, genericType, os);
            this.writeToWriter(writer, o);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    protected void writeToWriter(XMLStreamWriter writer, Object o) throws Exception {
        DataWriter<XMLStreamWriter> dataWriter = this.binding.createWriter(XMLStreamWriter.class);
        dataWriter.write(o, writer);
        writer.flush();
    }

    protected XMLStreamWriter createWriter(Class<?> clazz, Type genericType, OutputStream os) throws Exception {
        return StaxUtils.createXMLStreamWriter(os);
    }
}

