/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.corba.common.idltypes.CorbaUtils;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefnImplBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlOperation;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopedName;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdlParam
extends IdlDefnImplBase {
    private static final Logger LOG = LogUtils.getL7dLogger(IdlParam.class);
    private IdlType type;
    private String mode;

    private IdlParam(IdlOperation parent, String name, IdlType typeType, String modeValue) {
        super(parent, name);
        this.type = typeType;
        this.mode = new String(modeValue);
    }

    public static IdlParam create(IdlOperation parent, String name, IdlType type, String mode) {
        name = CorbaUtils.mangleName(name);
        return new IdlParam(parent, name, type, mode);
    }

    @Override
    public void write(PrintWriter pw) {
        if (!this.type.isEmptyDef()) {
            IdlScopedName sn = this.definedIn().scopeName();
            pw.print(IdlParam.indent() + this.mode + " " + this.type.fullName(sn) + " " + this.localName());
        } else {
            LOG.log(Level.WARNING, "Ignoring Param " + this.localName() + " with Empty Type");
        }
    }

    @Override
    public boolean isEmptyDef() {
        return this.type.isEmptyDef();
    }

    @Override
    public IdlScopeBase getCircularScope(IdlScopeBase startScope, List<Object> doneDefn) {
        return this.type.getCircularScope(startScope, doneDefn);
    }
}

