/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.xss.core;

import java.io.IOException;
import net.dreamlu.mica.core.spring.SpringContextUtil;
import net.dreamlu.mica.xss.config.MicaXssProperties;
import net.dreamlu.mica.xss.core.XssCleanDeserializerBase;
import net.dreamlu.mica.xss.core.XssCleaner;
import net.dreamlu.mica.xss.core.XssType;
import net.dreamlu.mica.xss.utils.XssUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssCleanDeserializer
extends XssCleanDeserializerBase {
    private static final Logger log = LoggerFactory.getLogger(XssCleanDeserializer.class);

    @Override
    public String clean(String name, String text) throws IOException {
        MicaXssProperties properties = (MicaXssProperties)SpringContextUtil.getBean(MicaXssProperties.class);
        if (properties == null) {
            return text;
        }
        XssCleaner xssCleaner = (XssCleaner)SpringContextUtil.getBean(XssCleaner.class);
        if (xssCleaner == null) {
            return XssUtil.trim(text, properties.isTrimText());
        }
        String value = xssCleaner.clean(name, XssUtil.trim(text, properties.isTrimText()), XssType.JACKSON);
        log.debug("Json property name:{} value:{} cleaned up by mica-xss, current value is:{}.", new Object[]{name, text, value});
        return value;
    }
}

