/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.xss.core;

import java.util.Objects;
import net.dreamlu.mica.xss.core.XssCleanIgnore;
import org.springframework.util.ObjectUtils;

public class XssHolder {
    private static final ThreadLocal<XssCleanIgnore> TL = new ThreadLocal();

    public static boolean isEnabled() {
        return Objects.isNull(TL.get());
    }

    static boolean isIgnore(String name) {
        XssCleanIgnore cleanIgnore = TL.get();
        if (cleanIgnore == null) {
            return false;
        }
        Object[] ignoreArray = cleanIgnore.value();
        return ObjectUtils.containsElement((Object[])ignoreArray, (Object)name);
    }

    static void setIgnore(XssCleanIgnore xssCleanIgnore) {
        TL.set(xssCleanIgnore);
    }

    public static void remove() {
        TL.remove();
    }
}

